/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import latmod.lib.LMUtils;
import net.minecraft.util.ResourceLocation;

public final class TextureCoords {
    public static final TextureCoords nullTexture = new TextureCoords(null, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public final ResourceLocation texture;
    public final double posX;
    public final double posY;
    public final double width;
    public final double height;
    public final double textureW;
    public final double textureH;
    public final double minU;
    public final double minV;
    public final double maxU;
    public final double maxV;
    private String toString = null;

    public TextureCoords(ResourceLocation res, double x, double y, double w, double h, double tw, double th) {
        this.texture = res;
        this.posX = x;
        this.posY = y;
        this.width = w;
        this.height = h;
        this.textureW = tw;
        this.textureH = th;
        this.minU = this.posX / this.textureW;
        this.minV = this.posY / this.textureH;
        this.maxU = (this.posX + this.width) / this.textureW;
        this.maxV = (this.posY + this.height) / this.textureH;
    }

    public TextureCoords(ResourceLocation res, int x, int y, int w, int h) {
        this(res, x, y, w, h, 256.0, 256.0);
    }

    public static TextureCoords getSquareIcon(ResourceLocation res, int size) {
        return new TextureCoords(res, 0.0, 0.0, size, size, size, size);
    }

    public int posXI() {
        return (int)this.posX;
    }

    public int posYI() {
        return (int)this.posY;
    }

    public int widthI() {
        return (int)this.width;
    }

    public int heightI() {
        return (int)this.height;
    }

    public int hashCode() {
        return LMUtils.hashCode(this.texture, this.posX, this.posY, this.width, this.height);
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.texture);
            sb.append(',');
            sb.append(this.posXI());
            sb.append(',');
            sb.append(this.posYI());
            sb.append(',');
            sb.append(this.widthI());
            sb.append(',');
            sb.append(this.heightI());
            this.toString = sb.toString();
        }
        return this.toString;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        TextureCoords t = (TextureCoords)o;
        return LMUtils.areObjectsEqual(this.texture, t.texture, true) && this.minU == t.minU && this.minV == t.minV && this.maxU == t.maxU && this.maxV == t.maxV;
    }

    public double getWidth(double h) {
        return this.width * (h / this.height);
    }

    public double getHeight(double w) {
        return this.height * (w / this.width);
    }

    public boolean isValid() {
        return this.texture != null && this.width > 0.0 && this.height > 0.0;
    }

    public TextureCoords copy() {
        return new TextureCoords(this.texture, this.posX, this.posY, this.width, this.height, this.textureW, this.textureH);
    }

    public TextureCoords[] split(int x, int y) {
        if (x == 0 || y == 0) {
            return new TextureCoords[0];
        }
        if (x == 1 && y == 1) {
            return new TextureCoords[]{this.copy()};
        }
        if (x == 1) {
            return this.splitY(y);
        }
        if (y == 1) {
            return this.splitX(x);
        }
        TextureCoords[] l = new TextureCoords[x * y];
        TextureCoords[] ly = this.splitY(y);
        for (int y1 = 0; y1 < y; ++y1) {
            l[y1 * x] = ly[y1];
            TextureCoords[] lx = ly[y1].splitX(x);
            for (int x1 = 0; x1 < x; ++x1) {
                l[y1 * x + x1] = lx[x1];
            }
        }
        return l;
    }

    private TextureCoords[] splitX(int s) {
        TextureCoords[] l = new TextureCoords[s];
        double ds = s;
        double d = this.width / ds;
        for (int i = 0; i < s; ++i) {
            l[i] = new TextureCoords(this.texture, this.posX + d * (double)i, this.posY, d, this.height, this.textureW, this.textureH);
        }
        return l;
    }

    private TextureCoords[] splitY(int s) {
        TextureCoords[] l = new TextureCoords[s];
        double ds = s;
        double d = this.height / ds;
        for (int i = 0; i < s; ++i) {
            l[i] = new TextureCoords(this.texture, this.posX, this.posY + d * (double)i, this.width, d, this.textureW, this.textureH);
        }
        return l;
    }
}

