/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import ftb.lib.BroadcastSender;
import ftb.lib.FTBWorld;
import ftb.lib.api.EventFTBReload;
import ftb.lib.api.GameModes;
import ftb.lib.api.ServerTickCallback;
import ftb.lib.api.config.ConfigRegistry;
import ftb.lib.api.notification.Notification;
import ftb.lib.api.tile.IGuiTile;
import ftb.lib.mod.FTBLibEventHandler;
import ftb.lib.mod.FTBLibMod;
import ftb.lib.mod.FTBUIntegration;
import ftb.lib.mod.net.MessageNotifyPlayer;
import ftb.lib.mod.net.MessageOpenGuiTile;
import ftb.lib.mod.net.MessageReload;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import latmod.lib.LMJsonUtils;
import latmod.lib.LMStringUtils;
import latmod.lib.LMUtils;
import latmod.lib.net.LMURLConnection;
import latmod.lib.net.RequestMethod;
import net.minecraft.block.Block;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBLib {
    public static final boolean DEV_ENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static boolean userIsLatvianModder = false;
    public static final Logger dev_logger = LogManager.getLogger((String)"FTBLibDev");
    public static final String FORMATTING = "\u00a7";
    public static final Pattern textFormattingPattern = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final HashMap<String, UUID> cachedUUIDs = new HashMap();
    public static FTBUIntegration ftbu = null;
    public static final EnumChatFormatting[] chatColors = new EnumChatFormatting[]{EnumChatFormatting.BLACK, EnumChatFormatting.DARK_BLUE, EnumChatFormatting.DARK_GREEN, EnumChatFormatting.DARK_AQUA, EnumChatFormatting.DARK_RED, EnumChatFormatting.DARK_PURPLE, EnumChatFormatting.GOLD, EnumChatFormatting.GRAY, EnumChatFormatting.DARK_GRAY, EnumChatFormatting.BLUE, EnumChatFormatting.GREEN, EnumChatFormatting.AQUA, EnumChatFormatting.RED, EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.YELLOW, EnumChatFormatting.WHITE};
    public static File folderConfig;
    public static File folderMinecraft;
    public static File folderModpack;
    public static File folderLocal;
    public static File folderWorld;

    public static void init(File configFolder) {
        folderConfig = configFolder;
        folderMinecraft = folderConfig.getParentFile();
        folderModpack = new File(folderMinecraft, "modpack/");
        folderLocal = new File(folderMinecraft, "local/");
        if (!folderModpack.exists()) {
            folderModpack.mkdirs();
        }
        if (!folderLocal.exists()) {
            folderLocal.mkdirs();
        }
        if (dev_logger instanceof org.apache.logging.log4j.core.Logger) {
            if (DEV_ENV) {
                ((org.apache.logging.log4j.core.Logger)dev_logger).setLevel(Level.ALL);
            } else {
                ((org.apache.logging.log4j.core.Logger)dev_logger).setLevel(Level.OFF);
            }
        } else {
            FTBLibMod.logger.info("DevLogger isn't org.apache.logging.log4j.core.Logger! It's " + dev_logger.getClass().getName());
        }
    }

    public static void reload(ICommandSender sender, boolean printMessage, boolean reloadClient) {
        if (FTBWorld.server == null) {
            return;
        }
        long ms = LMUtils.millis();
        ConfigRegistry.reload();
        GameModes.reload();
        EventFTBReload event = new EventFTBReload(FTBWorld.server, sender, reloadClient);
        if (ftbu != null) {
            ftbu.onReloaded(event);
        }
        event.post();
        if (printMessage) {
            FTBLib.printChat(BroadcastSender.inst, FTBLibMod.mod.chatComponent("reloaded_server", LMUtils.millis() - ms + "ms"));
        }
        new MessageReload(FTBWorld.server, 2).sendTo(null);
    }

    public static IChatComponent getChatComponent(Object o) {
        return o != null && o instanceof IChatComponent ? (IChatComponent)o : new ChatComponentText("" + o);
    }

    public static void addItem(Item i, String name) {
        GameRegistry.registerItem((Item)i, (String)name);
    }

    public static void addBlock(Block b, Class<? extends ItemBlock> c, String name) {
        GameRegistry.registerBlock((Block)b, c, (String)name);
    }

    public static void addBlock(Block b, String name) {
        FTBLib.addBlock(b, ItemBlock.class, name);
    }

    public static void addTileEntity(Class<? extends TileEntity> c, String s, String ... alt) {
        if (alt == null || alt.length == 0) {
            GameRegistry.registerTileEntity(c, (String)s);
        } else {
            GameRegistry.registerTileEntityWithAlternatives(c, (String)s, (String[])alt);
        }
    }

    public static void addEntity(Class<? extends Entity> c, String s, int id, Object mod) {
        EntityRegistry.registerModEntity(c, (String)s, (int)id, (Object)mod, (int)50, (int)1, (boolean)true);
    }

    public static void addWorldGenerator(IWorldGenerator i, int w) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)i, (int)w);
    }

    public static Fluid addFluid(Fluid f) {
        Fluid f1 = FluidRegistry.getFluid((String)f.getName());
        if (f1 != null) {
            return f1;
        }
        FluidRegistry.registerFluid((Fluid)f);
        return f;
    }

    public static void addCommand(FMLServerStartingEvent e, ICommand c) {
        if (c != null && !c.func_71517_b().isEmpty()) {
            e.registerServerCommand(c);
        }
    }

    public static void printChat(ICommandSender ep, Object o) {
        if (ep == null) {
            ep = FTBLibMod.proxy.getClientPlayer();
        }
        if (ep != null) {
            ep.func_145747_a(FTBLib.getChatComponent(o));
        } else {
            System.out.println(o);
        }
    }

    public static MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static Side getEffectiveSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    public static boolean isDedicatedServer() {
        MinecraftServer mcs = FTBLib.getServer();
        return mcs == null ? false : mcs.func_71262_S();
    }

    public static String getPath(ResourceLocation res) {
        return "/assets/" + res.func_110624_b() + "/" + res.func_110623_a();
    }

    public static boolean resourceExists(ResourceLocation res) {
        return FTBLib.class.getResource(FTBLib.getPath(res)) != null;
    }

    public static boolean hasOnlinePlayers() {
        return !FTBLib.getServer().func_71203_ab().field_72404_b.isEmpty();
    }

    public static List<EntityPlayerMP> getAllOnlinePlayers(EntityPlayerMP except) {
        ArrayList<EntityPlayerMP> l = new ArrayList<EntityPlayerMP>();
        if (FTBLib.getEffectiveSide().isClient()) {
            return l;
        }
        if (FTBLib.hasOnlinePlayers()) {
            l.addAll(FTBLib.getServer().func_71203_ab().field_72404_b);
            if (except != null) {
                l.remove(except);
            }
        }
        return l;
    }

    public static Map<UUID, EntityPlayerMP> getAllOnlinePlayersMap() {
        HashMap<UUID, EntityPlayerMP> m = new HashMap<UUID, EntityPlayerMP>();
        if (!FTBLib.hasOnlinePlayers()) {
            return m;
        }
        for (int i = 0; i < FTBLib.getServer().func_71203_ab().field_72404_b.size(); ++i) {
            EntityPlayerMP ep = (EntityPlayerMP)FTBLib.getServer().func_71203_ab().field_72404_b.get(i);
            m.put(ep.func_110124_au(), ep);
        }
        return m;
    }

    public static EntityPlayerMP getPlayerMP(UUID id) {
        if (!FTBLib.hasOnlinePlayers()) {
            return null;
        }
        for (int i = 0; i < FTBLib.getServer().func_71203_ab().field_72404_b.size(); ++i) {
            EntityPlayerMP ep = (EntityPlayerMP)FTBLib.getServer().func_71203_ab().field_72404_b.get(i);
            if (!ep.func_110124_au().equals(id)) continue;
            return ep;
        }
        return null;
    }

    public static List<String> getPlayerNames(boolean online) {
        if (ftbu != null) {
            return Arrays.asList(ftbu.getPlayerNames(online));
        }
        ArrayList<String> l = new ArrayList<String>();
        if (online) {
            List<EntityPlayerMP> players = FTBLib.getAllOnlinePlayers(null);
            for (int j = 0; j < players.size(); ++j) {
                l.add(players.get(j).func_146103_bH().getName());
            }
        } else {
            l.addAll(UsernameCache.getMap().values());
        }
        return l;
    }

    public static boolean remap(FMLMissingMappingsEvent.MissingMapping m, String id, Item i) {
        if (m.type == GameRegistry.Type.ITEM && id.equals(m.name)) {
            m.remap(i);
            return true;
        }
        return false;
    }

    public static boolean remap(FMLMissingMappingsEvent.MissingMapping m, String id, Block b) {
        if (id.equals(m.name)) {
            if (m.type == GameRegistry.Type.BLOCK) {
                m.remap(b);
            } else if (m.type == GameRegistry.Type.ITEM) {
                m.remap(Item.func_150898_a((Block)b));
            }
            return true;
        }
        return false;
    }

    public static boolean isModInstalled(String s) {
        return Loader.isModLoaded((String)s);
    }

    public static String removeFormatting(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return "";
        }
        return textFormattingPattern.matcher(s).replaceAll("");
    }

    public static WorldServer getServerWorld() {
        MinecraftServer ms = FTBLib.getServer();
        if (ms == null || ms.field_71305_c.length == 0) {
            return null;
        }
        return ms.field_71305_c[0];
    }

    public static int runCommand(ICommandSender ics, String s) throws CommandException {
        return FTBLib.getServer().func_71187_D().func_71556_a(ics, s);
    }

    public static int runCommand(ICommandSender ics, String cmd, String[] args) throws CommandException {
        StringBuilder sb = new StringBuilder();
        sb.append(cmd);
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                sb.append(' ');
                sb.append(args[i]);
            }
        }
        return FTBLib.runCommand(ics, sb.toString());
    }

    public static IChatComponent setColor(EnumChatFormatting e, IChatComponent c) {
        c.func_150256_b().func_150238_a(e);
        return c;
    }

    public static void openGui(EntityPlayer ep, IGuiTile t, NBTTagCompound data) {
        if (t == null || !(t instanceof TileEntity) || ep instanceof FakePlayer) {
            return;
        }
        if (ep instanceof EntityPlayerMP) {
            Container c = t.getContainer(ep, data);
            if (c == null) {
                return;
            }
            EntityPlayerMP epM = (EntityPlayerMP)ep;
            epM.func_71117_bO();
            epM.func_71128_l();
            epM.field_71070_bA = c;
            epM.field_71070_bA.field_75152_c = epM.field_71139_cq;
            epM.field_71070_bA.func_75132_a((ICrafting)epM);
            new MessageOpenGuiTile((TileEntity)t, data, epM.field_71139_cq).sendTo(epM);
        } else if (!FTBLib.getEffectiveSide().isServer()) {
            FTBLibMod.proxy.openClientTileGui(ep == null ? FTBLibMod.proxy.getClientPlayer() : ep, t, data);
        }
    }

    public static void addCallback(ServerTickCallback c) {
        if (c.maxTick == 0) {
            c.onCallback();
        } else {
            FTBLibEventHandler.pendingCallbacks.add(c);
        }
    }

    public static boolean isOP(GameProfile p) {
        return !FTBLib.isDedicatedServer() || LMStringUtils.contains(FTBLib.getServer().func_71203_ab().func_152603_m().func_152685_a(), p.getName());
    }

    public static void notifyPlayer(EntityPlayerMP ep, Notification n) {
        new MessageNotifyPlayer(n).sendTo(ep);
    }

    public static List<ICommand> getAllCommands(ICommandSender sender) {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        ArrayList<String> cmdIDs = new ArrayList<String>();
        for (Object o : FTBLib.getServer().func_71187_D().func_71557_a(sender)) {
            ICommand c = (ICommand)o;
            if (cmdIDs.contains(c.func_71517_b())) continue;
            commands.add(c);
            cmdIDs.add(c.func_71517_b());
        }
        return commands;
    }

    public static UUID getPlayerID(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        String key = s.trim().toLowerCase();
        if (!cachedUUIDs.containsKey(key)) {
            cachedUUIDs.put(key, null);
            try {
                String json = new LMURLConnection(RequestMethod.GET, "https://api.mojang.com/users/profiles/minecraft/" + s).connect().asString();
                JsonElement e = LMJsonUtils.fromJson(json);
                cachedUUIDs.put(key, LMUtils.fromString(e.getAsJsonObject().get("id").getAsString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cachedUUIDs.get(key);
    }

    static {
        folderWorld = null;
    }
}

