/*
 * Decompiled with CFR 0.152.
 */
package ak.potionextension.asm;

import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PotionExtensionCorePlugin
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"PotionExtension");
    public static int maxPotionArray = 128;
    public static boolean checkPotion = true;
    public static File mcLoc;
    private static boolean debug;

    public String[] getASMTransformerClass() {
        return new String[]{"ak.potionextension.asm.PotionEffectTransformer", "ak.potionextension.asm.PotionArrayTransformer"};
    }

    public String getModContainerClass() {
        return "ak.potionextension.asm.PotionExtensionCoreContainer";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        if (data.containsKey("mcLocation")) {
            mcLoc = (File)data.get("mcLocation");
            File configLocation = new File(mcLoc, "config");
            File configFile = new File(configLocation, "PotionExtension.cfg");
            this.initConfig(configFile);
        }
    }

    private void initConfig(File configFile) {
        Configuration config = new Configuration(configFile);
        config.load();
        checkPotion = config.get("general", "checkPotion", checkPotion, "check conflicting of Potion ID").getBoolean();
        maxPotionArray = config.get("general", "maxPotionArray", maxPotionArray, "Not Recommended to set over 127").getInt();
        config.save();
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public static byte[] outputModifiedClassFile(byte[] modified, String className) {
        if (debug) {
            try {
                FileOutputStream fos = new FileOutputStream(className + ".class");
                fos.write(modified);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return modified;
    }

    static {
        debug = false;
    }
}

