/*
 * Decompiled with CFR 0.152.
 */
package io.dogboy.serializationisbad.modlauncher;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import io.dogboy.serializationisbad.core.Patches;
import io.dogboy.serializationisbad.core.config.PatchModule;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class SIBTransformer
implements ITransformer<ClassNode> {
    private final PatchModule patchModule;

    public SIBTransformer(PatchModule patchModule) {
        this.patchModule = patchModule;
    }

    public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
        byte[] classBytes = SIBTransformer.writeClassNode(input);
        byte[] transformedClassBytes = Patches.patchClass(classBytes, input.name.replace('/', '.'), true);
        return SIBTransformer.readClassNode(transformedClassBytes);
    }

    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    public Set<ITransformer.Target> targets() {
        return Stream.concat(this.patchModule.getClassesToPatch().stream(), this.patchModule.getCustomOISClasses().stream()).map(ITransformer.Target::targetClass).collect(Collectors.toSet());
    }

    private static ClassNode readClassNode(byte[] classBytecode) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytecode);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private static byte[] writeClassNode(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

