/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Pos3D;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.client.SparkleAnimation;
import mekanism.client.sound.ISoundSource;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IHasSound;
import mekanism.common.base.SoundWrapper;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.FusionReactor;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.client.audio.ISound;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityReactorController
extends TileEntityReactorBlock
implements IActiveState,
IHasSound,
ISoundSource {
    public static final int MAX_WATER = 100000;
    public static final int MAX_STEAM = 10000000;
    public static final int MAX_FUEL = 1000;
    public FluidTank waterTank = new FluidTank(100000);
    public FluidTank steamTank = new FluidTank(10000000);
    public GasTank deuteriumTank = new GasTank(1000);
    public GasTank tritiumTank = new GasTank(1000);
    public GasTank fuelTank = new GasTank(1000);
    public AxisAlignedBB box;
    public ResourceLocation soundURL = new ResourceLocation("mekanism", "tile.machine.fusionreactor");
    @SideOnly(value=Side.CLIENT)
    public SoundWrapper sound;
    public double clientTemp = 0.0;
    public boolean clientBurning = false;

    public TileEntityReactorController() {
        super("ReactorController", 1.0E9);
        this.inventory = new ItemStack[1];
    }

    public boolean isFrame() {
        return false;
    }

    public void radiateNeutrons(int neutrons) {
    }

    public void formMultiblock(boolean keepBurning) {
        if (this.getReactor() == null) {
            this.setReactor(new FusionReactor(this));
        }
        this.getReactor().formMultiblock(keepBurning);
    }

    public double getPlasmaTemp() {
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return 0.0;
        }
        return this.getReactor().getPlasmaTemp();
    }

    public double getCaseTemp() {
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return 0.0;
        }
        return this.getReactor().getCaseTemp();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
        if (this.isFormed()) {
            this.getReactor().simulate();
            if (!this.field_145850_b.field_72995_K && (this.getReactor().isBurning() != this.clientBurning || Math.abs(this.getReactor().getPlasmaTemp() - this.clientTemp) > 1000000.0)) {
                Mekanism.packetHandler.sendToAllAround((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new ArrayList())), Coord4D.get((TileEntity)this).getTargetPoint(50.0));
                this.clientBurning = this.getReactor().isBurning();
                this.clientTemp = this.getReactor().getPlasmaTemp();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateSound() {
        if (this.shouldPlaySound() && this.getSound().canRestart() && MekanismConfig.client.enableMachineSounds) {
            this.getSound().reset();
            this.getSound().play();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.formMultiblock(true);
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.formMultiblock(false);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("formed", this.isFormed());
        if (this.isFormed()) {
            tag.func_74780_a("plasmaTemp", this.getReactor().getPlasmaTemp());
            tag.func_74780_a("caseTemp", this.getReactor().getCaseTemp());
            tag.func_74768_a("injectionRate", this.getReactor().getInjectionRate());
            tag.func_74757_a("burning", this.getReactor().isBurning());
        } else {
            tag.func_74780_a("plasmaTemp", 0.0);
            tag.func_74780_a("caseTemp", 0.0);
            tag.func_74768_a("injectionRate", 0);
            tag.func_74757_a("burning", false);
        }
        tag.func_74782_a("fuelTank", (NBTBase)this.fuelTank.write(new NBTTagCompound()));
        tag.func_74782_a("deuteriumTank", (NBTBase)this.deuteriumTank.write(new NBTTagCompound()));
        tag.func_74782_a("tritiumTank", (NBTBase)this.tritiumTank.write(new NBTTagCompound()));
        tag.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("steamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        boolean formed = tag.func_74767_n("formed");
        if (formed) {
            this.setReactor(new FusionReactor(this));
            this.getReactor().setPlasmaTemp(tag.func_74769_h("plasmaTemp"));
            this.getReactor().setCaseTemp(tag.func_74769_h("caseTemp"));
            this.getReactor().setInjectionRate(tag.func_74762_e("injectionRate"));
            this.getReactor().setBurning(tag.func_74767_n("burning"));
            this.getReactor().updateTemperatures();
        }
        this.fuelTank.read(tag.func_74775_l("fuelTank"));
        this.deuteriumTank.read(tag.func_74775_l("deuteriumTank"));
        this.tritiumTank.read(tag.func_74775_l("tritiumTank"));
        this.waterTank.readFromNBT(tag.func_74775_l("waterTank"));
        this.steamTank.readFromNBT(tag.func_74775_l("steamTank"));
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.getReactor() != null && this.getReactor().isFormed());
        if (this.getReactor() != null) {
            data.add(this.getReactor().getPlasmaTemp());
            data.add(this.getReactor().getCaseTemp());
            data.add(this.getReactor().getInjectionRate());
            data.add(this.getReactor().isBurning());
            data.add(this.fuelTank.getStored());
            data.add(this.deuteriumTank.getStored());
            data.add(this.tritiumTank.getStored());
            data.add(this.waterTank.getCapacity());
            data.add(this.waterTank.getFluidAmount());
            data.add(this.steamTank.getCapacity());
            data.add(this.steamTank.getFluidAmount());
        }
        return data;
    }

    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int type = dataStream.readInt();
            switch (type) {
                case 0: {
                    if (this.getReactor() == null) break;
                    this.getReactor().setInjectionRate(dataStream.readInt());
                }
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            boolean formed = dataStream.readBoolean();
            if (formed) {
                if (this.getReactor() == null || !((FusionReactor)this.getReactor()).formed) {
                    Mekanism.proxy.doGenericSparkle((TileEntity)this, new SparkleAnimation.INodeChecker(){

                        public boolean isNode(TileEntity tile) {
                            return tile instanceof TileEntityReactorBlock;
                        }
                    });
                }
                if (this.getReactor() == null) {
                    this.setReactor(new FusionReactor(this));
                    MekanismUtils.updateBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
                }
                ((FusionReactor)this.getReactor()).formed = true;
                this.getReactor().setPlasmaTemp(dataStream.readDouble());
                this.getReactor().setCaseTemp(dataStream.readDouble());
                this.getReactor().setInjectionRate(dataStream.readInt());
                this.getReactor().setBurning(dataStream.readBoolean());
                this.fuelTank.setGas(new GasStack(GasRegistry.getGas((String)"fusionFuelDT"), dataStream.readInt()));
                this.deuteriumTank.setGas(new GasStack(GasRegistry.getGas((String)"deuterium"), dataStream.readInt()));
                this.tritiumTank.setGas(new GasStack(GasRegistry.getGas((String)"tritium"), dataStream.readInt()));
                this.waterTank.setCapacity(dataStream.readInt());
                this.waterTank.setFluid(new FluidStack(FluidRegistry.getFluid((String)"water"), dataStream.readInt()));
                this.steamTank.setCapacity(dataStream.readInt());
                this.steamTank.setFluid(new FluidStack(FluidRegistry.getFluid((String)"steam"), dataStream.readInt()));
            } else if (this.getReactor() != null) {
                this.setReactor(null);
                MekanismUtils.updateBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
            }
        }
    }

    public boolean isFormed() {
        return this.getReactor() != null && this.getReactor().isFormed();
    }

    public boolean isBurning() {
        return this.getActive() && this.getReactor().isBurning();
    }

    public boolean getActive() {
        return this.isFormed();
    }

    public void setActive(boolean active) {
        if (active == (this.getReactor() == null)) {
            this.setReactor(active ? new FusionReactor(this) : null);
        }
    }

    public boolean renderUpdate() {
        return true;
    }

    public boolean lightUpdate() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.box == null) {
            this.box = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)this.field_145848_d, (double)(this.field_145849_e + 2));
        }
        return this.box;
    }

    @SideOnly(value=Side.CLIENT)
    public SoundWrapper getSound() {
        return this.sound;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldPlaySound() {
        return this.isBurning() && !this.func_145837_r();
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSoundLocation() {
        return this.soundURL;
    }

    @SideOnly(value=Side.CLIENT)
    public float getVolume() {
        return 2.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPitch() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public Pos3D getSoundPosition() {
        return new Pos3D((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRepeat() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRepeatDelay() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public ISound.AttenuationType getAttenuation() {
        return ISound.AttenuationType.LINEAR;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            this.initSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initSounds() {
        this.sound = new SoundWrapper((IHasSound)this, (ISoundSource)this);
    }
}

