/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.FluidSlot;
import mekanism.common.MekanismItems;
import mekanism.common.base.ISustainedData;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBioGenerator
extends TileEntityGenerator
implements IFluidHandler,
ISustainedData {
    public FluidSlot bioFuelSlot = new FluidSlot(24000, -1);
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getBioFuel", "getBioFuelNeeded"};

    public TileEntityBioGenerator() {
        super("bio", "BioGenerator", 160000.0, MekanismConfig.generators.bioGeneration * 2.0);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.inventory[0] != null) {
            ChargeUtils.charge((int)1, (IStrictEnergyStorage)this);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[0]);
            if (fluid != null && FluidRegistry.isFluidRegistered((String)"bioethanol")) {
                int fluidToAdd;
                if (fluid.getFluid() == FluidRegistry.getFluid((String)"bioethanol") && this.bioFuelSlot.fluidStored + (fluidToAdd = fluid.amount) <= this.bioFuelSlot.MAX_FLUID) {
                    this.bioFuelSlot.setFluid(this.bioFuelSlot.fluidStored + fluidToAdd);
                    if (this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]) != null) {
                        this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                    } else {
                        --this.inventory[0].field_77994_a;
                    }
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                }
            } else {
                int fuelNeeded;
                int fuel = this.getFuel(this.inventory[0]);
                ItemStack prevStack = this.inventory[0].func_77946_l();
                if (fuel > 0 && fuel <= (fuelNeeded = this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored)) {
                    this.bioFuelSlot.fluidStored += fuel;
                    if (this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]) != null) {
                        this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                    } else {
                        --this.inventory[0].field_77994_a;
                    }
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                }
            }
        }
        if (this.canOperate()) {
            if (!this.field_145850_b.field_72995_K) {
                this.setActive(true);
            }
            this.bioFuelSlot.setFluid(this.bioFuelSlot.fluidStored - 1);
            this.setEnergy(this.electricityStored + MekanismConfig.generators.bioGeneration);
        } else if (!this.field_145850_b.field_72995_K) {
            this.setActive(false);
        }
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            if (this.getFuel(itemstack) > 0) {
                return true;
            }
            return FluidRegistry.isFluidRegistered((String)"bioethanol") && FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack) != null && FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack).getFluid() == FluidRegistry.getFluid((String)"bioethanol");
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.BASE_MAX_ENERGY && this.bioFuelSlot.fluidStored > 0 && MekanismUtils.canFunction((TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.bioFuelSlot.fluidStored = nbtTags.func_74762_e("bioFuelStored");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("bioFuelStored", this.bioFuelSlot.fluidStored);
    }

    public int getFuel(ItemStack itemstack) {
        return itemstack.func_77973_b() == MekanismItems.BioFuel ? 200 : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.bioFuelSlot.fluidStored * i / this.bioFuelSlot.MAX_FLUID;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight((int)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.bioFuelSlot.fluidStored = dataStream.readInt();
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.bioFuelSlot.fluidStored);
        return data;
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.BASE_MAX_ENERGY};
            }
            case 3: {
                return new Object[]{this.BASE_MAX_ENERGY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.bioFuelSlot.fluidStored};
            }
            case 5: {
                return new Object[]{this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored};
            }
        }
        throw new NoSuchMethodException();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (FluidRegistry.isFluidRegistered((String)"bioethanol") && from != ForgeDirection.getOrientation((int)this.facing) && resource.getFluid() == FluidRegistry.getFluid((String)"bioethanol")) {
            int fuelTransfer = 0;
            int attemptTransfer = resource.amount;
            int fuelNeeded = this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored;
            fuelTransfer = attemptTransfer <= fuelNeeded ? attemptTransfer : fuelNeeded;
            if (doFill) {
                this.bioFuelSlot.setFluid(this.bioFuelSlot.fluidStored + fuelTransfer);
            }
            return fuelTransfer;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return FluidRegistry.isFluidRegistered((String)"bioethanol") && fluid == FluidRegistry.getFluid((String)"bioethanol");
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    public void writeSustainedData(ItemStack itemStack) {
        itemStack.field_77990_d.func_74768_a("fluidStored", this.bioFuelSlot.fluidStored);
    }

    public void readSustainedData(ItemStack itemStack) {
        this.bioFuelSlot.setFluid(itemStack.field_77990_d.func_74762_e("fluidStored"));
    }
}

