/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.utils;

import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Version
implements Comparable<Version> {
    private int major = 0;
    private int minor = 0;
    private int patch = 0;
    private String preRelease = "";
    private final boolean success;
    private static final String PRE_RELEASE_PREFIX = "-";

    public Version(int major, int minor, int patch, String preRelease) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.success = true;
    }

    public Version(String version) {
        boolean success1;
        String[] split = version.split(PRE_RELEASE_PREFIX);
        if (split.length == 0) {
            success1 = false;
        } else {
            String[] versions = split[0].split("\\.");
            if (versions.length != 3) {
                success1 = false;
            } else {
                try {
                    this.major = Integer.parseInt(versions[0]);
                    this.minor = Integer.parseInt(versions[1]);
                    this.patch = Integer.parseInt(versions[2]);
                    success1 = true;
                }
                catch (NumberFormatException e) {
                    success1 = false;
                }
            }
        }
        this.success = success1;
        if (split.length > 1) {
            this.preRelease = split[1];
        }
    }

    @Override
    public int compareTo(Version o) {
        assert (this.isSuccess());
        assert (o.isSuccess());
        if (this.getMajor() != o.getMajor()) {
            return this.getMajor() < o.getMajor() ? -1 : 1;
        }
        if (this.getMinor() != o.getMinor()) {
            return this.getMinor() < o.getMinor() ? -1 : 1;
        }
        if (this.getPatch() != o.getPatch()) {
            return this.getPatch() < o.getPatch() ? -1 : 1;
        }
        return 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getPreRelease() {
        return this.preRelease;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

