/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.BreakIterator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.JustEnoughCalculation;
import me.towdium.jecalculation.polyfill.NBTHelper;
import me.towdium.jecalculation.utils.ClientUtils;
import me.towdium.jecalculation.utils.NBTJson;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.WordUtils;

@ParametersAreNonnullByDefault
public class Utilities {
    public static char[] suffix = new char[]{'K', 'M', 'B', 'G', 'T', 'P'};
    public static DecimalFormat[] format = new DecimalFormat[]{new DecimalFormat("#."), new DecimalFormat("#.#"), new DecimalFormat("#.##"), new DecimalFormat("#.###"), new DecimalFormat("#.####")};

    public static String cutNumber(float f, int size) {
        BiFunction<Float, Integer, String> form = (fl, len) -> format[len - 1 - (int)Math.log10(fl.floatValue())].format(fl);
        int scale = (int)Math.log10(f) / 3;
        if (scale == 0) {
            return form.apply(Float.valueOf(f), size);
        }
        return form.apply(Float.valueOf(f / (float)Math.pow(1000.0, scale)), size - 1) + suffix[scale - 1];
    }

    public static <T> Stream<T> stream(Optional<T> o) {
        return o.map(Stream::of).orElse(Stream.empty());
    }

    public static <T> Supplier<T> fake(Runnable r) {
        return () -> {
            r.run();
            return null;
        };
    }

    public static String repeat(String s, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Nullable
    public static String getModName(Item item) {
        String name = Utilities.getName(item);
        String id = name.substring(0, name.indexOf(":"));
        return id.equals("minecraft") ? "Minecraft" : ((ModContainer)Loader.instance().getIndexedModList().get(id)).getName();
    }

    public static String getName(Item item) {
        return GameData.getItemRegistry().func_148750_c((Object)item);
    }

    public static String getName(ItemStack itemStack) {
        return Utilities.getName(itemStack.func_77973_b());
    }

    public static String getModName(Fluid fluid) {
        String capitalizedModId;
        String name = fluid.getName();
        if (name.equals("lava") || name.equals("water")) {
            return "Minecraft";
        }
        IIcon icon = Utilities.getFluidIcon(fluid);
        if (icon == null) {
            return "Unknown";
        }
        String iconName = icon.func_94215_i();
        String modId = iconName.split(":")[0];
        Map indexedModList = Loader.instance().getIndexedModList();
        ModContainer modContainer = (ModContainer)indexedModList.get(modId);
        if (modContainer == null && (modContainer = (ModContainer)indexedModList.get(capitalizedModId = WordUtils.capitalize((String)modId))) == null) {
            return capitalizedModId;
        }
        return modContainer.getName();
    }

    private static IIcon getFluidIcon(Fluid fluid) {
        IIcon icon = fluid.getFlowingIcon();
        if (icon == null) {
            icon = fluid.getStillIcon();
        }
        return icon;
    }

    public static NBTTagCompound getTag(ItemStack is) {
        return NBTHelper.getOrCreateSubCompound(is, "jecalculation");
    }

    public static EntityClientPlayerMP getPlayer() {
        return Objects.requireNonNull(ClientUtils.mc().field_71439_g);
    }

    public static void addChatMessage(ChatMessage cm) {
        EntityClientPlayerMP player = Utilities.getPlayer();
        if (player != null) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(cm.get(), new Object[0]));
        }
    }

    public static Locale getLocaleFromString(String languageCode) {
        String[] parts = languageCode.split("_", -1);
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2 || parts.length == 3 && parts[2].startsWith("#")) {
            return new Locale(parts[0], parts[1]);
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }

    public static String[] mergeStringArrays(String[] ... arrays) {
        return (String[])Stream.of(arrays).flatMap(Stream::of).toArray(String[]::new);
    }

    public static class Json {
        @Nullable
        public static NBTTagCompound read(File f) {
            try {
                String s = FileUtils.readFileToString((File)f, (String)"UTF-8");
                return Json.read(s);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Nullable
        public static NBTTagCompound read(String s) {
            JsonParser parser = new JsonParser();
            try {
                JsonElement element = parser.parse(s);
                return (NBTTagCompound)NBTJson.toNbt(element);
            }
            catch (JsonSyntaxException | IllegalArgumentException e) {
                e.printStackTrace();
                JustEnoughCalculation.logger.error("Failed to load json to nbt");
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void write(NBTTagCompound nbt, File f) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.write(Json.write(nbt).getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public static String write(NBTTagCompound nbt) {
            return NBTJson.toJson(nbt);
        }
    }

    public static class Recent<T> {
        LinkedList<T> data = new LinkedList();
        BiPredicate<T, T> tester;
        int limit;

        public Recent(BiPredicate<T, T> tester, int limit) {
            this.tester = tester;
            this.limit = limit;
        }

        public Recent(int limit) {
            this.limit = limit;
        }

        public boolean push(T obj, boolean replace) {
            if (replace) {
                this.data.pop();
            }
            boolean ret = this.data.removeIf(t -> this.tester != null ? this.tester.test(t, obj) : t.equals(obj));
            this.data.addFirst(obj);
            if (this.data.size() > this.limit) {
                this.data.removeLast();
            }
            return ret;
        }

        public List<T> toList() {
            return new ArrayList<T>(this.data);
        }

        public void clear() {
            this.data.clear();
        }

        public int size() {
            return this.data.size();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class I18n {
        public static boolean contains(String s1, String s2) {
            return s1.contains(s2);
        }

        public static Pair<String, Boolean> search(String translateKey, Object ... parameters) {
            Pair<Object, Object> ret = new Pair<Object, Object>(null, null);
            translateKey = "jecalculation." + translateKey;
            String buffer = net.minecraft.client.resources.I18n.func_135052_a((String)translateKey, (Object[])parameters);
            ret.two = !buffer.equals(translateKey);
            buffer = StringEscapeUtils.unescapeJava((String)buffer);
            ret.one = buffer.replace("\t", "    ");
            return ret;
        }

        public static String get(String translateKey, Object ... parameters) {
            return (String)I18n.search((String)translateKey, (Object[])parameters).one;
        }

        public static List<String> wrap(String s, int width) {
            return new TextWrapper().wrap(s, ClientUtils.mc().func_135016_M().func_135041_c().func_135034_a(), i -> TextWrapper.renderer.func_78263_a(i.charValue()), width);
        }

        static class TextWrapper {
            static FontRenderer renderer = ClientUtils.mc().field_71466_p;
            String str;
            BreakIterator it;
            List<String> temp = new ArrayList<String>();
            Function<Character, Integer> func;
            int start;
            int end;
            int section;
            int space;
            int cursor;
            int width;

            TextWrapper() {
            }

            private void cut() {
                char c = this.str.charAt(this.cursor);
                if (c == '\f') {
                    ++this.cursor;
                }
                this.temp.add(this.str.substring(this.start, this.cursor));
                if (c == ' ' || c == '\u3000' || c == '\n') {
                    ++this.cursor;
                }
                this.start = this.cursor;
                this.end = this.cursor;
                this.space = this.width;
                this.section = this.func.apply(Character.valueOf(this.str.charAt(this.cursor)));
            }

            private void move() {
                this.temp.add(this.str.substring(this.start, this.end));
                this.start = this.end;
                this.space = this.width;
            }

            private List<String> wrap(String s, String languageCode, Function<Character, Integer> func, int width) {
                Locale l = Utilities.getLocaleFromString(languageCode);
                this.temp.clear();
                this.start = 0;
                this.end = 0;
                this.cursor = 0;
                this.space = width;
                this.str = s;
                this.it = BreakIterator.getLineInstance(l);
                this.it.setText(s);
                this.width = width;
                this.func = func;
                int i = this.it.next();
                while (i != -1) {
                    this.cursor = this.end;
                    while (this.cursor < i) {
                        char ch = this.str.charAt(this.cursor);
                        this.section += func.apply(Character.valueOf(this.str.charAt(this.cursor))).intValue();
                        if (ch == '\n' || ch == '\f') {
                            this.cut();
                        } else if (this.section > this.space) {
                            if (this.start == this.end) {
                                this.cut();
                            } else {
                                this.move();
                            }
                        }
                        ++this.cursor;
                    }
                    this.space -= this.section;
                    this.section = 0;
                    this.end = this.cursor;
                    i = this.it.next();
                }
                this.move();
                return this.temp;
            }
        }
    }

    public static class ReversedIterator<T>
    implements Iterator<T> {
        ListIterator<T> i;

        public ReversedIterator(List<T> l) {
            this.i = l.listIterator(l.size());
        }

        public ReversedIterator(ListIterator<T> i) {
            while (i.hasNext()) {
                i.next();
            }
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasPrevious();
        }

        @Override
        public T next() {
            return this.i.previous();
        }

        public Stream<T> stream() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
        }
    }

    public static class Circulator {
        int total;
        int current;

        public Circulator(int total) {
            this(total, 0);
        }

        public Circulator(int total, int current) {
            this.total = total;
            this.current = current;
        }

        public int next() {
            return this.current + 1 == this.total ? 0 : this.current + 1;
        }

        public int prev() {
            return this.current == 0 ? this.total - 1 : this.current - 1;
        }

        public Circulator move(int steps) {
            this.current += steps;
            this.current = this.current < 0 ? (this.current += (this.total - this.current - 1) / this.total * this.total) : (this.current %= this.total);
            return this;
        }

        public int current() {
            return this.current;
        }

        public Circulator set(int index) {
            if (index < 0 || index >= this.total) {
                throw new RuntimeException(String.format("Expected: [0, %d), given: %d.", this.total, index));
            }
            this.current = index;
            return this;
        }

        public Circulator copy() {
            return new Circulator(this.total).set(this.current);
        }
    }

    public static class Timer {
        long time = System.currentTimeMillis();
        boolean running = false;

        public void setState(boolean b) {
            if (!b && this.running) {
                this.running = false;
            }
            if (b && !this.running) {
                this.running = true;
                this.time = System.currentTimeMillis();
            }
        }

        public long getTime() {
            return this.running ? System.currentTimeMillis() - this.time : 0L;
        }
    }

    public static class Relation<K, V> {
        public HashMap<Pair<K, K>, V> data = new HashMap();

        public void put(K a, K b, V v) {
            Pair<K, K> pair = new Pair<K, K>(a, b);
            V tmp = this.data.get(pair);
            this.data.put(tmp == null ? new Pair<K, K>(b, a) : pair, v);
        }

        @Nullable
        public V get(K a, K b) {
            V ret = this.data.get(new Pair<K, K>(a, b));
            if (ret == null) {
                ret = this.data.get(new Pair<K, K>(b, a));
            }
            return ret;
        }
    }

    public static enum ChatMessage {
        MAX_LOOP,
        RECIPE_TRANSFER_ERROR;


        private String get() {
            switch (this) {
                case MAX_LOOP: {
                    return "jecalculation.chat.max_loop";
                }
                case RECIPE_TRANSFER_ERROR: {
                    return "jecalculation.chat.recipe_transfer_error";
                }
            }
            return "";
        }
    }
}

