/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTJson {
    private static final Pattern numberPattern = Pattern.compile("^([-+]?[\\d]+\\.?[0-9]*)([bBsSlLfFdD]?)$");
    private static final JsonParser parser = new JsonParser();
    private static final Gson gson = new GsonBuilder().create();

    public static String toJson(NBTTagCompound tag) {
        String jsonString = NBTJson.toJsonObject((NBTBase)tag).toString();
        return gson.toJson(parser.parse(jsonString));
    }

    public static JsonElement toJsonObject(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound nbtTagCompound = (NBTTagCompound)nbt;
            Map tagMap = nbtTagCompound.field_74784_a;
            JsonObject root = new JsonObject();
            for (Map.Entry nbtEntry : tagMap.entrySet()) {
                root.add((String)nbtEntry.getKey(), NBTJson.toJsonObject((NBTBase)nbtEntry.getValue()));
            }
            return root;
        }
        if (nbt instanceof NBTBase.NBTPrimitive) {
            return new JsonPrimitive((Number)((NBTBase.NBTPrimitive)nbt).func_150286_g());
        }
        if (nbt instanceof NBTTagString) {
            return new JsonPrimitive(((NBTTagString)nbt).func_150285_a_());
        }
        if (nbt instanceof NBTTagList) {
            JsonArray arr = new JsonArray();
            ((NBTTagList)nbt).field_74747_a.forEach(c -> arr.add(NBTJson.toJsonObject((NBTBase)c)));
            return arr;
        }
        if (nbt instanceof NBTTagIntArray) {
            JsonArray arr = new JsonArray();
            for (int i : ((NBTTagIntArray)nbt).func_150302_c()) {
                arr.add((JsonElement)new JsonPrimitive((Number)i));
            }
            return arr;
        }
        if (nbt instanceof NBTTagByteArray) {
            JsonArray arr = new JsonArray();
            for (byte i : ((NBTTagByteArray)nbt).func_150292_c()) {
                arr.add((JsonElement)new JsonPrimitive((Number)i));
            }
            return arr;
        }
        throw new IllegalArgumentException("Unsupported NBT Tag: " + NBTBase.field_82578_b[nbt.func_74732_a()] + " - " + nbt);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static NBTBase toNbt(JsonElement jsonElement) {
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            String jsonString = jsonPrimitive.getAsString();
            Matcher m = numberPattern.matcher(jsonString);
            if (!m.find()) return new NBTTagString(jsonString);
            String numberString = m.group(1);
            if (m.groupCount() == 2 && m.group(2).length() > 0) {
                char numberType = m.group(2).charAt(0);
                switch (numberType) {
                    case 'B': 
                    case 'b': {
                        return new NBTTagByte(Byte.parseByte(numberString));
                    }
                    case 'S': 
                    case 's': {
                        return new NBTTagShort(Short.parseShort(numberString));
                    }
                    case 'L': 
                    case 'l': {
                        return new NBTTagLong(Long.parseLong(numberString));
                    }
                    case 'F': 
                    case 'f': {
                        return new NBTTagFloat(Float.parseFloat(numberString));
                    }
                    case 'D': 
                    case 'd': {
                        return new NBTTagDouble(Double.parseDouble(numberString));
                    }
                }
                throw new IllegalArgumentException("Unhandled element " + jsonElement);
            }
            if (!numberString.contains(".")) return new NBTTagInt(Integer.parseInt(numberString));
            return new NBTTagDouble(Double.parseDouble(numberString));
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            ArrayList<NBTBase> nbtList = new ArrayList<NBTBase>();
            for (JsonElement element : jsonArray) {
                nbtList.add(NBTJson.toNbt(element));
            }
            if (nbtList.stream().allMatch(n -> n instanceof NBTTagInt)) {
                return new NBTTagIntArray(nbtList.stream().mapToInt(i -> ((NBTTagInt)i).func_150287_d()).toArray());
            }
            if (nbtList.stream().allMatch(n -> n instanceof NBTTagByte)) {
                return new NBTTagByteArray(NBTJson.toByteArray(nbtList.stream().mapToInt(i -> ((NBTTagInt)i).func_150287_d())));
            }
            NBTTagList nbtTagList = new NBTTagList();
            nbtList.forEach(arg_0 -> ((NBTTagList)nbtTagList).func_74742_a(arg_0));
            return nbtTagList;
        }
        if (!(jsonElement instanceof JsonObject)) throw new IllegalArgumentException("Unhandled element " + jsonElement);
        JsonObject jsonObject = (JsonObject)jsonElement;
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        Iterator iterator = jsonObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry jsonEntry = (Map.Entry)iterator.next();
            nbtTagCompound.func_74782_a((String)jsonEntry.getKey(), NBTJson.toNbt((JsonElement)jsonEntry.getValue()));
        }
        return nbtTagCompound;
    }

    public static byte[] toByteArray(IntStream stream) {
        return stream.collect(ByteArrayOutputStream::new, (baos, i) -> baos.write((byte)i), (baos1, baos2) -> baos1.write(baos2.toByteArray(), 0, baos2.size())).toByteArray();
    }
}

