/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.nei.adapter;

import codechicken.nei.recipe.IRecipeHandler;
import gregtech.api.recipe.RecipeCategory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.nei.adapter.IAdapter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class GregTech
implements IAdapter {
    private static final Class<?> gtDefault;
    private static final Class<?> gtAssLine;
    private final boolean isNH;

    public GregTech(boolean isNH) {
        this.isNH = isNH;
    }

    @Override
    public Set<String> getAllOverlayIdentifier() {
        if (this.isNH) {
            return RecipeCategory.ALL_RECIPE_CATEGORIES.values().stream().filter(category -> category.recipeMap.getFrontend().getNEIProperties().registerNEI).map(category -> category.unlocalizedName).collect(Collectors.toSet());
        }
        return this.reflectGetRecipeMapNEIName("gregtech.api.util.GT_Recipe$GT_Recipe_Map", "sMappings");
    }

    protected Set<String> reflectGetRecipeMapNEIName(String clz, String staticField) {
        try {
            Class<?> gtRecipeMapClz = Class.forName(clz);
            Field sMappingsField = gtRecipeMapClz.getDeclaredField(staticField);
            Field mNEINameField = gtRecipeMapClz.getField("mNEIName");
            Collection sMappings = (Collection)sMappingsField.get(null);
            return sMappings.stream().map(sMapping -> {
                try {
                    return mNEINameField.get(sMapping);
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return new HashSet<String>();
        }
    }

    @Override
    public void handleRecipe(IRecipeHandler recipe, int index, List<Object[]> inputs, List<Object[]> outputs) {
        if (gtDefault.isInstance(recipe) || gtAssLine != null && gtAssLine.isInstance(recipe)) {
            this.handleDefault(recipe, index, inputs, outputs);
        }
    }

    protected void handleDefault(IRecipeHandler recipe, int index, List<Object[]> inputs, List<Object[]> outputs) {
        this.handleDefault(recipe, index, inputs, outputs, false);
    }

    protected void handleDefault(IRecipeHandler recipe, int index, List<Object[]> inputs, List<Object[]> outputs, boolean clearOutput) {
        inputs.replaceAll(ts -> Arrays.stream(ts).map(o -> {
            if (o instanceof ItemStack) {
                return GregTech.convertFluid((ItemStack)o);
            }
            if (o instanceof FluidStack) {
                return o;
            }
            throw new IllegalArgumentException("Shall get ItemStack or FluidStack, but get: " + o.getClass());
        }).toArray());
        if (clearOutput) {
            outputs.clear();
        }
        List otherStacks = recipe.getOtherStacks(index);
        outputs.addAll(otherStacks.stream().map(positionedStack -> positionedStack.items).map(itemStacks -> Arrays.stream(itemStacks).map(GregTech::convertFluid).toArray()).collect(Collectors.toList()));
    }

    public static Object convertFluid(ItemStack itemStack) {
        FluidStack fluidStack = GregTech.getFluidFromDisplayStack(itemStack);
        return fluidStack == null ? itemStack : fluidStack;
    }

    private static FluidStack getFluidFromDisplayStack(ItemStack aDisplayStack) {
        try {
            Class<?> itemListClz = Class.forName("gregtech.api.enums.ItemList");
            Object display_fluid = Enum.valueOf(itemListClz, "Display_Fluid");
            Method getItem = itemListClz.getMethod("getItem", new Class[0]);
            Item displayFluidItem = (Item)getItem.invoke(display_fluid, new Object[0]);
            if (!GregTech.isStackValid(aDisplayStack) || aDisplayStack.func_77973_b() != displayFluidItem || !aDisplayStack.func_77942_o()) {
                return null;
            }
            Fluid tFluid = FluidRegistry.getFluid((int)displayFluidItem.getDamage(aDisplayStack));
            return new FluidStack(tFluid, (int)aDisplayStack.func_77978_p().func_74763_f("mFluidDisplayAmount"));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isStackValid(Object aStack) {
        return aStack instanceof ItemStack && ((ItemStack)aStack).func_77973_b() != null && ((ItemStack)aStack).field_77994_a >= 0;
    }

    static {
        Class<?> gtDf = null;
        Class<?> gtAL = null;
        try {
            gtDf = Class.forName("gregtech.nei.GT_NEI_DefaultHandler");
            gtAL = Class.forName("gregtech.nei.GT_NEI_AssLineHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        gtDefault = gtDf;
        gtAssLine = gtAL;
    }
}

