/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WRectangle;
import me.towdium.jecalculation.gui.widgets.WText;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.utils.Utilities;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class WSwitcher
extends WContainer {
    public static final int SIZE = 13;
    public IWidget.ListenerAction<? super WSwitcher> listener;
    protected int xPos;
    protected int xSize;
    protected int yPos;
    protected WButton left;
    protected WButton right;
    protected WRectangle wRect;
    protected WText wText;
    protected List<String> keys;
    protected Utilities.Circulator index;
    protected String temp;

    public WSwitcher(int xPos, int yPos, int xSize, int total) {
        this(xPos, yPos, xSize, IntStream.rangeClosed(1, total).mapToObj(i -> i + "/" + total).collect(Collectors.toList()));
    }

    public WSwitcher(int xPos, int yPos, int xSize, List<String> keys) {
        this.xPos = xPos;
        this.xSize = xSize;
        this.yPos = yPos;
        this.keys = keys;
        this.left = new WButtonIcon(xPos, yPos, 13, 13, Resource.WGT_ARR_L).setListener((? super WButton i) -> {
            if (this.temp == null) {
                this.move(-1);
            } else {
                this.setText(null);
            }
        });
        this.right = new WButtonIcon(xPos + xSize - 13, yPos, 13, 13, Resource.WGT_ARR_R).setListener((? super WButton i) -> {
            if (this.temp == null) {
                this.move(1);
            } else {
                this.setText(null);
            }
        });
        this.wRect = new WRectangle(xPos + 13, yPos, xSize - 26, 13, -6184543);
        this.wText = new WText(xPos + 13, yPos + 2, xSize - 26, JecaGui.Font.SHADOW, "", true);
        this.index = new Utilities.Circulator(keys.size());
        this.refresh();
        this.add(this.left, this.right, this.wRect, this.wText);
    }

    public WSwitcher setDisabled(boolean b) {
        this.left.setDisabled(b);
        this.right.setDisabled(b);
        return this;
    }

    public void move(int diff) {
        if (diff == 0) {
            return;
        }
        if (this.temp != null) {
            this.temp = null;
            diff = diff > 0 ? --diff : ++diff;
        }
        this.index.move(diff);
        this.notifyLsnr();
        this.refresh();
    }

    public WSwitcher setListener(IWidget.ListenerAction<? super WSwitcher> listener) {
        this.listener = listener;
        return this;
    }

    public int getIndex() {
        return this.temp == null ? this.index.current() : -1;
    }

    public void setIndex(int i) {
        if (this.temp != null) {
            this.temp = null;
        }
        this.index.set(i);
        this.refresh();
    }

    public List<String> getTexts() {
        return this.keys;
    }

    public String getText() {
        return this.temp == null ? this.keys.get(this.index.current()) : this.temp;
    }

    public void refresh() {
        boolean b = this.keys.size() < (this.temp == null ? 2 : 1);
        this.left.setDisabled(b);
        this.right.setDisabled(b);
        this.wText.key = this.temp == null ? (this.keys.isEmpty() ? "" : this.keys.get(this.index.current())) : this.temp;
    }

    public WSwitcher setText(@Nullable String s) {
        int i = this.keys.indexOf(s);
        if (i != -1) {
            this.setIndex(i);
        } else {
            this.temp = s;
        }
        this.notifyLsnr();
        this.refresh();
        return this;
    }

    public void notifyLsnr() {
        if (this.listener != null) {
            this.listener.invoke(this);
        }
    }
}

