/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import codechicken.lib.gui.GuiDraw;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Wrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class WLabel
implements IWidget {
    public int xPos;
    public int yPos;
    public int xSize;
    public int ySize;
    ILabel label = ILabel.EMPTY;
    public boolean accept;
    public IWidget.ListenerValue<? super WLabel, ILabel> update;
    public IWidget.ListenerAction<? super WLabel> leftClick;
    public IWidget.ListenerAction<? super WLabel> rightClick;
    public IWidget.ListenerValue<? super WLabel, Integer> scroll;
    Function<ILabel, String> fmtAmount = i -> "";
    BiConsumer<ILabel, List<String>> fmtTooltip = (i, j) -> i.getToolTip((List<String>)j, false);
    protected Utilities.Timer timer = new Utilities.Timer();

    public WLabel(int xPos, int yPos, int xSize, int ySize, boolean accept) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.xSize = xSize;
        this.ySize = ySize;
        this.accept = accept;
    }

    public ILabel getLabel() {
        return this.label;
    }

    public WLabel setLabel(ILabel label) {
        return this.setLabel(label, false);
    }

    public WLabel setLabel(ILabel label, boolean notify) {
        this.label = label;
        if (notify) {
            this.notifyUpdate();
        }
        return this;
    }

    @Override
    public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
        gui.drawResourceContinuous(Resource.WGT_SLOT, this.xPos, this.yPos, this.xSize, this.ySize, 3, 3, 3, 3);
        this.label.drawLabel(gui, this.xPos + this.xSize / 2, this.yPos + this.ySize / 2, true);
        String s = this.fmtAmount.apply(this.label);
        gui.drawText((float)this.xPos + (float)this.xSize / 2.0f + 8.0f - (float)JecaGui.Font.HALF.getTextWidth(s), (float)this.yPos + (float)this.ySize / 2.0f + 8.5f - (float)JecaGui.Font.HALF.getTextHeight(), JecaGui.Font.HALF, s);
        if (this.accept) {
            this.timer.setState(gui.hand != ILabel.EMPTY);
            int color = 0xFFFFFF + (int)((-Math.cos((double)this.timer.getTime() * Math.PI / 1500.0) + 1.0) * 64.0) * 0x1000000;
            GuiDraw.drawRect((int)(this.xPos + 1), (int)(this.yPos + 1), (int)(this.xSize - 2), (int)(this.ySize - 2), (int)color);
        }
        if (this.mouseIn(xMouse, yMouse)) {
            GuiDraw.drawRect((int)(this.xPos + 1), (int)(this.yPos + 1), (int)(this.xSize - 2), (int)(this.ySize - 2), (int)-2130706433);
        }
        return false;
    }

    @Override
    public boolean onTooltip(JecaGui gui, int xMouse, int yMouse, List<String> tooltip) {
        if (!this.mouseIn(xMouse, yMouse)) {
            return false;
        }
        if (this.label != ILabel.EMPTY) {
            tooltip.add(this.label.getDisplayName());
            tooltip.add(JecaGui.SEPARATOR);
            this.fmtTooltip.accept(this.label, tooltip);
        }
        return false;
    }

    @Override
    public boolean getLabelUnderMouse(int xMouse, int yMouse, Wrapper<ILabel> label) {
        if (this.mouseIn(xMouse, yMouse) && this.label != ILabel.EMPTY) {
            label.value = this.label;
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseClicked(JecaGui gui, int xMouse, int yMouse, int button) {
        if (!this.mouseIn(xMouse, yMouse)) {
            return false;
        }
        if (button == 1) {
            this.notifyRightClick();
            return true;
        }
        if (this.accept && gui.hand != ILabel.EMPTY) {
            this.label = gui.hand;
            gui.hand = ILabel.EMPTY;
            this.notifyUpdate();
        } else {
            this.notifyLeftClick();
        }
        return true;
    }

    @Override
    public boolean onMouseScroll(JecaGui gui, int xMouse, int yMouse, int diff) {
        if (this.scroll == null) {
            return false;
        }
        if (this.mouseIn(xMouse, yMouse)) {
            this.scroll.invoke(this, diff);
            return true;
        }
        return false;
    }

    public WLabel setLsnrUpdate(IWidget.ListenerValue<? super WLabel, ILabel> listener) {
        this.update = listener;
        return this;
    }

    public WLabel setLsnrLeftClick(IWidget.ListenerAction<? super WLabel> listener) {
        this.leftClick = listener;
        return this;
    }

    public WLabel setLsnrRightClick(IWidget.ListenerAction<? super WLabel> listener) {
        this.rightClick = listener;
        return this;
    }

    public WLabel setLsnrScroll(IWidget.ListenerValue<? super WLabel, Integer> listener) {
        this.scroll = listener;
        return this;
    }

    public WLabel setFmtAmount(Function<ILabel, String> f) {
        this.fmtAmount = f;
        return this;
    }

    public WLabel setFmtTooltip(BiConsumer<ILabel, List<String>> f) {
        this.fmtTooltip = f;
        return this;
    }

    public boolean mouseIn(int x, int y) {
        int xx = x - this.xPos;
        int yy = y - this.yPos;
        return xx >= 0 && xx < this.xSize && yy >= 0 && yy < this.ySize;
    }

    private void notifyLeftClick() {
        if (this.leftClick != null) {
            this.leftClick.invoke(this);
        }
    }

    private void notifyRightClick() {
        if (this.rightClick != null) {
            this.rightClick.invoke(this);
        }
    }

    private void notifyUpdate() {
        if (this.update != null) {
            this.update.invoke(this, this.label);
        }
    }
}

