/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.CostList;
import me.towdium.jecalculation.data.structure.RecordCraft;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.Gui;
import me.towdium.jecalculation.gui.guis.GuiLabel;
import me.towdium.jecalculation.gui.guis.GuiRecipe;
import me.towdium.jecalculation.gui.guis.GuiSearch;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WHelp;
import me.towdium.jecalculation.gui.widgets.WIcon;
import me.towdium.jecalculation.gui.widgets.WLabel;
import me.towdium.jecalculation.gui.widgets.WLabelGroup;
import me.towdium.jecalculation.gui.widgets.WLabelScroll;
import me.towdium.jecalculation.gui.widgets.WLine;
import me.towdium.jecalculation.gui.widgets.WOverlay;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.gui.widgets.WText;
import me.towdium.jecalculation.gui.widgets.WTextField;
import me.towdium.jecalculation.nei.NEIPlugin;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.utils.ItemStackHelper;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class GuiCraft
extends Gui {
    CostList.Calculator calculator = null;
    RecordCraft record;
    WLabel label = new WLabel(31, 7, 20, 20, true).setLsnrUpdate((i, v) -> this.refreshLabel((ILabel)v, false, true));
    WLabelGroup recent = new WLabelGroup(7, 31, 8, 1, false).setLsnrLeftClick((i, v) -> {
        ILabel l = i.get((int)v).getLabel();
        if (l != ILabel.EMPTY) {
            this.label.setLabel(i.get((int)v).getLabel().copy(), true);
        }
    });
    WLabelScroll result = new WLabelScroll(7, 87, 8, 4, false).setLsnrLeftClick((i, v) -> {
        Object rep = i.get((int)v).getLabel().getRepresentation();
        NEIPlugin.openRecipeGui(rep, false);
    }).setLsnrRightClick((widget, value) -> {
        Object rep = widget.get((int)value).getLabel().getRepresentation();
        NEIPlugin.openRecipeGui(rep, true);
    }).setFmtAmount(i -> i.getAmountString(true)).setFmtTooltip((i, j) -> i.getToolTip((List<String>)j, true));
    WButton steps = new WButtonIcon(64, 62, 20, 20, Resource.BTN_LIST, "craft.step").setListener(i -> this.setMode(RecordCraft.Mode.STEPS));
    WButton catalyst = new WButtonIcon(45, 62, 20, 20, Resource.BTN_CAT, "common.catalyst").setListener(i -> this.setMode(RecordCraft.Mode.CATALYST));
    WButton output = new WButtonIcon(26, 62, 20, 20, Resource.BTN_OUT, "craft.output").setListener(i -> this.setMode(RecordCraft.Mode.OUTPUT));
    WButton input = new WButtonIcon(7, 62, 20, 20, Resource.BTN_IN, "common.input").setListener(i -> this.setMode(RecordCraft.Mode.INPUT));
    WButton invE = new WButtonIcon(149, 62, 20, 20, Resource.BTN_INV_E, "craft.inventory_enabled");
    WButton invD = new WButtonIcon(149, 62, 20, 20, Resource.BTN_INV_D, "craft.inventory_disabled");
    WTextField amount = new WTextField(60, 7, 65).setListener(i -> {
        this.record.amount = i.getText();
        Controller.setRCraft(this.record);
        this.refreshCalculator();
    });

    public GuiCraft() {
        this.record = Controller.getRCraft();
        this.amount.setText(this.record.amount);
        this.add(new WHelp("craft"));
        this.add(new WPanel());
        this.add(new WButtonIcon(7, 7, 20, 20, Resource.BTN_LABEL, "craft.label").setListener(i -> JecaGui.displayGui(new GuiLabel(l -> {
            JecaGui.displayParent();
            JecaGui.getCurrent().hand = l;
        }))));
        this.add(new WButtonIcon(130, 7, 20, 20, Resource.BTN_NEW, "craft.recipe").setListener(i -> JecaGui.displayGui(true, true, new GuiRecipe())));
        this.add(new WButtonIcon(149, 7, 20, 20, Resource.BTN_SEARCH, "craft.search").setListener(i -> JecaGui.displayGui(new GuiSearch())));
        this.add(new WText(53, 13, JecaGui.Font.RAW, "x"));
        this.add(new WLine(55));
        this.add(new WIcon(151, 31, 18, 18, Resource.ICN_RECENT, "craft.history"));
        this.add(this.recent, this.label, this.input, this.output, this.catalyst, this.steps, this.result, this.amount, this.record.inventory ? this.invE : this.invD);
        this.invE.setListener(i -> {
            this.record.inventory = false;
            Controller.setRCraft(this.record);
            this.remove(this.invE);
            this.add(this.invD);
            this.refreshCalculator();
        });
        this.invD.setListener(i -> {
            this.record.inventory = true;
            Controller.setRCraft(this.record);
            this.remove(this.invD);
            this.add(this.invE);
            this.refreshCalculator();
        });
        this.refreshRecent();
        this.setMode(this.record.mode);
    }

    @Override
    public void onVisible(JecaGui gui) {
        this.refreshCalculator();
    }

    @Override
    public boolean acceptsTransfer() {
        return true;
    }

    @Override
    public boolean acceptsLabel() {
        return true;
    }

    void setMode(RecordCraft.Mode mode) {
        this.record.mode = mode;
        Controller.setRCraft(this.record);
        this.input.setDisabled(mode == RecordCraft.Mode.INPUT);
        this.output.setDisabled(mode == RecordCraft.Mode.OUTPUT);
        this.catalyst.setDisabled(mode == RecordCraft.Mode.CATALYST);
        this.steps.setDisabled(mode == RecordCraft.Mode.STEPS);
        this.refreshResult();
    }

    void refreshRecent() {
        this.label.setLabel(this.record.getLatest());
        this.recent.setLabel(this.record.getHistory(), 0);
    }

    void refreshCalculator() {
        try {
            String s = this.amount.getText();
            long i = s.isEmpty() ? 1L : Long.parseLong(this.amount.getText());
            this.amount.setColor(0xFFFFFF);
            List<ILabel> dest = Collections.singletonList(this.label.getLabel().copy().setAmount(i));
            CostList list = this.record.inventory ? new CostList(this.getInventory(), dest) : new CostList(dest);
            this.calculator = list.calculate();
        }
        catch (ArithmeticException | NumberFormatException e) {
            this.amount.setColor(0xFF0000);
            this.calculator = null;
        }
        this.refreshResult();
    }

    List<ILabel> getInventory() {
        InventoryPlayer inv = Utilities.getPlayer().field_71071_by;
        ArrayList<ILabel> labels = new ArrayList<ILabel>();
        Consumer<ItemStack[]> add = i -> Arrays.stream(i).filter(j -> !ItemStackHelper.isEmpty(j)).forEach(j -> labels.add(ILabel.Converter.from(j)));
        add.accept(inv.field_70460_b);
        add.accept(inv.field_70462_a);
        return labels;
    }

    void refreshResult() {
        if (this.calculator == null) {
            this.result.setLabels(new ArrayList<ILabel>());
        } else {
            switch (this.record.mode) {
                case INPUT: {
                    this.result.setLabels(this.calculator.getInputs());
                    break;
                }
                case OUTPUT: {
                    this.result.setLabels(this.calculator.getOutputs(this.getInventory()));
                    break;
                }
                case CATALYST: {
                    this.result.setLabels(this.calculator.getCatalysts());
                    break;
                }
                case STEPS: {
                    this.result.setLabels(this.calculator.getSteps());
                }
            }
        }
    }

    private void refreshLabel(ILabel l, boolean replace, boolean suggest) {
        boolean dup = this.record.push(l, replace);
        Controller.setRCraft(this.record);
        this.refreshRecent();
        this.refreshCalculator();
        if (suggest && GuiCraft.findRecipe(l).isEmpty()) {
            Pair<List<ILabel>, List<ILabel>> guess = ILabel.CONVERTER.guess(Collections.singletonList(l), null);
            LinkedHashSet match = new LinkedHashSet();
            ArrayList fuzzy = new ArrayList();
            Stream.of((List)guess.one, (List)guess.two).flatMap(Collection::stream).forEach(i -> {
                List<ILabel> list = GuiCraft.findRecipe(i);
                list.forEach(j -> match.add(j.setPercent(false).setAmount(1L)));
                if (!list.isEmpty()) {
                    fuzzy.add(i);
                }
            });
            match.addAll(fuzzy);
            ArrayList list = new ArrayList(match);
            if (!match.isEmpty()) {
                this.setOverlay(new Suggest(list.size() > 3 ? list.subList(0, 3) : list, !dup));
            }
        }
    }

    private static List<ILabel> findRecipe(ILabel l) {
        return Controller.recipeIterator().stream().map(i -> i.matches(l)).filter(Optional::isPresent).map(Optional::get).map(ILabel::copy).collect(Collectors.toList());
    }

    class Suggest
    extends WOverlay {
        boolean replace;

        public Suggest(List<ILabel> labels, boolean replace) {
            this.replace = replace;
            int width = labels.size() * 20;
            this.add(new WPanel(-width, 2, 56 + width, 30));
            this.add(new WLabel(31, 7, 20, 20, false).setLabel(GuiCraft.this.label.getLabel()).setLsnrUpdate((i, v) -> this.refresh((ILabel)v)));
            this.add(new WIcon(5 - width, 7, 18, 20, Resource.ICN_HELP, "craft.suggest"));
            this.add(new WLine(26, 7, 20, false));
            for (int i2 = 0; i2 < labels.size(); ++i2) {
                this.add(new WLabel(3 - i2 * 20, 7, 20, 20, false).setLabel(labels.get(i2)).setLsnrUpdate((j, v) -> this.refresh((ILabel)v)));
            }
        }

        public void refresh(ILabel l) {
            GuiCraft.this.setOverlay(null);
            GuiCraft.this.refreshLabel(l, this.replace, false);
        }
    }
}

