/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui;

import cpw.mods.fml.client.config.GuiUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.GuiCraft;
import me.towdium.jecalculation.gui.guis.GuiMath;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.nei.NEIPlugin;
import me.towdium.jecalculation.polyfill.mc.client.renderer.GlStateManager;
import me.towdium.jecalculation.utils.ItemStackHelper;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.input.Mouse;

@ParametersAreNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class JecaGui
extends GuiContainer {
    public static final KeyBinding keyOpenGuiCraft = new KeyBinding("jecalculation.key.gui_craft", 0, "jecalculation.key.category");
    public static final KeyBinding keyOpenGuiMath = new KeyBinding("jecalculation.key.gui_math", 0, "jecalculation.key.category");
    public static final int COLOR_GUI_GREY = -6184543;
    public static final int COLOR_TEXT_RED = 0xFF0000;
    public static final int COLOR_TEXT_GREY = 0x404040;
    public static final int COLOR_TEXT_WHITE = 0xFFFFFF;
    public static final boolean ALWAYS_TOOLTIP = false;
    public static final String SEPARATOR = new String();
    public ILabel hand = ILabel.EMPTY;
    protected static JecaGui last;
    protected static Runnable scheduled;
    protected static int timeout;
    protected JecaGui parent;
    public IGui root;

    public JecaGui(@Nullable JecaGui parent, IGui root) {
        this(parent, false, root);
    }

    public JecaGui(@Nullable JecaGui parent, boolean acceptsTransfer, IGui root) {
        super((Container)(acceptsTransfer ? new ContainerTransfer() : new ContainerNonTransfer()));
        this.parent = parent;
        this.root = root;
        if (this.field_147002_h instanceof JecaContainer) {
            ((JecaContainer)this.field_147002_h).setGui(this);
        }
    }

    public static int getMouseX() {
        JecaGui gui = JecaGui.getCurrent();
        return Mouse.getEventX() * gui.field_146294_l / gui.field_146297_k.field_71443_c - gui.field_147003_i;
    }

    public static int getMouseY() {
        JecaGui gui = JecaGui.getCurrent();
        return gui.field_146295_m - Mouse.getEventY() * gui.field_146295_m / gui.field_146297_k.field_71440_d - 1 - gui.field_147009_r;
    }

    public static boolean onMouse() {
        Optional<JecaGui> optionalJecaGui = JecaGui.currentJecaGui();
        if (!optionalJecaGui.isPresent()) {
            return false;
        }
        JecaGui gui = optionalJecaGui.get();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        int button = Mouse.getEventButton();
        if (button == -1) {
            int diff = Mouse.getEventDWheel() / 120;
            if (diff != 0) {
                gui.root.onMouseScroll(gui, xMouse, yMouse, diff);
            }
        } else if (Mouse.getEventButtonState()) {
            ILabel e;
            gui.root.onMouseFocused(gui, xMouse, yMouse, button);
            if (gui.root.onMouseClicked(gui, xMouse, yMouse, button)) {
                return true;
            }
            if (gui.hand != ILabel.EMPTY) {
                gui.hand = button == 0 ? NEIPlugin.getLabelUnderMouse() : ILabel.EMPTY;
                return true;
            }
            if (button == 0 && gui.root.acceptsLabel() && (e = NEIPlugin.getLabelUnderMouse()) != ILabel.EMPTY) {
                gui.hand = e;
                return true;
            }
        }
        return false;
    }

    public static void onMouseReleased() {
        Optional<JecaGui> optionalJecaGui = JecaGui.currentJecaGui();
        if (!optionalJecaGui.isPresent()) {
            return;
        }
        JecaGui gui = optionalJecaGui.get();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        int button = Mouse.getEventButton();
        gui.root.onMouseReleased(gui, xMouse, yMouse, button);
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        Object rep;
        InventoryBasic i = new InventoryBasic("", false, 1);
        Slot s = new Slot((IInventory)i, 0, 0, 0);
        ILabel l = this.getLabelUnderMouse();
        Object object = rep = l == null ? null : l.getRepresentation();
        if (rep instanceof ItemStack) {
            s.func_75215_d((ItemStack)rep);
        }
        return s;
    }

    public static boolean mouseIn(int xPos, int yPos, int xSize, int ySize, int xMouse, int yMouse) {
        return xMouse > xPos && yMouse > yPos && xMouse <= xPos + xSize && yMouse <= yPos + ySize;
    }

    public static void displayGui(IGui root) {
        JecaGui.displayGui(true, false, root);
    }

    public static void displayGui(boolean updateParent, boolean acceptsTransfer, IGui root) {
        JecaGui.displayGui(updateParent, acceptsTransfer, false, root);
    }

    public static void displayGui(boolean updateParent, boolean acceptsTransfer, boolean scheduled, IGui root) {
        Runnable r = () -> {
            if (Minecraft.func_71410_x().func_152345_ab()) {
                JecaGui.displayGuiUnsafe(updateParent, acceptsTransfer, root);
            }
        };
        if (scheduled) {
            JecaGui.scheduled = r;
            timeout = 1;
        } else {
            r.run();
        }
    }

    public static Optional<JecaGui> currentJecaGui() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof JecaGui) {
            return Optional.of((JecaGui)gui);
        }
        return Optional.empty();
    }

    public static JecaGui getCurrent() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        JecaGui ret = gui instanceof JecaGui ? (JecaGui)gui : null;
        return Objects.requireNonNull(ret);
    }

    private static void displayGuiUnsafe(boolean updateParent, boolean acceptsTransfer, IGui root) {
        Minecraft mc = Minecraft.func_71410_x();
        JecaGui parent = mc.field_71462_r == null ? null : (!(mc.field_71462_r instanceof JecaGui) ? last : (updateParent ? (JecaGui)mc.field_71462_r : ((JecaGui)mc.field_71462_r).parent));
        JecaGui toShow = new JecaGui(parent, acceptsTransfer, root);
        root.onVisible(toShow);
        last = toShow;
        mc.func_147108_a((GuiScreen)toShow);
    }

    public static void displayParent() {
        JecaGui gui = JecaGui.getCurrent().parent;
        gui.root.onVisible(gui);
        last = gui;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
    }

    @Nullable
    public ILabel getLabelUnderMouse() {
        Wrapper<Object> l = new Wrapper<Object>(null);
        this.root.getLabelUnderMouse(JecaGui.getMouseX(), JecaGui.getMouseY(), l);
        return (ILabel)l.value;
    }

    public static void onKey() {
        if (keyOpenGuiCraft.func_151468_f()) {
            JecaGui.openGuiCraft(false);
        }
        if (keyOpenGuiMath.func_151468_f()) {
            JecaGui.openGuiMath(false);
        }
    }

    public static void onGameTick() {
        if (scheduled != null) {
            if (timeout <= 0) {
                Runnable r = scheduled;
                scheduled = null;
                r.run();
            } else {
                --timeout;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void openGuiCraft(boolean scheduled) {
        JecaGui.displayGui(true, true, scheduled, new GuiCraft());
    }

    @SideOnly(value=Side.CLIENT)
    public static void openGuiMath(boolean scheduled) {
        JecaGui.displayGui(true, true, scheduled, new GuiMath());
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.pushMatrix();
        GlStateManager.translate(this.field_147003_i, this.field_147009_r, 0.0f);
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        this.root.onDraw(this, mouseX -= this.field_147003_i, mouseY -= this.field_147009_r);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translate(0.0f, 0.0f, 80.0f);
        this.hand.drawLabel(this, mouseX + this.field_147003_i, mouseY + this.field_147009_r, true);
        GlStateManager.popMatrix();
        ArrayList<String> tooltip = new ArrayList<String>();
        this.root.onTooltip(this, mouseX, mouseY, tooltip);
        this.drawHoveringText(tooltip, mouseX + this.field_147003_i, mouseY + this.field_147009_r);
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
    }

    public void drawHoveringText(List lines, int x, int y, FontRenderer font) {
        List textLines = lines;
        if (!textLines.isEmpty()) {
            GlStateManager.disableRescaleNormal();
            RenderHelper.func_74518_a();
            GlStateManager.disableLighting();
            GlStateManager.disableDepth();
            int i = 0;
            int separators = 0;
            for (String s : textLines) {
                int j = font.func_78256_a(s);
                if (j > i) {
                    i = j;
                }
                if (s != SEPARATOR) continue;
                ++separators;
            }
            if (textLines.get(textLines.size() - 1) == SEPARATOR) {
                --separators;
            }
            int l1 = x + 12;
            int i2 = y - 12;
            int k = 8 + (textLines.size() - separators - 1) * 10 + 2 * separators;
            if (l1 + i > this.field_146294_l) {
                l1 -= 28 + i;
            }
            if (i2 + k + 6 > this.field_146295_m) {
                i2 = this.field_146295_m - k - 6;
            }
            this.field_73735_i = 300.0f;
            JecaGui.field_146296_j.field_77023_b = 300.0f;
            this.func_73733_a(l1 - 3, i2 - 4, l1 + i + 3, i2 - 3, -267386864, -267386864);
            this.func_73733_a(l1 - 3, i2 + k + 3, l1 + i + 3, i2 + k + 4, -267386864, -267386864);
            this.func_73733_a(l1 - 3, i2 - 3, l1 + i + 3, i2 + k + 3, -267386864, -267386864);
            this.func_73733_a(l1 - 4, i2 - 3, l1 - 3, i2 + k + 3, -267386864, -267386864);
            this.func_73733_a(l1 + i + 3, i2 - 3, l1 + i + 4, i2 + k + 3, -267386864, -267386864);
            this.func_73733_a(l1 - 3, i2 - 3 + 1, l1 - 3 + 1, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(l1 + i + 2, i2 - 3 + 1, l1 + i + 3, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(l1 - 3, i2 - 3, l1 + i + 3, i2 - 3 + 1, 0x505000FF, 0x505000FF);
            this.func_73733_a(l1 - 3, i2 + k + 2, l1 + i + 3, i2 + k + 3, 1344798847, 1344798847);
            for (String s1 : textLines) {
                if (s1 == SEPARATOR) {
                    i2 += 2;
                    continue;
                }
                font.func_78261_a(s1, l1, i2, -1);
                i2 += 10;
            }
            this.field_73735_i = 0.0f;
            JecaGui.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.enableLighting();
            GlStateManager.enableDepth();
            RenderHelper.func_74519_b();
            GlStateManager.enableRescaleNormal();
        }
    }

    public void drawResource(Resource r, int xPos, int yPos) {
        this.drawResource(r, xPos, yPos, 0xFFFFFF);
    }

    public void drawResource(Resource r, int xPos, int yPos, int color) {
        this.setColor(color);
        this.field_146297_k.func_110434_K().func_110577_a(r.getResourceLocation());
        this.func_73729_b(xPos, yPos, r.getXPos(), r.getYPos(), r.getXSize(), r.getYSize());
    }

    public void drawResourceContinuous(Resource r, int xPos, int yPos, int xSize, int ySize, int border) {
        this.drawResourceContinuous(r, xPos, yPos, xSize, ySize, border, border, border, border);
    }

    public void drawResourceContinuous(Resource r, int xPos, int yPos, int xSize, int ySize, int borderTop, int borderBottom, int borderLeft, int borderRight) {
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)r.getResourceLocation(), (int)xPos, (int)yPos, (int)r.getXPos(), (int)r.getYPos(), (int)xSize, (int)ySize, (int)r.getXSize(), (int)r.getYSize(), (int)borderTop, (int)borderBottom, (int)borderLeft, (int)borderRight, (float)0.0f);
    }

    private void setColor(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(~(color >> 24) & 0xFF) / 255.0f;
        GlStateManager.color(red, green, blue, alpha);
    }

    public void drawFluid(Fluid f, int xPos, int yPos, int xSize, int ySize) {
        IIcon fluidIcon = f.getFlowingIcon();
        if (fluidIcon == null) {
            fluidIcon = f.getStillIcon();
        }
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.setColor(f.getColor() & 0xFFFFFF);
        if (fluidIcon != null) {
            this.func_94065_a(xPos, yPos, fluidIcon, xSize, ySize);
        }
    }

    public void drawRectangle(int xPos, int yPos, int xSize, int ySize, int color) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        int right = xPos + xSize;
        int bottom = yPos + ySize;
        Tessellator tessellator = Tessellator.field_78398_a;
        GlStateManager.disableTexture2D();
        GlStateManager.color(f, f1, f2, f3);
        GlStateManager.disableAlpha();
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)xPos, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)bottom, 0.0);
        tessellator.func_78377_a((double)right, (double)yPos, 0.0);
        tessellator.func_78377_a((double)xPos, (double)yPos, 0.0);
        tessellator.func_78381_a();
        GlStateManager.enableAlpha();
        GlStateManager.enableTexture2D();
    }

    public int getStringWidth(String s) {
        return this.field_146289_q.func_78256_a(s);
    }

    public void drawSplitText(float xPos, float yPos, int width, Font f, String s) {
        this.drawSplitText(xPos, yPos, f, Utilities.I18n.wrap(s, width));
    }

    public void drawSplitText(float xPos, float yPos, Font f, List<String> ss) {
        this.drawText(xPos, yPos, f, () -> {
            int y = 0;
            for (String i : ss) {
                if (f.shadow) {
                    this.field_146289_q.func_78261_a(i, 0, y, f.color);
                } else {
                    this.field_146289_q.func_78276_b(i, 0, y, f.color);
                }
                y += this.field_146289_q.field_78288_b + 1;
            }
        });
    }

    public void drawText(float xPos, float yPos, Font f, String s) {
        this.drawText(xPos, yPos, Integer.MAX_VALUE, f, s);
    }

    public void drawText(float xPos, float yPos, int width, Font f, String s) {
        this.drawText(xPos, yPos, f, () -> {
            String str = s;
            int strWidth = f.getTextWidth(str);
            int ellipsisWidth = f.getTextWidth("...");
            if (strWidth > width && strWidth > ellipsisWidth) {
                str = f.trimToWidth(str, width - ellipsisWidth).trim() + "...";
            }
            if (f.shadow) {
                this.field_146289_q.func_78261_a(str, 0, 0, f.color);
            }
            this.field_146289_q.func_78276_b(str, 0, 0, f.color);
        });
    }

    private void drawText(float xPos, float yPos, Font f, Runnable r) {
        boolean unicode = this.field_146289_q.func_82883_a();
        if (f.raw) {
            this.field_146289_q.func_78264_a(false);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate(xPos, yPos, 0.0f);
        if (f.half) {
            GlStateManager.scale(0.5, 0.5, 1.0);
        }
        r.run();
        GlStateManager.popMatrix();
        this.field_146289_q.func_78264_a(unicode);
    }

    public void drawItemStack(int xPos, int yPos, ItemStack is, boolean centred) {
        if (ItemStackHelper.isEmpty(is)) {
            return;
        }
        if (centred) {
            xPos -= 8;
            yPos -= 8;
        }
        float zLevel = JecaGui.field_146296_j.field_77023_b += 100.0f;
        GlStateManager.enableDepth();
        RenderHelper.func_74520_c();
        FontRenderer font = is.func_77973_b().getFontRenderer(is);
        if (font == null) {
            font = this.field_146289_q;
        }
        field_146296_j.func_82406_b(font, Minecraft.func_71410_x().field_71446_o, is, xPos, yPos);
        field_146296_j.func_77021_b(font, Minecraft.func_71410_x().field_71446_o, is, xPos, yPos);
        RenderHelper.func_74518_a();
        GlStateManager.disableDepth();
        JecaGui.field_146296_j.field_77023_b = zLevel - 100.0f;
    }

    public void func_73866_w_() {
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 && this.hand != ILabel.EMPTY) {
            this.hand = ILabel.EMPTY;
        } else if (!this.root.onKeyPressed(this, typedChar, keyCode)) {
            if (keyCode == 1 && this.parent != null) {
                JecaGui.displayParent();
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    public void drawHoveringText(List<String> textLines, int x, int y) {
        this.drawHoveringText(textLines, x, y, this.field_146289_q);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ContainerNonTransfer
    extends JecaContainer {
    }

    @SideOnly(value=Side.CLIENT)
    public static class ContainerTransfer
    extends JecaContainer {
    }

    @SideOnly(value=Side.CLIENT)
    public static class JecaContainer
    extends Container {
        JecaGui gui;

        public JecaGui getGui() {
            return this.gui;
        }

        public void setGui(JecaGui gui) {
            this.gui = gui;
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Font {
        public static final Font SHADOW = new Font(0xFFFFFF, true, false, false);
        public static final Font PLAIN = new Font(0x404040, false, false, false);
        public static final Font RAW = new Font(0x404040, false, false, true);
        public static final Font HALF = new Font(0xFFFFFF, true, true, true);
        public int color;
        public boolean shadow;
        public boolean half;
        public boolean raw;

        public Font(int color, boolean shadow, boolean half, boolean raw) {
            this.color = color;
            this.shadow = shadow;
            this.half = half;
            this.raw = raw;
        }

        public int getTextWidth(String s) {
            FontRenderer fr = JecaGui.getCurrent().field_146289_q;
            boolean flag = fr.func_82883_a();
            if (this.raw) {
                fr.func_78264_a(false);
            }
            int ret = (int)Math.ceil((float)fr.func_78256_a(s) * (this.half ? 0.5f : 1.0f));
            fr.func_78264_a(flag);
            return ret;
        }

        public int getTextHeight() {
            return (int)Math.ceil((float)((JecaGui)JecaGui.getCurrent()).field_146289_q.field_78288_b * (this.half ? 0.5f : 1.0f));
        }

        public String trimToWidth(String s, int i) {
            return JecaGui.getCurrent().field_146289_q.func_78269_a(s, i * (this.half ? 2 : 1));
        }
    }
}

