/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.data.structure.Recipes;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CostList {
    List<ILabel> labels;

    public CostList() {
        this.labels = new ArrayList<ILabel>();
    }

    public CostList(List<ILabel> labels) {
        this.labels = labels.stream().filter(i -> i != ILabel.EMPTY).map(i -> i.copy().multiply(-1.0f)).collect(Collectors.toList());
    }

    public CostList(List<ILabel> positive, List<ILabel> negative) {
        this(positive);
        this.multiply(-1L);
        this.mergeInplace(new CostList(negative), false);
    }

    public static CostList merge(CostList a, CostList b, boolean strict) {
        CostList ret = a.copy();
        ret.mergeInplace(b, strict);
        return ret;
    }

    public void mergeInplace(CostList that, boolean strict) {
        that.labels.forEach(i -> this.labels.add(i.copy()));
        for (int i2 = 0; i2 < this.labels.size(); ++i2) {
            for (int j = i2 + 1; j < this.labels.size(); ++j) {
                if (strict) {
                    ILabel b;
                    ILabel a = this.labels.get(i2);
                    if (!a.matches(b = this.labels.get(j))) continue;
                    this.labels.set(i2, a.setAmount(Math.addExact(a.getAmount(), b.getAmount())));
                    this.labels.set(j, ILabel.EMPTY);
                    continue;
                }
                Optional<ILabel> l = ILabel.MERGER.merge(this.labels.get(i2), this.labels.get(j));
                if (!l.isPresent()) continue;
                this.labels.set(i2, l.get());
                this.labels.set(j, ILabel.EMPTY);
            }
        }
        this.labels = this.labels.stream().filter(i -> i != ILabel.EMPTY).collect(Collectors.toList());
    }

    public CostList multiply(long i) {
        this.labels = this.labels.stream().map(j -> j.multiply(i)).collect(Collectors.toList());
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CostList) {
            CostList c = (CostList)obj;
            CostList m = c.copy().multiply(-1L);
            return CostList.merge((CostList)this, (CostList)m, (boolean)true).labels.isEmpty();
        }
        return false;
    }

    public CostList copy() {
        CostList ret = new CostList();
        ret.labels = this.labels.stream().map(ILabel::copy).collect(Collectors.toList());
        return ret;
    }

    public boolean isEmpty() {
        return this.labels.isEmpty();
    }

    public List<ILabel> getLabels() {
        return this.labels;
    }

    public Calculator calculate() {
        return new Calculator();
    }

    public int hashCode() {
        int hash = 0;
        for (ILabel i : this.labels) {
            hash ^= i.hashCode();
        }
        return hash;
    }

    public class Calculator {
        ArrayList<Pair<CostList, CostList>> procedure = new ArrayList();
        ArrayList<ILabel> catalysts = new ArrayList();
        Recipes.RecipeIterator iterator = Controller.recipeIterator();
        private int index;

        public Calculator() throws ArithmeticException {
            HashSet<CostList> set = new HashSet<CostList>();
            set.add(CostList.this);
            this.reset();
            Pair<Recipe, Long> next = this.find();
            int count = 0;
            while (next != null) {
                CostList original = this.getCurrent();
                List<ILabel> outL = ((Recipe)next.one).getOutput().stream().filter(i -> i != ILabel.EMPTY).collect(Collectors.toList());
                CostList outC = new CostList(outL);
                outC.multiply(-((Long)next.two).longValue());
                List<ILabel> inL = ((Recipe)next.one).getInput().stream().filter(i -> i != ILabel.EMPTY).collect(Collectors.toList());
                CostList inC = new CostList(inL);
                inC.multiply((Long)next.two);
                CostList result = CostList.merge(original, outC, false);
                result.mergeInplace(inC, false);
                if (!set.contains(result)) {
                    set.add(result);
                    this.procedure.add(new Pair<CostList, CostList>(result, outC));
                    this.addCatalyst(((Recipe)next.one).getCatalyst());
                    this.reset();
                }
                next = this.find();
                if (count++ <= 1000) continue;
                Utilities.addChatMessage(Utilities.ChatMessage.MAX_LOOP);
                break;
            }
        }

        private void reset() {
            this.index = 0;
            this.iterator = Controller.recipeIterator();
        }

        @Nullable
        private Pair<Recipe, Long> find() {
            List<ILabel> labels = this.getCurrent().labels;
            while (this.index < labels.size()) {
                ILabel label = labels.get(this.index);
                if (label.getAmount() < 0L) {
                    while (this.iterator.hasNext()) {
                        Recipe r = this.iterator.next();
                        if (!r.matches(label).isPresent()) continue;
                        return new Pair<Recipe, Long>(r, r.multiplier(label));
                    }
                    this.iterator = Controller.recipeIterator();
                }
                ++this.index;
            }
            return null;
        }

        private void addCatalyst(List<ILabel> labels) {
            labels.stream().filter(i -> i != ILabel.EMPTY).forEach(i -> this.catalysts.stream().filter(j -> j.matches(i)).findAny().map(j -> j.setAmount(Math.max(i.getAmount(), j.getAmount()))).orElseGet(Utilities.fake(() -> this.catalysts.add((ILabel)i))));
        }

        private CostList getCurrent() {
            return this.procedure.isEmpty() ? CostList.this : (CostList)this.procedure.get((int)(this.procedure.size() - 1)).one;
        }

        public List<ILabel> getCatalysts() {
            return this.catalysts;
        }

        public List<ILabel> getInputs() {
            return this.getCurrent().labels.stream().filter(i -> i.getAmount() < 0L).map(i -> i.copy().multiply(-1.0f)).collect(Collectors.toList());
        }

        public List<ILabel> getOutputs(List<ILabel> ignore) {
            return this.getCurrent().labels.stream().map(i -> i.copy().multiply(-1.0f)).map(i -> ignore.stream().flatMap(j -> Utilities.stream(ILabel.MERGER.merge((ILabel)i, (ILabel)j))).findFirst().orElse(i)).filter(i -> i != ILabel.EMPTY && i.getAmount() < 0L).map(i -> i.multiply(-1.0f)).collect(Collectors.toList());
        }

        public List<ILabel> getSteps() {
            List<ILabel> ret = this.procedure.stream().map(i -> ((CostList)i.two).labels.get(0)).collect(Collectors.toList());
            Collections.reverse(ret);
            CostList cl = new CostList(ret).multiply(-1L);
            CostList temp = new CostList();
            temp.mergeInplace(cl, false);
            return temp.labels;
        }
    }
}

