/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.utils.ItemStackHelper;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

@ParametersAreNonnullByDefault
public class LItemStack
extends ILabel.Impl {
    public static final String IDENTIFIER = "itemStack";
    private static final String KEY_ITEM = "item";
    private static final String KEY_META = "meta";
    private static final String KEY_NBT = "tag";
    private static final String KEY_F_META = "fMeta";
    private static final String KEY_F_NBT = "fNbt";
    Item item;
    int meta;
    NBTTagCompound nbt;
    boolean fMeta;
    boolean fNbt;
    transient ItemStack rep;

    public LItemStack(ItemStack is) {
        super(is.field_77994_a, false);
        this.init(is.func_77973_b(), is.func_77960_j(), is.func_77978_p(), false, false);
    }

    public LItemStack(NBTTagCompound tag) {
        super(tag);
        String strId = tag.func_74779_i(KEY_ITEM);
        if (!tag.func_74764_b("id")) {
            tag.func_74777_a("id", (short)GameData.getItemRegistry().getId(strId));
        }
        tag.func_74774_a("Count", (byte)1);
        tag.func_74777_a("Damage", tag.func_74764_b(KEY_META) ? (short)tag.func_74762_e(KEY_META) : (short)0);
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
        if (ItemStackHelper.isEmpty(stack)) {
            throw new ILabel.Serializer.SerializationException("Item " + strId + " cannot be resolved, ignoring");
        }
        Item i = stack.func_77973_b();
        this.init(i, tag.func_74762_e(KEY_META), tag.func_74764_b(KEY_NBT) ? stack.field_77990_d : null, tag.func_74767_n(KEY_F_META), tag.func_74767_n(KEY_F_NBT));
    }

    private LItemStack(LItemStack lis) {
        super(lis);
        this.item = lis.item;
        this.meta = lis.meta;
        this.nbt = lis.nbt;
        this.fMeta = lis.fMeta;
        this.fNbt = lis.fNbt;
        this.rep = lis.rep;
    }

    private void init(@Nullable Item item, int meta, @Nullable NBTTagCompound nbt, boolean fMeta, boolean fNbt) {
        Objects.requireNonNull(item);
        this.item = item;
        this.meta = fMeta ? 0 : meta;
        this.nbt = fNbt ? null : nbt;
        this.fMeta = fMeta;
        this.fNbt = fNbt;
        this.rep = new ItemStack(item, 1, this.meta);
        this.rep.func_77982_d(this.nbt);
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LItemStack && b instanceof LItemStack) {
            LItemStack lisA = (LItemStack)a;
            LItemStack lisB = (LItemStack)b;
            if (lisA.meta != lisB.meta && !lisA.fMeta && lisA.meta != Short.MAX_VALUE && !lisB.fMeta && lisB.meta != Short.MAX_VALUE) {
                return false;
            }
            if (!lisA.fNbt && !lisB.fNbt && (lisA.nbt == null ? lisB.nbt != null : lisB.nbt == null || !lisA.nbt.equals((Object)lisB.nbt))) {
                return false;
            }
            return lisA.item == lisB.item;
        }
        return false;
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable Class<?> context) {
        if (iss.size() == 0) {
            return new ArrayList<ILabel>();
        }
        for (ILabel i : iss) {
            if (i instanceof LItemStack) continue;
            return new ArrayList<ILabel>();
        }
        LItemStack lis = (LItemStack)iss.get(0);
        boolean fMeta = false;
        boolean fNbt = false;
        for (ILabel i : iss) {
            LItemStack ii = (LItemStack)i;
            if (ii.item != lis.item) {
                return new ArrayList<ILabel>();
            }
            if (ii.meta != lis.meta || ii.fMeta) {
                fMeta = true;
            }
            if (Objects.equals(ii.nbt, lis.nbt)) continue;
            fNbt = true;
        }
        if (fMeta || fNbt) {
            return Collections.singletonList(lis.copy().setFMeta(fMeta).setFNbt(fNbt));
        }
        return new ArrayList<ILabel>();
    }

    public static List<ILabel> fallback(List<ILabel> iss, @Nullable Class<?> context) {
        ArrayList<ILabel> ret = new ArrayList<ILabel>();
        if (iss.size() == 1) {
            ILabel label = iss.get(0);
            if (!(label instanceof LItemStack)) {
                return ret;
            }
            LItemStack lis = (LItemStack)label;
            if (lis.fNbt || lis.fMeta) {
                return new ArrayList<ILabel>();
            }
            ret.add(lis.copy().setFMeta(true));
            ret.add(lis.copy().setFNbt(true));
            ret.add(lis.copy().setFMeta(true).setFNbt(true));
        }
        return ret;
    }

    public LItemStack setFMeta(boolean f) {
        this.fMeta = f;
        if (f) {
            this.meta = 0;
        }
        this.rep = new ItemStack(this.item, 1, this.meta);
        this.rep.func_77982_d(this.nbt);
        return this;
    }

    public LItemStack setFNbt(boolean f) {
        this.fNbt = f;
        if (f) {
            this.nbt = null;
        }
        this.rep = new ItemStack(this.item, 1, this.meta);
        this.rep.func_77982_d(this.nbt);
        return this;
    }

    public ItemStack getRep() {
        return this.rep;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        if (this.fMeta) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_meta", new Object[0]));
        }
        if (this.fNbt) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_nbt", new Object[0]));
        }
        existing.add("\u00a79\u00a7o" + Utilities.getModName(this.item));
    }

    public ItemStack getRepresentation() {
        return this.rep;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return this.rep.func_77973_b() == null ? "" : this.rep.func_82833_r();
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        if (l instanceof LItemStack) {
            LItemStack lis = (LItemStack)l;
            return Objects.equals(this.nbt, lis.nbt) && this.meta == lis.meta && this.item == lis.item && this.fNbt == lis.fNbt && super.matches(l) && this.fMeta == lis.fMeta;
        }
        return false;
    }

    @Override
    public LItemStack copy() {
        return new LItemStack(this);
    }

    @Override
    public NBTTagCompound toNbt() {
        if (this.item == null) {
            return ILabel.EMPTY.toNbt();
        }
        String strId = Item.field_150901_e.func_148750_c((Object)this.item);
        NBTTagCompound ret = super.toNbt();
        if (this.meta != 0) {
            ret.func_74768_a(KEY_META, this.meta);
        }
        ret.func_74778_a(KEY_ITEM, strId);
        if (this.nbt != null) {
            ret.func_74782_a(KEY_NBT, (NBTBase)this.nbt);
        }
        if (this.fMeta) {
            ret.func_74757_a(KEY_F_META, true);
        }
        if (this.fNbt) {
            ret.func_74757_a(KEY_F_NBT, true);
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawLabel(JecaGui gui) {
        gui.drawItemStack(0, 0, this.rep, false);
    }

    @Override
    public int hashCode() {
        return (this.nbt == null ? 0 : this.nbt.hashCode()) ^ this.meta ^ this.item.func_77658_a().hashCode() ^ (int)this.amount;
    }
}

