/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.config;

import bre.fpsreducer.config.GlobalConfig;
import bre.fpsreducer.config.PlayerConfig;
import bre.fpsreducer.utils.Logger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class CommonConfig {
    protected Configuration cfg;
    public static GlobalConfig globalConfig = null;
    public static PlayerConfig playerConfig = null;
    public static CommonConfig currentConfig = null;
    private static final String configVersion = "3";
    public boolean enableFpsReducer;
    public int waitingTime;
    public int idleFPS;
    public boolean ignoreHoldButton;
    public boolean reducingInBackground;
    public boolean suppressSound;
    public int suppressedVolume;
    public boolean inquireInitSetting;
    private Property enableFpsReducerProp;
    private Property waitingTimeProp;
    private Property idleFpsProp;
    private Property ignoreHoldButtonProp;
    private Property reducingInBackgroundProp;
    private Property suppressSoundProp;
    private Property suppressedVolumeProp;
    private Property inquireInitSettingProp;
    protected boolean enableFpsReducerDefault;
    protected int waitingTimeDefault;
    protected int idleFPSDefault;
    protected boolean ignoreHoldButtonDefault;
    protected boolean reducingInBackgroundDefault;
    protected boolean suppressSoundDefalut;
    protected int suppressedVolumeDefalut;
    protected boolean inquireInitSettingDefalut;

    public CommonConfig(File configFile) {
        this.cfg = new Configuration(configFile, configVersion);
        try {
            this.loadConfig();
        }
        catch (Exception e) {
            Logger.error("FpsReducer config file access error.");
        }
        finally {
            this.convertVersion();
            this.saveConfig();
        }
    }

    protected void initDefaultValue() {
        this.enableFpsReducerDefault = true;
        this.waitingTimeDefault = 300;
        this.idleFPSDefault = 10;
        this.ignoreHoldButtonDefault = false;
        this.reducingInBackgroundDefault = false;
        this.suppressSoundDefalut = false;
        this.suppressedVolumeDefalut = 10;
        this.inquireInitSettingDefalut = false;
    }

    public void loadConfig() {
        this.cfg.load();
        this.initDefaultValue();
        this.enableFpsReducerProp = this.cfg.get("common", "enableFpsReducer", this.enableFpsReducerDefault, "Enable reducing FPS when no user activity has been sensed for a certain time.");
        this.waitingTimeProp = this.cfg.get("common", "waitingTime", this.waitingTimeDefault, "Waiting time(sec) until reducing FPS.", 0, 86400);
        this.idleFpsProp = this.cfg.get("common", "idleFPS", this.idleFPSDefault, "Frame rate during reducing.", 1, 260);
        this.ignoreHoldButtonProp = this.cfg.get("common", "ignoreHoldButton", this.ignoreHoldButtonDefault, "Ignore the mouse button holding.");
        this.reducingInBackgroundProp = this.cfg.get("common", "reducingInBackground", this.reducingInBackgroundDefault, "Force reducing FPS if the window is inactive.");
        this.suppressSoundProp = this.cfg.get("common", "suppressSound", this.suppressSoundDefalut, "Suppress master volume if the window is inactive.");
        this.suppressedVolumeProp = this.cfg.get("common", "suppressedVolume", this.suppressedVolumeDefalut, "Suppression master volume ratio in inactive (0-100).", 0, 100);
        this.inquireInitSettingProp = this.cfg.get("common", "inquireInitSetting", this.inquireInitSettingDefalut, "Inquire easy initial configuration in chat. Since it works only in player config mode,\nplayer config mode is forcibly enabled at initial creation of a player config.\nOnce easy config is selected in chat, no further inquiry will be displayed.");
        this.enableFpsReducer = this.enableFpsReducerProp.getBoolean();
        this.waitingTime = this.waitingTimeProp.getInt();
        this.idleFPS = this.idleFpsProp.getInt();
        this.ignoreHoldButton = this.ignoreHoldButtonProp.getBoolean();
        this.reducingInBackground = this.reducingInBackgroundProp.getBoolean();
        this.suppressSound = this.suppressSoundProp.getBoolean();
        this.suppressedVolume = this.suppressedVolumeProp.getInt();
        this.inquireInitSetting = this.inquireInitSettingProp.getBoolean();
    }

    protected void saveConfig() {
        this.waitingTimeProp.setValue(this.waitingTime);
        this.idleFpsProp.setValue(this.idleFPS);
        this.enableFpsReducerProp.setValue(this.enableFpsReducer);
        this.ignoreHoldButtonProp.setValue(this.ignoreHoldButton);
        this.reducingInBackgroundProp.setValue(this.reducingInBackground);
        this.suppressSoundProp.setValue(this.suppressSound);
        this.suppressedVolumeProp.setValue(this.suppressedVolume);
        this.inquireInitSettingProp.setValue(this.inquireInitSetting);
        this.cfg.save();
    }

    protected void convertVersion() {
    }

    protected void removeKey(String category, String key) {
        if (this.cfg.hasKey(category, key)) {
            this.cfg.moveProperty(category, key, "work");
            this.cfg.removeCategory(this.cfg.getCategory("work"));
        }
    }

    public static void saveCurrentConfig() {
        if (CommonConfig.isPlayerConfig()) {
            playerConfig.saveConfig();
        }
        globalConfig.saveConfig();
    }

    public static boolean isPlayerConfig() {
        return CommonConfig.globalConfig.enablePerPlayerConfig && playerConfig != null && CommonConfig.playerConfig.usePlayerConfig;
    }

    public static void toggleConfig() {
        if (playerConfig == null) {
            PlayerConfig.readPlayerConfig();
        }
        if (playerConfig != null) {
            CommonConfig.playerConfig.usePlayerConfig = !CommonConfig.playerConfig.usePlayerConfig;
            currentConfig = CommonConfig.isPlayerConfig() ? playerConfig : globalConfig;
            playerConfig.saveConfig();
        }
    }
}

