/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.LinkedList;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.FuzzyInventoryUtil;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.InventoryUtil;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class InventoryUtilFactory {
    private final LinkedList<SpecialInventoryHandler> handler = new LinkedList();

    public void registerHandler(SpecialInventoryHandler invHandler) {
        if (invHandler.init()) {
            this.handler.addLast(invHandler);
            LogisticsPipes.log.info("Loaded SpecialInventoryHandler: " + invHandler.getClass().getCanonicalName());
        } else {
            LogisticsPipes.log.warn("Could not load SpecialInventoryHandler: " + invHandler.getClass().getCanonicalName());
        }
    }

    private TileEntity getTileEntityFromInventory(IInventory inv) {
        if (inv instanceof TileEntity) {
            return (TileEntity)inv;
        }
        if (inv instanceof SidedInventoryMinecraftAdapter && ((SidedInventoryMinecraftAdapter)inv)._sidedInventory instanceof TileEntity) {
            return (TileEntity)((SidedInventoryMinecraftAdapter)inv)._sidedInventory;
        }
        return null;
    }

    public SpecialInventoryHandler getUtilForInv(IInventory inv, ForgeDirection dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        TileEntity tile = this.getTileEntityFromInventory(inv);
        if (tile == null) {
            return null;
        }
        for (SpecialInventoryHandler invHandler : this.handler) {
            if (!invHandler.isType(tile)) continue;
            return invHandler.getUtilForTile(tile, dir, hideOnePerStack, hideOne, cropStart, cropEnd);
        }
        return null;
    }

    @Deprecated
    public IInventoryUtil getInventoryUtil(IInventory inv) {
        return this.getInventoryUtil(inv, ForgeDirection.UNKNOWN);
    }

    public IInventoryUtil getInventoryUtil(IInventory inv, ForgeDirection dir) {
        return this.getHidingInventoryUtil(inv, dir, false, false, 0, 0);
    }

    public IInventoryUtil getHidingInventoryUtil(IInventory inv, ForgeDirection dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        IInventoryUtil util = this.getUtilForInv(inv, dir, hideOnePerStack, hideOne, cropStart, cropEnd);
        if (util == null) {
            util = new InventoryUtil(InventoryHelper.getInventory(inv), hideOnePerStack, hideOne, cropStart, cropEnd);
        }
        return util;
    }

    public IInventoryUtil getFuzzyInventoryUtil(IInventory inv) {
        return new FuzzyInventoryUtil(inv);
    }
}

