/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.tileentities.automation.GT_MetaTileEntity_TypeFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import logisticspipes.gui.hud.modules.HUDStringBasedItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.IStringBasedModule;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.StringBasedItemSinkModuleGuiInHand;
import logisticspipes.network.guis.module.inpipe.StringBasedItemSinkModuleGuiSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ItemSinkListPacket;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ModuleTypeFilterItemSink
extends LogisticsGuiModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IStringBasedModule {
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final IHUDModuleRenderer HUD = new HUDStringBasedItemSink(this);
    private SinkReply sinkReply;
    private final EnumSet<OrePrefixes> prefixes = EnumSet.noneOf(OrePrefixes.class);
    private List<String> clientPrefixes = new ArrayList<String>();

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this.sinkReply = new SinkReply(SinkReply.FixedPriority.GT_TypeFilterSink, 0, true, false, 5, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > this.sinkReply.fixedPriority.ordinal() || bestPriority == this.sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this.sinkReply.customPriority) {
            return null;
        }
        if (this.isStackAllowed(item)) {
            return this.sinkReply;
        }
        return null;
    }

    private boolean isStackAllowed(ItemIdentifier identifier) {
        ItemStack stack = identifier.makeNormalStackNoTag(1);
        ItemData data = GT_OreDictUnificator.getItemData((ItemStack)stack);
        for (OrePrefixes prefix : this.prefixes) {
            if (prefix == OrePrefixes.ore && data != null && data.mPrefix != null && GT_MetaTileEntity_TypeFilter.OREBLOCK_PREFIXES.contains((Object)data.mPrefix)) {
                return true;
            }
            if (!prefix.contains(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.prefixes.isEmpty()) {
            return Collections.singletonList("No prefixes");
        }
        list.add("Prefixes: ");
        for (OrePrefixes prefix : this.prefixes) {
            list.add(prefix.toString());
        }
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ItemSinkListPacket.class).setNbt(nbt).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return NewGuiHandler.getGui(StringBasedItemSinkModuleGuiSlot.class).setNbt(nbt);
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(StringBasedItemSinkModuleGuiInHand.class);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleTypeFilterSink");
    }

    @Override
    public List<String> getStringList() {
        this.clientPrefixes = this.prefixes.stream().map(Enum::toString).collect(Collectors.toList());
        return this.clientPrefixes;
    }

    @Override
    public String getStringForItem(ItemIdentifier ident) {
        ItemData data = GT_OreDictUnificator.getAssociation((ItemStack)ident.makeNormalStackNoTag(1));
        if (data != null && data.hasValidPrefixData()) {
            return data.mPrefix.toString();
        }
        return "";
    }

    @Override
    public void listChanged() {
        NBTTagCompound nbt;
        this.prefixes.clear();
        for (String prefixName : this.clientPrefixes) {
            OrePrefixes prefix = OrePrefixes.getPrefix((String)prefixName);
            if (prefix == null) continue;
            this.prefixes.add(prefix);
        }
        if (MainProxy.isServer(this._world.getWorld())) {
            nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ItemSinkListPacket.class).setNbt(nbt).setModulePos(this), this.localModeWatchers);
        } else {
            nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(PacketHandler.getPacket(ItemSinkListPacket.class).setNbt(nbt).setModulePos(this));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.prefixes.clear();
        int limit = nbt.func_74762_e("size");
        for (int i = 0; i < limit; ++i) {
            OrePrefixes prefix = OrePrefixes.getPrefix((String)nbt.func_74779_i("prefix_" + i));
            if (prefix == null) continue;
            this.prefixes.add(prefix);
        }
        this.clientPrefixes.clear();
        for (OrePrefixes prefix : this.prefixes) {
            this.clientPrefixes.add(prefix.toString());
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("size", this.prefixes.size());
        int i = 0;
        for (OrePrefixes prefix : this.prefixes) {
            nbt.func_74778_a("prefix_" + i, prefix.toString());
            ++i;
        }
    }
}

