/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import logisticspipes.logic.BaseLogicConnection;
import logisticspipes.logic.BaseLogicTask;
import logisticspipes.utils.item.SimpleStackInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class LogicController {
    public SimpleStackInventory diskInv = new SimpleStackInventory(1, "Disk Inv", 1);
    public List<BaseLogicConnection> connections = new ArrayList<BaseLogicConnection>();
    public List<BaseLogicTask> tasks = new ArrayList<BaseLogicTask>();
    private final Thread oldThread = null;
    private boolean unresolvedTasks = false;

    public void calculate(TileEntity tile) {
        if (this.oldThread != null && this.oldThread.isAlive()) {
            return;
        }
        for (BaseLogicTask task : this.tasks) {
            task.syncTick(tile);
        }
        for (BaseLogicConnection connection : this.connections) {
            if (connection.isInvalidConnection()) continue;
            if (connection.getSource().getAmountOfOutput() <= connection.getSourceIndex()) {
                connection.setInvalidConnection(true);
                continue;
            }
            if (connection.getSource().getOutputParameterType(connection.getSourceIndex()) != connection.getType()) {
                connection.setInvalidConnection(true);
                continue;
            }
            if (connection.getTarget().getAmountOfInput() <= connection.getTargetIndex()) {
                connection.setInvalidConnection(true);
                continue;
            }
            if (connection.getTarget().getInputParameterType(connection.getTargetIndex()) == connection.getType()) continue;
            connection.setInvalidConnection(true);
        }
        ArrayList<BaseLogicTask> toDos = new ArrayList<BaseLogicTask>(this.tasks);
        while (!toDos.isEmpty()) {
            boolean nothingDone = true;
            Iterator iter = toDos.iterator();
            while (iter.hasNext()) {
                BaseLogicTask task = (BaseLogicTask)iter.next();
                if (!task.isCalculated()) continue;
                iter.remove();
                nothingDone = false;
            }
            for (BaseLogicConnection connection : this.connections) {
                if (connection.isInvalidConnection() || !connection.getSource().isCalculated()) continue;
                connection.getTarget().setInputParameter(connection.getTargetIndex(), connection.getSource().getResult(connection.getSourceIndex()));
                nothingDone = false;
            }
            if (!nothingDone) continue;
            this.unresolvedTasks = true;
            return;
        }
        this.unresolvedTasks = false;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.diskInv.writeToNBT(nbt, "LogicDiskInv");
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.diskInv.readFromNBT(nbt, "LogicDiskInv");
    }

    public boolean isUnresolvedTasks() {
        return this.unresolvedTasks;
    }
}

