/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.internal.ILEDProvider;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.utils.BlockMiner;
import buildcraft.core.lib.utils.BlockUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMiningWell
extends TileBuildCraft
implements IHasWork,
IPipeConnection,
IControllable,
ILEDProvider {
    private boolean isDigging = true;
    private BlockMiner miner;
    private int ledState;
    private int ticksSinceAction = 9001;
    private SafeTimeTracker updateTracker = new SafeTimeTracker((long)BuildCraftCore.updateFactor);

    public TileMiningWell() {
        this.setBattery(new RFBattery(20480, 880, 0));
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updateTracker.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
        }
        ++this.ticksSinceAction;
        if (this.mode == IControllable.Mode.Off) {
            if (this.miner != null) {
                this.miner.invalidate();
                this.miner = null;
            }
            this.isDigging = false;
            return;
        }
        if (this.getBattery().getEnergyStored() == 0) {
            return;
        }
        if (this.miner == null) {
            World world = this.field_145850_b;
            int depth = this.field_145848_d - 1;
            while (world.func_147439_a(this.field_145851_c, depth, this.field_145849_e) == BuildCraftFactory.plainPipeBlock) {
                --depth;
            }
            if (depth < 1 || depth < this.field_145848_d - BuildCraftFactory.miningDepth || !BlockUtils.canChangeBlock((World)world, (int)this.field_145851_c, (int)depth, (int)this.field_145849_e)) {
                this.isDigging = false;
                this.getBattery().useEnergy(0, 10, false);
                return;
            }
            if (world.func_147437_c(this.field_145851_c, depth, this.field_145849_e) || world.func_147439_a(this.field_145851_c, depth, this.field_145849_e).isReplaceable((IBlockAccess)world, this.field_145851_c, depth, this.field_145849_e)) {
                this.ticksSinceAction = 0;
                world.func_147449_b(this.field_145851_c, depth, this.field_145849_e, (Block)BuildCraftFactory.plainPipeBlock);
            } else {
                this.miner = new BlockMiner(world, (TileEntity)this, this.field_145851_c, depth, this.field_145849_e);
            }
        }
        if (this.miner != null) {
            this.isDigging = true;
            this.ticksSinceAction = 0;
            int usedEnergy = this.miner.acceptEnergy(this.getBattery().getEnergyStored());
            this.getBattery().useEnergy(usedEnergy, usedEnergy, false);
            if (this.miner.hasFailed()) {
                this.isDigging = false;
            }
            if (this.miner.hasFailed() || this.miner.hasMined()) {
                this.miner = null;
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.miner != null) {
            this.miner.invalidate();
        }
        if (this.field_145850_b != null && this.field_145848_d > 2) {
            BuildCraftFactory.miningWellBlock.removePipes(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        this.ledState = (this.ticksSinceAction < 2 ? 16 : 0) | this.getBattery().getEnergyStored() * 15 / this.getBattery().getMaxEnergyStored();
        stream.writeByte(this.ledState);
    }

    public void readData(ByteBuf stream) {
        super.readData(stream);
        short newLedState = stream.readUnsignedByte();
        if (newLedState != this.ledState) {
            this.ledState = newLedState;
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean hasWork() {
        return this.isDigging;
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }

    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On;
    }

    public int getLEDLevel(int led) {
        if (led == 0) {
            return this.ledState & 0xF;
        }
        return this.ledState >> 4 > 0 ? 15 : 0;
    }
}

