/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.tileentity.TileEntityCompressedIronBlock;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;

public class TileEntityVortexTube
extends TileEntityPneumaticBase
implements IHeatExchanger {
    private final IHeatExchangerLogic coldHeatExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();
    private final IHeatExchangerLogic hotHeatExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();
    private final IHeatExchangerLogic connectingExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();
    private int visualizationTimer = 60;
    @DescSynced
    private boolean visualize;
    @DescSynced
    private int roll;
    @DescSynced
    private int coldHeatLevel = 10;
    @DescSynced
    private int hotHeatLevel = 10;

    public TileEntityVortexTube() {
        super(20.0f, 25.0f, 2000);
        this.coldHeatExchanger.setThermalResistance(0.01);
        this.hotHeatExchanger.setThermalResistance(0.01);
        this.connectingExchanger.setThermalResistance(100.0);
        this.connectingExchanger.addConnectedExchanger(this.coldHeatExchanger);
        this.connectingExchanger.addConnectedExchanger(this.hotHeatExchanger);
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN || side == this.getRotation().getOpposite()) {
            return this.hotHeatExchanger;
        }
        if (side == this.getRotation()) {
            return this.coldHeatExchanger;
        }
        return null;
    }

    @Override
    protected ForgeDirection[] getConnectedHeatExchangerSides() {
        return new ForgeDirection[]{this.getRotation().getOpposite()};
    }

    @Override
    protected void initializeIfHeatExchanger() {
        super.initializeIfHeatExchanger();
        this.initializeHeatExchanger(this.coldHeatExchanger, this.getRotation());
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        return this.getTubeDirection() == side;
    }

    public ForgeDirection getTubeDirection() {
        ForgeDirection d;
        switch (this.getRotation()) {
            case DOWN: 
            case NORTH: 
            case UP: {
                d = ForgeDirection.WEST;
                break;
            }
            case SOUTH: {
                d = ForgeDirection.EAST;
                break;
            }
            case WEST: {
                d = ForgeDirection.SOUTH;
                break;
            }
            case EAST: {
                d = ForgeDirection.NORTH;
                break;
            }
            default: {
                d = ForgeDirection.SOUTH;
            }
        }
        for (int i = 0; i < this.roll; ++i) {
            d = d.getRotation(this.getRotation());
        }
        return d;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound coldHeatTag = new NBTTagCompound();
        this.coldHeatExchanger.writeToNBT(coldHeatTag);
        tag.func_74782_a("coldHeat", (NBTBase)coldHeatTag);
        tag.func_74774_a("roll", (byte)this.roll);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.coldHeatExchanger.readFromNBT(tag.func_74775_l("coldHeat"));
        this.roll = tag.func_74771_c("roll");
    }

    public int getColdHeatLevel() {
        return this.coldHeatLevel;
    }

    public int getHotHeatLevel() {
        return this.hotHeatLevel;
    }

    public boolean shouldVisualize() {
        return this.visualize;
    }

    public int getRoll() {
        return this.roll;
    }

    public void rotateRoll(int rotation) {
        this.roll += rotation;
        if (this.roll > 3) {
            this.roll = 0;
        }
        if (this.roll < 0) {
            this.roll = 3;
        }
        this.updateNeighbours();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.connectingExchanger.update();
            this.coldHeatExchanger.update();
            int usedAir = (int)(this.getPressure(ForgeDirection.UNKNOWN) * 10.0f);
            if (usedAir > 0) {
                this.addAir(-usedAir, ForgeDirection.UNKNOWN);
                double generatedHeat = (double)usedAir / 10.0;
                this.coldHeatExchanger.addHeat(-generatedHeat);
                this.hotHeatExchanger.addHeat(generatedHeat);
            }
            boolean bl = this.visualize = this.visualizationTimer > 0;
            if (this.visualize) {
                --this.visualizationTimer;
            }
            this.coldHeatLevel = TileEntityCompressedIronBlock.getHeatLevelForTemperature(this.coldHeatExchanger.getTemperature());
            this.hotHeatLevel = TileEntityCompressedIronBlock.getHeatLevelForTemperature(this.hotHeatExchanger.getTemperature());
        }
    }

    @Override
    public void onBlockRotated() {
        this.visualizationTimer = 60;
    }
}

