/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import pneumaticCraft.api.recipe.IPressureChamberRecipe;
import pneumaticCraft.api.recipe.PressureChamberRecipe;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.common.AchievementHandler;
import pneumaticCraft.common.DamageSourcePneumaticCraft;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.fluid.Fluids;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.recipes.PneumaticRecipeRegistry;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.tileentity.TileEntityPressureChamberWall;

public class TileEntityPressureChamberValve
extends TileEntityPneumaticBase
implements IInventory,
IMinWorkingPressure {
    @DescSynced
    public int multiBlockX;
    @DescSynced
    public int multiBlockY;
    @DescSynced
    public int multiBlockZ;
    @DescSynced
    public int multiBlockSize;
    public List<TileEntityPressureChamberValve> accessoryValves;
    private final List<int[]> nbtValveList;
    private boolean readNBT = false;
    @GuiSynced
    public boolean isValidRecipeInChamber;
    @GuiSynced
    public boolean isSufficientPressureInChamber;
    @GuiSynced
    public boolean areEntitiesDoneMoving;
    @GuiSynced
    public float recipePressure;
    private final Item etchingAcid = Fluids.getBucket(Fluids.etchingAcid);
    private ItemStack[] inventory = new ItemStack[4];
    public static final int UPGRADE_SLOT_1 = 0;
    public static final int UPGRADE_SLOT_4 = 3;
    private final Random rand = new Random();

    public TileEntityPressureChamberValve() {
        super(5.0f, 7.0f, 1000);
        this.accessoryValves = new ArrayList<TileEntityPressureChamberValve>();
        this.nbtValveList = new ArrayList<int[]>();
        this.setUpgradeSlots(0, 1, 2, 3);
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        switch (ForgeDirection.getOrientation((int)this.func_145832_p())) {
            case UP: 
            case DOWN: {
                return side == ForgeDirection.UP || side == ForgeDirection.DOWN;
            }
            case NORTH: 
            case SOUTH: {
                return side == ForgeDirection.NORTH || side == ForgeDirection.SOUTH;
            }
            case EAST: 
            case WEST: {
                return side == ForgeDirection.EAST || side == ForgeDirection.WEST;
            }
        }
        return false;
    }

    @Override
    public List<Pair<ForgeDirection, IAirHandler>> getConnectedPneumatics() {
        List<Pair<ForgeDirection, IAirHandler>> teList = super.getConnectedPneumatics();
        if (this.accessoryValves != null) {
            for (TileEntityPressureChamberValve valve : this.accessoryValves) {
                if (valve == this) continue;
                teList.add((Pair<ForgeDirection, IAirHandler>)new ImmutablePair((Object)ForgeDirection.UNKNOWN, (Object)valve.getAirHandler()));
            }
        }
        return teList;
    }

    @Override
    protected int getVolumeFromUpgrades(int[] upgradeSlots) {
        return super.getVolumeFromUpgrades(this.getUpgradeSlots()) + (this.multiBlockSize > 0 ? (int)Math.pow(this.multiBlockSize - 2, 3.0) * 16000 : 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_145845_h() {
        boolean bl;
        void var3_16;
        if (this.readNBT) {
            this.readNBT = false;
            this.accessoryValves.clear();
            for (int[] valve : this.nbtValveList) {
                TileEntity tileEntity = this.field_145850_b.func_147438_o(valve[0], valve[1], valve[2]);
                if (!(tileEntity instanceof TileEntityPressureChamberValve)) continue;
                this.accessoryValves.add((TileEntityPressureChamberValve)tileEntity);
            }
            if (this.accessoryValves.isEmpty()) {
                this.invalidateMultiBlock();
                TileEntityPressureChamberValve.checkIfProperlyFormed(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            void var3_7;
            boolean[] connected = new boolean[]{true, true, true, true, true, true};
            switch (ForgeDirection.getOrientation((int)this.func_145832_p())) {
                case UP: 
                case DOWN: {
                    connected[ForgeDirection.UP.ordinal()] = false;
                    connected[ForgeDirection.DOWN.ordinal()] = false;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    connected[ForgeDirection.NORTH.ordinal()] = false;
                    connected[ForgeDirection.SOUTH.ordinal()] = false;
                    break;
                }
                case EAST: 
                case WEST: {
                    connected[ForgeDirection.EAST.ordinal()] = false;
                    connected[ForgeDirection.WEST.ordinal()] = false;
                }
            }
            List<Pair<ForgeDirection, IAirHandler>> teList = super.getConnectedPneumatics();
            Iterator iterator = teList.iterator();
            while (iterator.hasNext()) {
                Pair entry = (Pair)iterator.next();
                connected[((ForgeDirection)entry.getKey()).ordinal()] = true;
            }
            Object var3_5 = null;
            for (TileEntityPressureChamberValve valve : this.accessoryValves) {
                if (valve.multiBlockSize <= 0) continue;
                TileEntityPressureChamberValve tileEntityPressureChamberValve = valve;
                break;
            }
            if (var3_7 != null) {
                switch (ForgeDirection.getOrientation((int)this.func_145832_p())) {
                    case UP: 
                    case DOWN: {
                        if (var3_7.multiBlockY == this.field_145848_d) {
                            connected[ForgeDirection.UP.ordinal()] = true;
                            break;
                        }
                        connected[ForgeDirection.DOWN.ordinal()] = true;
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        if (var3_7.multiBlockZ == this.field_145849_e) {
                            connected[ForgeDirection.SOUTH.ordinal()] = true;
                            break;
                        }
                        connected[ForgeDirection.NORTH.ordinal()] = true;
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        if (var3_7.multiBlockX == this.field_145851_c) {
                            connected[ForgeDirection.EAST.ordinal()] = true;
                            break;
                        }
                        connected[ForgeDirection.WEST.ordinal()] = true;
                    }
                }
            }
            for (int i = 0; i < 6; ++i) {
                if (connected[i]) continue;
                this.airLeak(ForgeDirection.getOrientation((int)i));
            }
        }
        super.func_145845_h();
        if (this.multiBlockSize != 0 && !this.field_145850_b.field_72995_K) {
            ItemStack[] stacksInChamber = this.getStacksInChamber();
            this.isValidRecipeInChamber = false;
            this.isSufficientPressureInChamber = false;
            this.recipePressure = Float.MAX_VALUE;
            for (PressureChamberRecipe pressureChamberRecipe : PressureChamberRecipe.chamberRecipes) {
                boolean isSufficientPressureInChamberFlag;
                boolean isValidRecipeInChamberFlag = this.canBeCompressed(pressureChamberRecipe, stacksInChamber);
                boolean bl2 = isSufficientPressureInChamberFlag = pressureChamberRecipe.pressure <= this.getPressure(ForgeDirection.UNKNOWN) && pressureChamberRecipe.pressure > 0.0f || pressureChamberRecipe.pressure >= this.getPressure(ForgeDirection.UNKNOWN) && pressureChamberRecipe.pressure < 0.0f;
                if (isValidRecipeInChamberFlag) {
                    this.isValidRecipeInChamber = true;
                    if (Math.abs(pressureChamberRecipe.pressure) < Math.abs(this.recipePressure)) {
                        this.recipePressure = pressureChamberRecipe.pressure;
                    }
                }
                if (isSufficientPressureInChamberFlag) {
                    this.isSufficientPressureInChamber = true;
                }
                if (!isValidRecipeInChamberFlag || !isSufficientPressureInChamberFlag || !this.areEntitiesDoneMoving) continue;
                double[] outputPosition = this.clearStacksInChamber(pressureChamberRecipe.input);
                this.giveOutput(pressureChamberRecipe.output, outputPosition);
            }
            for (IPressureChamberRecipe iPressureChamberRecipe : PressureChamberRecipe.specialRecipes) {
                boolean isSufficientPressureInChamberFlag;
                Object[] removedStacks = iPressureChamberRecipe.isValidRecipe(stacksInChamber);
                boolean isValidRecipeInChamberFlag = removedStacks != null;
                boolean bl3 = isSufficientPressureInChamberFlag = iPressureChamberRecipe.getCraftingPressure() <= this.getPressure(ForgeDirection.UNKNOWN) && iPressureChamberRecipe.getCraftingPressure() > 0.0f || iPressureChamberRecipe.getCraftingPressure() >= this.getPressure(ForgeDirection.UNKNOWN) && iPressureChamberRecipe.getCraftingPressure() < 0.0f;
                if (isValidRecipeInChamberFlag) {
                    this.isValidRecipeInChamber = true;
                    if (Math.abs(iPressureChamberRecipe.getCraftingPressure()) < Math.abs(this.recipePressure)) {
                        this.recipePressure = iPressureChamberRecipe.getCraftingPressure();
                    }
                }
                if (isSufficientPressureInChamberFlag) {
                    this.isSufficientPressureInChamber = true;
                }
                if (!isValidRecipeInChamberFlag || !isSufficientPressureInChamberFlag || !this.areEntitiesDoneMoving) continue;
                double[] outputPosition = this.clearStacksInChamber(removedStacks);
                this.giveOutput(iPressureChamberRecipe.craftRecipe(stacksInChamber, (ItemStack[])removedStacks), outputPosition);
            }
            if (this.getPressure(ForgeDirection.UNKNOWN) > 1.0f) {
                AxisAlignedBB bbBox = AxisAlignedBB.func_72330_a((double)(this.multiBlockX + 1), (double)(this.multiBlockY + 1), (double)(this.multiBlockZ + 1), (double)(this.multiBlockX + this.multiBlockSize - 1), (double)(this.multiBlockY + this.multiBlockSize - 1), (double)(this.multiBlockZ + this.multiBlockSize - 1));
                List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, bbBox);
                for (EntityItem entity : list) {
                    EntityVillager villager;
                    if (entity instanceof EntityVillager && (villager = (EntityVillager)entity).func_70946_n() != Config.villagerMechanicID) {
                        villager.func_70938_b(Config.villagerMechanicID);
                        NBTTagCompound tag = new NBTTagCompound();
                        villager.func_70014_b(tag);
                        if (tag.func_74764_b("Offers")) {
                            tag.func_82580_o("Offers");
                            villager.func_70037_a(tag);
                        }
                    }
                    entity.func_70097_a((DamageSource)DamageSourcePneumaticCraft.pressure, (float)((int)((double)this.getPressure(ForgeDirection.UNKNOWN) * 2.0)));
                }
            }
        }
        AxisAlignedBB bbBox = AxisAlignedBB.func_72330_a((double)this.multiBlockX, (double)this.multiBlockY, (double)this.multiBlockZ, (double)(this.multiBlockX + this.multiBlockSize), (double)(this.multiBlockY + this.multiBlockSize), (double)(this.multiBlockZ + this.multiBlockSize));
        List entities = this.field_145850_b.func_72872_a(EntityItem.class, bbBox);
        this.areEntitiesDoneMoving = true;
        boolean bl4 = false;
        while (var3_16 < entities.size() - 1) {
            EntityItem entity;
            EntityItem lastEntity = (EntityItem)entities.get((int)var3_16);
            entity = (EntityItem)entities.get((int)(var3_16 + true));
            double d0 = 8.0;
            double d1 = (lastEntity.field_70165_t - entity.field_70165_t) / d0;
            double d3 = (lastEntity.field_70161_v - entity.field_70161_v) / d0;
            double d4 = Math.sqrt(d1 * d1 + d3 * d3);
            double d5 = 1.0 - d4;
            if (d5 > 0.0 && d4 > 0.02) {
                d5 *= d5;
                entity.field_70159_w += d1 / d4 * d5 * 0.01;
                entity.field_70179_y += d3 / d4 * d5 * 0.01;
                lastEntity.field_70159_w -= d1 / d4 * d5 * 0.01;
                lastEntity.field_70179_y -= d3 / d4 * d5 * 0.01;
                this.areEntitiesDoneMoving = false;
            }
            ++var3_16;
        }
        boolean bl5 = bl = this.getUpgrades(2, this.getUpgradeSlots()) > 0;
        if (bl && !this.field_145850_b.field_72995_K) {
            for (EntityItem entity : entities) {
                --entity.field_70292_b;
            }
        }
        if (this.field_145850_b.field_72995_K && (double)this.getPressure(ForgeDirection.UNKNOWN) > 0.2) {
            int particles = (int)Math.pow(this.multiBlockSize - 2, 3.0);
            for (int i = 0; i < particles; ++i) {
                if (this.rand.nextInt(Math.max(1, 8 - (int)((double)this.getPressure(ForgeDirection.UNKNOWN) * 2.0))) != 0) continue;
                double posX = (double)this.multiBlockX + 1.0 + this.rand.nextDouble() * ((double)this.multiBlockSize - 2.0);
                double posY = (double)this.multiBlockY + 1.0 + this.rand.nextDouble() * ((double)this.multiBlockSize - 2.0);
                double posZ = (double)this.multiBlockZ + 1.0 + this.rand.nextDouble() * ((double)this.multiBlockSize - 2.0);
                this.field_145850_b.func_72869_a("explode", posX, posY, posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean canBeCompressed(PressureChamberRecipe recipe, ItemStack[] items) {
        for (Object in : recipe.input) {
            if (in == null) continue;
            int amount = 0;
            for (ItemStack item : items) {
                if (item == null || !PneumaticRecipeRegistry.isItemEqual(in, item)) continue;
                amount += item.field_77994_a;
            }
            if (amount >= PneumaticRecipeRegistry.getItemAmount(in)) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] getStacksInChamber() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        AxisAlignedBB bbBox = AxisAlignedBB.func_72330_a((double)this.multiBlockX, (double)this.multiBlockY, (double)this.multiBlockZ, (double)(this.multiBlockX + this.multiBlockSize), (double)(this.multiBlockY + this.multiBlockSize), (double)(this.multiBlockZ + this.multiBlockSize));
        List entities = this.field_145850_b.func_72872_a(EntityItem.class, bbBox);
        for (EntityItem entity : entities) {
            if (entity.field_70128_L) continue;
            stackList.add(entity.func_92059_d());
        }
        return stackList.toArray(new ItemStack[stackList.size()]);
    }

    public double[] clearStacksInChamber(Object ... stacksToClear) {
        int[] stackSizes = new int[stacksToClear.length];
        for (int i = 0; i < stacksToClear.length; ++i) {
            stackSizes[i] = PneumaticRecipeRegistry.getItemAmount(stacksToClear[i]);
        }
        double[] outputPosition = new double[]{(double)this.multiBlockX + (double)this.multiBlockSize / 2.0, (double)this.multiBlockY + 1.2, (double)this.multiBlockZ + (double)this.multiBlockSize / 2.0};
        AxisAlignedBB bbBox = AxisAlignedBB.func_72330_a((double)this.multiBlockX, (double)this.multiBlockY, (double)this.multiBlockZ, (double)(this.multiBlockX + this.multiBlockSize), (double)(this.multiBlockY + this.multiBlockSize), (double)(this.multiBlockZ + this.multiBlockSize));
        List entities = this.field_145850_b.func_72872_a(EntityItem.class, bbBox);
        block1: for (EntityItem entity : entities) {
            if (entity.field_70128_L) continue;
            ItemStack entityStack = entity.func_92059_d();
            for (int l = 0; l < stacksToClear.length; ++l) {
                if (!PneumaticRecipeRegistry.isItemEqual(stacksToClear[l], entityStack) || stackSizes[l] <= 0) continue;
                outputPosition[0] = entity.field_70165_t;
                outputPosition[1] = entity.field_70163_u;
                outputPosition[2] = entity.field_70161_v;
                int removedItems = Math.min(stackSizes[l], entityStack.field_77994_a);
                int n = l;
                stackSizes[n] = stackSizes[n] - removedItems;
                entityStack.field_77994_a -= removedItems;
                if (entityStack.field_77994_a > 0) continue block1;
                entity.func_70106_y();
                continue block1;
            }
        }
        return outputPosition;
    }

    private void giveOutput(ItemStack[] output, double[] outputPosition) {
        for (ItemStack iStack : output) {
            if (iStack.func_77973_b() == this.etchingAcid) {
                for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 32), (double)(this.field_145848_d - 32), (double)(this.field_145849_e - 32), (double)(this.field_145851_c + 32), (double)(this.field_145848_d + 32), (double)(this.field_145849_e + 32)))) {
                    AchievementHandler.giveAchievement(player, new ItemStack(this.etchingAcid));
                }
            }
            EntityItem item = new EntityItem(this.field_145850_b, outputPosition[0], outputPosition[1], outputPosition[2], iStack.func_77946_l());
            this.field_145850_b.func_72838_d((Entity)item);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.multiBlockX = tag.func_74762_e("multiBlockX");
        this.multiBlockY = tag.func_74762_e("multiBlockY");
        this.multiBlockZ = tag.func_74762_e("multiBlockZ");
        this.multiBlockSize = tag.func_74762_e("multiBlockSize");
        this.isSufficientPressureInChamber = tag.func_74767_n("sufPressure");
        this.isValidRecipeInChamber = tag.func_74767_n("validRecipe");
        this.recipePressure = tag.func_74760_g("recipePressure");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        NBTTagList tagList2 = tag.func_150295_c("Valves", 10);
        this.nbtValveList.clear();
        for (int i = 0; i < tagList2.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList2.func_150305_b(i);
            if (tagCompound == null) continue;
            this.nbtValveList.add(new int[]{tagCompound.func_74762_e("xCoord"), tagCompound.func_74762_e("yCoord"), tagCompound.func_74762_e("zCoord")});
        }
        this.readNBT = true;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("multiBlockX", this.multiBlockX);
        tag.func_74768_a("multiBlockY", this.multiBlockY);
        tag.func_74768_a("multiBlockZ", this.multiBlockZ);
        tag.func_74768_a("multiBlockSize", this.multiBlockSize);
        tag.func_74757_a("sufPressure", this.isSufficientPressureInChamber);
        tag.func_74757_a("validRecipe", this.isValidRecipeInChamber);
        tag.func_74776_a("recipePressure", this.recipePressure);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
        NBTTagList tagList2 = new NBTTagList();
        for (TileEntityPressureChamberValve valve : this.accessoryValves) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("xCoord", valve.field_145851_c);
            tagCompound.func_74768_a("yCoord", valve.field_145848_d);
            tagCompound.func_74768_a("zCoord", valve.field_145849_e);
            tagList2.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Valves", (NBTBase)tagList2);
    }

    public void onMultiBlockBreak() {
        this.dropInventory(this.field_145850_b, (double)this.multiBlockX + (double)this.multiBlockSize / 2.0, (double)this.multiBlockY + (double)this.multiBlockSize / 2.0, (double)this.multiBlockZ + (double)this.multiBlockSize / 2.0);
        this.invalidateMultiBlock();
    }

    private void dropInventory(World world, double x, double y, double z) {
        TileEntityPressureChamberValve inventory = this;
        Random rand = new Random();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            float dX = rand.nextFloat() * 0.8f - 0.4f;
            float dY = rand.nextFloat() * 0.8f - 0.4f;
            float dZ = rand.nextFloat() * 0.8f - 0.4f;
            EntityItem entityItem = new EntityItem(world, x + (double)dX, y + (double)dY, z + (double)dZ, new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, itemStack.func_77960_j()));
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
        }
        this.inventory = new ItemStack[4];
    }

    private void invalidateMultiBlock() {
        for (int x = 0; x < this.multiBlockSize; ++x) {
            for (int y = 0; y < this.multiBlockSize; ++y) {
                for (int z = 0; z < this.multiBlockSize; ++z) {
                    TileEntity te = this.field_145850_b.func_147438_o(x + this.multiBlockX, y + this.multiBlockY, z + this.multiBlockZ);
                    if (!(te instanceof TileEntityPressureChamberWall)) continue;
                    TileEntityPressureChamberWall teWall = (TileEntityPressureChamberWall)te;
                    teWall.setCore(null);
                }
            }
        }
        if (this.accessoryValves != null) {
            for (TileEntityPressureChamberValve valve : this.accessoryValves) {
                valve.setMultiBlockCoords(0, 0, 0, 0);
                if (valve == this) continue;
                valve.accessoryValves.clear();
                valve.sendDescriptionPacket();
            }
            this.accessoryValves.clear();
        }
        this.sendDescriptionPacket();
    }

    public void setMultiBlockCoords(int size, int baseX, int baseY, int baseZ) {
        this.multiBlockSize = size;
        this.multiBlockX = baseX;
        this.multiBlockY = baseY;
        this.multiBlockZ = baseZ;
    }

    public static boolean checkIfProperlyFormed(World world, int x, int y, int z) {
        for (int i = 3; i < 6; ++i) {
            if (!TileEntityPressureChamberValve.checkForShiftedCubeOfSize(i, world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForShiftedCubeOfSize(int size, World world, int baseX, int baseY, int baseZ) {
        for (int wallX = 0; wallX < size; ++wallX) {
            for (int wallY = 0; wallY < size; ++wallY) {
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX, baseY - wallY, baseZ - wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX, baseY + wallY, baseZ + wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY, baseZ - wallY)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY, baseZ + wallY)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - size + 1, baseY - wallY, baseZ - wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - size + 1, baseY + wallY, baseZ + wallX)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ - size + 1)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ - size + 1)) {
                    return true;
                }
                if (TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX - wallX, baseY - size + 1, baseZ - wallY)) {
                    return true;
                }
                if (!TileEntityPressureChamberValve.checkForCubeOfSize(size, world, baseX + wallX, baseY - size + 1, baseZ + wallY)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkForCubeOfSize(int size, World world, int baseX, int baseY, int baseZ) {
        int z;
        boolean validValveFound = false;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z2 = 0; z2 < size; ++z2) {
                    if (x != 0 && x != size - 1 && y != 0 && y != size - 1 && z2 != 0 && z2 != size - 1) continue;
                    if (world.func_147439_a(x + baseX, y + baseY, z2 + baseZ) != Blockss.pressureChamberWall && world.func_147439_a(x + baseX, y + baseY, z2 + baseZ) != Blockss.pressureChamberValve && world.func_147439_a(x + baseX, y + baseY, z2 + baseZ) != Blockss.pressureChamberInterface) {
                        return false;
                    }
                    if (world.func_147439_a(x + baseX, y + baseY, z2 + baseZ) == Blockss.pressureChamberValve) {
                        boolean xMid = x != 0 && x != size - 1;
                        boolean yMid = y != 0 && y != size - 1;
                        boolean zMid = z2 != 0 && z2 != size - 1;
                        ForgeDirection facing = ForgeDirection.getOrientation((int)world.func_72805_g(x + baseX, y + baseY, z2 + baseZ));
                        if (xMid && yMid && (facing == ForgeDirection.NORTH || facing == ForgeDirection.SOUTH) || xMid && zMid && (facing == ForgeDirection.UP || facing == ForgeDirection.DOWN) || yMid && zMid && (facing == ForgeDirection.EAST || facing == ForgeDirection.WEST)) {
                            validValveFound = true;
                            continue;
                        }
                        return false;
                    }
                    TileEntity te = world.func_147438_o(x + baseX, y + baseY, z2 + baseZ);
                    if (!(te instanceof TileEntityPressureChamberWall) || ((TileEntityPressureChamberWall)te).getCore() == null) continue;
                    return false;
                }
            }
        }
        if (!validValveFound) {
            return false;
        }
        TileEntityPressureChamberValve teValve = null;
        ArrayList<TileEntityPressureChamberValve> valveList = new ArrayList<TileEntityPressureChamberValve>();
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (z = 0; z < size; ++z) {
                    TileEntity te = world.func_147438_o(x + baseX, y + baseY, z + baseZ);
                    if (!(te instanceof TileEntityPressureChamberValve)) continue;
                    boolean xMid = x != 0 && x != size - 1;
                    boolean yMid = y != 0 && y != size - 1;
                    boolean zMid = z != 0 && z != size - 1;
                    ForgeDirection facing = ForgeDirection.getOrientation((int)world.func_72805_g(x + baseX, y + baseY, z + baseZ));
                    if ((!xMid || !yMid || facing != ForgeDirection.NORTH && facing != ForgeDirection.SOUTH) && (!xMid || !zMid || facing != ForgeDirection.UP && facing != ForgeDirection.DOWN) && (!yMid || !zMid || facing != ForgeDirection.EAST && facing != ForgeDirection.WEST)) continue;
                    teValve = (TileEntityPressureChamberValve)te;
                    valveList.add(teValve);
                }
            }
        }
        if (teValve == null) {
            return false;
        }
        for (TileEntityPressureChamberValve valve : valveList) {
            valve.accessoryValves = new ArrayList<TileEntityPressureChamberValve>(valveList);
            valve.sendDescriptionPacket();
        }
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (z = 0; z < size; ++z) {
                    TileEntity te = world.func_147438_o(x + baseX, y + baseY, z + baseZ);
                    if (!(te instanceof TileEntityPressureChamberWall)) continue;
                    TileEntityPressureChamberWall teWall = (TileEntityPressureChamberWall)te;
                    teWall.setCore(teValve);
                }
            }
        }
        teValve.setMultiBlockCoords(size, baseX, baseY, baseZ);
        teValve.sendDescriptionPacket();
        return true;
    }

    public boolean isCoordWithinChamber(World world, int x, int y, int z) {
        return x > this.multiBlockX && x < this.multiBlockX + this.multiBlockSize - 1 && y > this.multiBlockY && y < this.multiBlockY + this.multiBlockSize - 1 && z > this.multiBlockZ && z < this.multiBlockZ + this.multiBlockSize - 1;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return Blockss.pressureChamberValve.func_149739_a();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() == Itemss.machineUpgrade;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public float getMinWorkingPressure() {
        return this.isValidRecipeInChamber ? this.recipePressure : -1.0f;
    }
}

