/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.tuple.Pair;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.common.ai.ChunkPositionSorter;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityGasLift
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControlled,
IFluidHandler,
IInventory {
    @GuiSynced
    private final FluidTank tank = new FluidTank(16000);
    private final ItemStack[] inventory = new ItemStack[5];
    @GuiSynced
    public int currentDepth;
    @GuiSynced
    public int redstoneMode;
    @GuiSynced
    public int status;
    @GuiSynced
    public int mode;
    @DescSynced
    public boolean[] sidesConnected = new boolean[6];
    private int workTimer;
    private int ticker;
    private List<ChunkPosition> pumpingLake;
    private static final int MAX_PUMP_RANGE = 15;

    public TileEntityGasLift() {
        super(5.0f, 7.0f, 3000);
        this.setUpgradeSlots(0, 1, 2, 3);
    }

    @Override
    public boolean isConnectedTo(ForgeDirection d) {
        return d != ForgeDirection.DOWN;
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        List<Pair<ForgeDirection, IAirHandler>> connections = this.getConnectedPneumatics();
        for (int i = 0; i < this.sidesConnected.length; ++i) {
            this.sidesConnected[i] = false;
        }
        for (Pair<ForgeDirection, IAirHandler> entry : connections) {
            this.sidesConnected[((ForgeDirection)entry.getKey()).ordinal()] = true;
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            int curCheckingPipe;
            ++this.ticker;
            if (this.currentDepth > 0 && (curCheckingPipe = this.ticker % this.currentDepth) > 0 && !this.isPipe(this.field_145851_c, this.field_145848_d - curCheckingPipe, this.field_145849_e)) {
                this.currentDepth = curCheckingPipe - 1;
            }
            if (this.ticker % 400 == 0) {
                this.pumpingLake = null;
            }
            if (this.redstoneAllows() && this.getPressure(ForgeDirection.UNKNOWN) >= this.getMinWorkingPressure()) {
                this.workTimer = (int)((float)this.workTimer + this.getSpeedMultiplierFromUpgrades());
                while (this.workTimer > 20) {
                    this.workTimer -= 20;
                    this.status = 0;
                    if (this.mode == 2) {
                        if (this.currentDepth <= 0) continue;
                        this.status = 3;
                        if (this.isPipe(this.field_145851_c, this.field_145848_d - this.currentDepth, this.field_145849_e)) {
                            if (IOHelper.insert(this, new ItemStack(Blockss.pressureTube), 0, false) == null) {
                                this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d - this.currentDepth, this.field_145849_e, false);
                                this.addAir(-100, ForgeDirection.UNKNOWN);
                                --this.currentDepth;
                                continue;
                            }
                            this.status = 0;
                            continue;
                        }
                        --this.currentDepth;
                        continue;
                    }
                    if (this.suckLiquid()) continue;
                    if (this.field_145848_d - this.currentDepth >= 0 && !this.isUnbreakable(this.field_145851_c, this.field_145848_d - this.currentDepth - 1, this.field_145849_e)) {
                        this.status = 2;
                        ++this.currentDepth;
                        if (this.isPipe(this.field_145851_c, this.field_145848_d - this.currentDepth, this.field_145849_e)) continue;
                        if (this.inventory[4] != null) {
                            this.func_70298_a(4, 1);
                            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d - this.currentDepth, this.field_145849_e, false);
                            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d - this.currentDepth, this.field_145849_e, Blockss.pressureTube);
                            this.addAir(-100, ForgeDirection.UNKNOWN);
                            continue;
                        }
                        this.status = 0;
                        --this.currentDepth;
                    }
                    break;
                }
            } else {
                this.status = 0;
            }
            if (this.getUpgrades(1) > 0) {
                this.autoExportLiquid();
            }
        }
    }

    private boolean isPipe(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == Blockss.pressureTube;
    }

    private boolean isUnbreakable(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z).func_149712_f(this.field_145850_b, x, y, z) < 0.0f;
    }

    public boolean suckLiquid() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - this.currentDepth - 1, this.field_145849_e);
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid != null) {
            if (this.fill(ForgeDirection.UNKNOWN, new FluidStack(fluid, 1000), false) == 1000) {
                if (this.pumpingLake == null) {
                    this.pumpingLake = new ArrayList<ChunkPosition>();
                    Stack<ChunkPosition> pendingPositions = new Stack<ChunkPosition>();
                    ChunkPosition thisPos = new ChunkPosition(this.field_145851_c, this.field_145848_d - this.currentDepth - 1, this.field_145849_e);
                    pendingPositions.add(thisPos);
                    this.pumpingLake.add(thisPos);
                    while (!pendingPositions.empty()) {
                        ChunkPosition checkingPos = (ChunkPosition)pendingPositions.pop();
                        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                            ChunkPosition newPos;
                            if (d == ForgeDirection.DOWN || !(PneumaticCraftUtils.distBetween(newPos = new ChunkPosition(checkingPos.field_151329_a + d.offsetX, checkingPos.field_151327_b + d.offsetY, checkingPos.field_151328_c + d.offsetZ), (double)this.field_145851_c + 0.5, (double)(this.field_145848_d - this.currentDepth - 1), (double)this.field_145849_e + 0.5) <= 15.0) || this.field_145850_b.func_147439_a(newPos.field_151329_a, newPos.field_151327_b, newPos.field_151328_c) != block || this.pumpingLake.contains(newPos)) continue;
                            pendingPositions.add(newPos);
                            this.pumpingLake.add(newPos);
                        }
                    }
                    Collections.sort(this.pumpingLake, new ChunkPositionSorter((double)this.field_145851_c + 0.5, this.field_145848_d - this.currentDepth - 1, (double)this.field_145849_e + 0.5));
                    Collections.reverse(this.pumpingLake);
                }
                ChunkPosition curPos = null;
                boolean foundSource = false;
                while (this.pumpingLake.size() > 0) {
                    curPos = this.pumpingLake.get(0);
                    if (this.field_145850_b.func_147439_a(curPos.field_151329_a, curPos.field_151327_b, curPos.field_151328_c) == block && this.field_145850_b.func_72805_g(curPos.field_151329_a, curPos.field_151327_b, curPos.field_151328_c) == 0) {
                        foundSource = true;
                        break;
                    }
                    this.pumpingLake.remove(0);
                }
                if (this.pumpingLake.size() == 0) {
                    this.pumpingLake = null;
                } else if (foundSource) {
                    this.field_145850_b.func_147468_f(curPos.field_151329_a, curPos.field_151327_b, curPos.field_151328_c);
                    this.fill(ForgeDirection.UNKNOWN, new FluidStack(fluid, 1000), true);
                    this.addAir(-100, ForgeDirection.UNKNOWN);
                    this.status = 1;
                }
            }
            return true;
        }
        this.pumpingLake = null;
        return false;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        } else if (buttonID > 0 && buttonID < 4) {
            this.mode = buttonID - 1;
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public float getMinWorkingPressure() {
        return 0.5f + (float)this.currentDepth * 0.05f;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        TileEntityGasLift.writeInventoryToNBT(tag, this.inventory);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74774_a("mode", (byte)this.mode);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        tag.func_74768_a("currentDepth", this.currentDepth);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        TileEntityGasLift.readInventoryFromNBT(tag, this.inventory);
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.mode = tag.func_74771_c("mode");
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.currentDepth = tag.func_74762_e("currentDepth");
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(resource) ? this.drain(ForgeDirection.UNKNOWN, resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.mode == 0 ? this.tank.drain(maxDrain, doDrain) : this.tank.drain(Math.min(this.tank.getFluidAmount() - 1000, maxDrain), doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    @SideOnly(value=Side.CLIENT)
    public FluidTank getTank() {
        return this.tank;
    }

    public String func_145825_b() {
        return Blockss.gasLift.func_149739_a();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_94041_b(int par1, ItemStack stack) {
        return stack != null && (par1 < 4 && stack.func_77973_b() == Itemss.machineUpgrade || par1 == 4 && stack.func_77969_a(new ItemStack(Blockss.pressureTube)));
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.isGuiUseableByPlayer(p_70300_1_);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

