/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.tileentity.TileEntityBase;

public class TileEntityElevatorCaller
extends TileEntityBase {
    private ElevatorButton[] floors = new ElevatorButton[0];
    public int thisFloor;
    private boolean emittingRedstone;
    private boolean shouldUpdateNeighbors;
    @DescSynced
    public ItemStack camoStack;
    public Block camoBlock;

    public void setEmittingRedstone(boolean emittingRedstone) {
        if (emittingRedstone != this.emittingRedstone) {
            this.emittingRedstone = emittingRedstone;
            this.shouldUpdateNeighbors = true;
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.shouldUpdateNeighbors) {
            this.updateNeighbours();
            this.shouldUpdateNeighbors = false;
        }
    }

    public boolean getEmittingRedstone() {
        return this.emittingRedstone;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.emittingRedstone = tag.func_74767_n("emittingRedstone");
        this.thisFloor = tag.func_74762_e("thisFloor");
        this.camoStack = tag.func_74764_b("camoStack") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("camoStack")) : null;
        this.shouldUpdateNeighbors = tag.func_74767_n("shouldUpdateNeighbors");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("emittingRedstone", this.emittingRedstone);
        tag.func_74768_a("thisFloor", this.thisFloor);
        if (this.camoStack != null) {
            NBTTagCompound camoTag = new NBTTagCompound();
            this.camoStack.func_77955_b(camoTag);
            tag.func_74782_a("camoStack", (NBTBase)camoTag);
        }
        tag.func_74757_a("shouldUpdateNeighbors", this.shouldUpdateNeighbors);
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        int floorAmount = tag.func_74762_e("floors");
        this.floors = new ElevatorButton[floorAmount];
        for (int i = 0; i < floorAmount; ++i) {
            NBTTagCompound buttonTag = tag.func_74775_l("floor" + i);
            this.floors[i] = new ElevatorButton();
            this.floors[i].readFromNBT(buttonTag);
        }
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        tag.func_74768_a("floors", this.floors.length);
        for (ElevatorButton floor : this.floors) {
            NBTTagCompound buttonTag = new NBTTagCompound();
            floor.writeToNBT(buttonTag);
            tag.func_74782_a("floor" + floor.floorNumber, (NBTBase)buttonTag);
        }
    }

    @Override
    public void onDescUpdate() {
        Block newCamo;
        Block block = newCamo = this.camoStack != null && this.camoStack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)this.camoStack.func_77973_b()).field_150939_a : null;
        if (newCamo != this.camoBlock) {
            this.camoBlock = newCamo;
            this.rerenderChunk();
        }
    }

    public void setFloors(ElevatorButton[] floors, int thisFloorLevel) {
        this.floors = floors;
        this.thisFloor = thisFloorLevel;
        this.sendDescriptionPacket();
    }

    public ElevatorButton[] getFloors() {
        return this.floors;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public static class ElevatorButton {
        public double posX;
        public double posY;
        public double width;
        public double height;
        public float red;
        public float green;
        public float blue;
        public String buttonText = "";
        public int floorNumber;
        public int floorHeight;

        public ElevatorButton(double posX, double posY, double width, double height, int floorNumber, int floorHeight) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.floorNumber = floorNumber;
            this.floorHeight = floorHeight;
            this.buttonText = floorNumber + 1 + "";
        }

        public ElevatorButton() {
        }

        public void setColor(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74780_a("posX", this.posX);
            tag.func_74780_a("posY", this.posY);
            tag.func_74780_a("width", this.width);
            tag.func_74780_a("height", this.height);
            tag.func_74778_a("buttonText", this.buttonText);
            tag.func_74768_a("floorNumber", this.floorNumber);
            tag.func_74768_a("floorHeight", this.floorHeight);
            tag.func_74776_a("red", this.red);
            tag.func_74776_a("green", this.green);
            tag.func_74776_a("blue", this.blue);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.posX = tag.func_74769_h("posX");
            this.posY = tag.func_74769_h("posY");
            this.width = tag.func_74769_h("width");
            this.height = tag.func_74769_h("height");
            this.buttonText = tag.func_74779_i("buttonText");
            this.floorNumber = tag.func_74762_e("floorNumber");
            this.floorHeight = tag.func_74762_e("floorHeight");
            this.red = tag.func_74760_g("red");
            this.green = tag.func_74760_g("green");
            this.blue = tag.func_74760_g("blue");
        }
    }
}

