/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.LazySynced;
import pneumaticCraft.common.tileentity.IAssemblyMachine;
import pneumaticCraft.common.tileentity.IResettable;
import pneumaticCraft.common.tileentity.TileEntityBase;

public class TileEntityAssemblyPlatform
extends TileEntityBase
implements IAssemblyMachine,
IResettable {
    @DescSynced
    private boolean shouldClawClose;
    @DescSynced
    @LazySynced
    public float clawProgress;
    public float oldClawProgress;
    @DescSynced
    private ItemStack[] inventory = new ItemStack[1];
    private float speed = 1.0f;
    public boolean hasDrilledStack;
    public boolean hasLaseredStack;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.oldClawProgress = this.clawProgress;
        if (!this.shouldClawClose && this.clawProgress > 0.0f) {
            this.clawProgress = Math.max(this.clawProgress - 0.05f * this.speed, 0.0f);
        } else if (this.shouldClawClose && this.clawProgress < 1.0f) {
            this.clawProgress = Math.min(this.clawProgress + 0.05f * this.speed, 1.0f);
        }
    }

    private boolean isClawDone() {
        return this.clawProgress == (this.shouldClawClose ? 1.0f : 0.0f);
    }

    @Override
    public boolean isIdle() {
        return !this.shouldClawClose && this.isClawDone() && this.inventory[0] == null;
    }

    @Override
    public boolean reset() {
        this.openClaw();
        return this.isIdle();
    }

    public boolean closeClaw() {
        this.hasDrilledStack = false;
        this.hasLaseredStack = false;
        this.shouldClawClose = true;
        return this.isClawDone();
    }

    public boolean openClaw() {
        this.shouldClawClose = false;
        return this.isClawDone();
    }

    public ItemStack getHeldStack() {
        return this.inventory[0];
    }

    public void setHeldStack(ItemStack stack) {
        if (stack == null) {
            this.hasDrilledStack = false;
            this.hasLaseredStack = false;
        }
        this.inventory[0] = stack;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("clawClosing", this.shouldClawClose);
        tag.func_74776_a("clawProgress", this.clawProgress);
        tag.func_74776_a("speed", this.speed);
        tag.func_74757_a("drilled", this.hasDrilledStack);
        tag.func_74757_a("lasered", this.hasLaseredStack);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.shouldClawClose = tag.func_74767_n("clawClosing");
        this.clawProgress = tag.func_74760_g("clawProgress");
        this.speed = tag.func_74760_g("speed");
        this.hasDrilledStack = tag.func_74767_n("drilled");
        this.hasLaseredStack = tag.func_74767_n("lasered");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[1];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }
}

