/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.recipe.AssemblyRecipe;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.recipes.programs.AssemblyProgram;
import pneumaticCraft.common.tileentity.TileEntityAssemblyPlatform;
import pneumaticCraft.common.tileentity.TileEntityAssemblyRobot;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityAssemblyLaser
extends TileEntityAssemblyRobot {
    @DescSynced
    public boolean isLaserOn;
    private int laserStep;
    private static final float ITEM_SIZE = 10.0f;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.laserStep > 0) {
            ForgeDirection[] platformDirection = this.getPlatformDirection();
            if (platformDirection == null) {
                this.laserStep = 105;
            }
            switch (this.laserStep) {
                case 1: {
                    this.slowMode = false;
                    break;
                }
                case 2: {
                    this.hoverOverNeighbour(platformDirection[0], platformDirection[1]);
                    break;
                }
                case 3: {
                    this.slowMode = true;
                    this.gotoNeighbour(platformDirection[0], platformDirection[1]);
                    break;
                }
                case 104: {
                    this.hoverOverNeighbour(platformDirection[0], platformDirection[1]);
                    this.isLaserOn = false;
                    this.slowMode = true;
                    TileEntity te = this.getTileEntityForCurrentDirection();
                    if (!(te instanceof TileEntityAssemblyPlatform)) break;
                    TileEntityAssemblyPlatform platform = (TileEntityAssemblyPlatform)te;
                    platform.hasLaseredStack = true;
                    ItemStack output = TileEntityAssemblyLaser.getLaseredOutputForItem(platform.getHeldStack());
                    if (output == null) break;
                    platform.setHeldStack(output);
                    break;
                }
                case 105: {
                    this.slowMode = false;
                    this.isLaserOn = false;
                    this.gotoHomePosition();
                    break;
                }
                default: {
                    this.isLaserOn = true;
                    this.slowMode = false;
                    this.targetAngles[TileEntityAssemblyRobot.EnumAngles.BASE.ordinal()] = 100.0f - (float)PneumaticCraftUtils.sin[(this.laserStep - 4) * 500 / 100] * 10.0f;
                    this.targetAngles[TileEntityAssemblyRobot.EnumAngles.MIDDLE.ordinal()] = -10.0f + (float)PneumaticCraftUtils.sin[(this.laserStep - 4) * 500 / 100] * 10.0f;
                    this.targetAngles[TileEntityAssemblyRobot.EnumAngles.TAIL.ordinal()] = 0.0f;
                    int n = TileEntityAssemblyRobot.EnumAngles.TURN.ordinal();
                    this.targetAngles[n] = (float)((double)this.targetAngles[n] + (double)((float)PneumaticCraftUtils.sin[(this.laserStep - 4) * 500 / 100] * 10.0f) * 0.03);
                }
            }
            if (this.isDoneInternal() || this.laserStep >= 4 && this.laserStep <= 103) {
                ++this.laserStep;
                if (this.laserStep > 105) {
                    this.laserStep = 0;
                }
            }
        }
    }

    public void startLasering() {
        if (this.laserStep == 0) {
            this.laserStep = 1;
        }
    }

    @Override
    public boolean gotoNeighbour(ForgeDirection primaryDir, ForgeDirection secondaryDir) {
        boolean diagonal = super.gotoNeighbour(primaryDir, secondaryDir);
        int n = TileEntityAssemblyRobot.EnumAngles.TURN.ordinal();
        this.targetAngles[n] = (float)((double)this.targetAngles[n] - 4.5);
        return diagonal;
    }

    private boolean isDoneInternal() {
        return super.isDoneMoving();
    }

    @Override
    public boolean isIdle() {
        return this.laserStep == 0 && this.isDoneInternal();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("laser", this.isLaserOn);
        tag.func_74768_a("laserStep", this.laserStep);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.isLaserOn = tag.func_74767_n("laser");
        this.laserStep = tag.func_74762_e("laserStep");
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return false;
    }

    public static ItemStack getLaseredOutputForItem(ItemStack input) {
        for (AssemblyRecipe recipe : AssemblyRecipe.laserRecipes) {
            if (!AssemblyProgram.isValidInput(recipe, input)) continue;
            return recipe.getOutput().func_77946_l();
        }
        return null;
    }

    @Override
    public boolean reset() {
        if (this.isIdle()) {
            return true;
        }
        this.isLaserOn = false;
        this.laserStep = 105;
        return false;
    }
}

