/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;

public class TileEntityAirCompressor
extends TileEntityPneumaticBase
implements ISidedInventory,
IRedstoneControlled {
    private ItemStack[] inventory = new ItemStack[5];
    private final int INVENTORY_SIZE = 5;
    public static final int FUEL_INVENTORY_INDEX = 0;
    public static final int UPGRADE_SLOT_START = 1;
    public static final int UPGRADE_SLOT_END = 4;
    @GuiSynced
    public int burnTime;
    @GuiSynced
    public int maxBurnTime;
    @GuiSynced
    public int redstoneMode = 0;
    @DescSynced
    public boolean isActive;
    @GuiSynced
    public int curFuelUsage;

    public TileEntityAirCompressor() {
        this(5.0f, 7.0f, 5000);
    }

    public TileEntityAirCompressor(float dangerPressure, float criticalPressure, int volume) {
        super(dangerPressure, criticalPressure, volume);
        this.setUpgradeSlots(1, 2, 3, 4);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime < this.curFuelUsage && this.inventory[0] != null && TileEntityFurnace.func_145954_b((ItemStack)this.inventory[0]) && this.redstoneAllows()) {
                this.burnTime += TileEntityFurnace.func_145952_a((ItemStack)this.inventory[0]);
                this.maxBurnTime = this.burnTime;
                --this.inventory[0].field_77994_a;
                if (this.inventory[0].field_77994_a == 0) {
                    this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                }
            }
            this.curFuelUsage = (int)((float)this.getBaseProduction() * this.getSpeedUsageMultiplierFromUpgrades(this.getUpgradeSlots()) / 10.0f);
            if (this.burnTime >= this.curFuelUsage) {
                this.burnTime -= this.curFuelUsage;
                if (!this.field_145850_b.field_72995_K) {
                    this.addAir((int)((double)((float)this.getBaseProduction() * this.getSpeedMultiplierFromUpgrades(this.getUpgradeSlots()) * (float)this.getEfficiency()) / 100.0), ForgeDirection.UNKNOWN);
                    this.onFuelBurn(this.curFuelUsage);
                }
            }
            this.isActive = this.burnTime > this.curFuelUsage;
        } else if (this.isActive) {
            this.spawnBurningParticle();
        }
        super.func_145845_h();
    }

    protected void onFuelBurn(int burnedFuel) {
    }

    public int getEfficiency() {
        return 100;
    }

    public int getBaseProduction() {
        return 10;
    }

    @Override
    public boolean redstoneAllows() {
        switch (this.redstoneMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            case 2: {
                return !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return false;
    }

    private void spawnBurningParticle() {
        Random rand = new Random();
        if (rand.nextInt(3) != 0) {
            return;
        }
        float f = (float)this.field_145851_c + 0.5f;
        float f1 = (float)this.field_145848_d + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)this.field_145849_e + 0.5f;
        float f3 = 0.5f;
        float f4 = rand.nextFloat() * 0.4f - 0.2f;
        switch (ForgeDirection.getOrientation((int)this.func_145832_p())) {
            case EAST: {
                this.field_145850_b.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                this.field_145850_b.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                this.field_145850_b.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                this.field_145850_b.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                this.field_145850_b.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                this.field_145850_b.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                this.field_145850_b.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                this.field_145850_b.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void disperseAir() {
        super.disperseAir();
        List<Pair<ForgeDirection, IAirHandler>> teList = this.getConnectedPneumatics();
        if (teList.size() == 0) {
            this.airLeak(ForgeDirection.getOrientation((int)this.func_145832_p()));
        }
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        return ForgeDirection.getOrientation((int)this.func_145832_p()) == side;
    }

    public int getBurnTimeRemainingScaled(int parts) {
        if (this.maxBurnTime == 0 || this.burnTime < this.curFuelUsage) {
            return 0;
        }
        return parts * this.burnTime / this.maxBurnTime;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return Blockss.airCompressor.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.burnTime = nbtTagCompound.func_74762_e("burnTime");
        this.maxBurnTime = nbtTagCompound.func_74762_e("maxBurn");
        this.redstoneMode = nbtTagCompound.func_74762_e("redstoneMode");
        NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("burnTime", this.burnTime);
        nbtTagCompound.func_74768_a("maxBurn", this.maxBurnTime);
        nbtTagCompound.func_74768_a("redstoneMode", this.redstoneMode);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 || itemstack != null && itemstack.func_77973_b() == Itemss.machineUpgrade;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }
}

