/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.tileentity.IEnergyInfo;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.common.PneumaticCraftAPIHandler;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IRedstoneControl;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="CoFHCore"), @Optional.Interface(iface="cofh.api.tileentity.IEnergyInfo", modid="CoFHCore")})
public class TileEntityAerialInterface
extends TileEntityPneumaticBase
implements ISidedInventory,
IFluidHandler,
IMinWorkingPressure,
IRedstoneControl,
IEnergyReceiver,
IEnergyInfo {
    private ItemStack[] inventory = new ItemStack[4];
    private final int INVENTORY_SIZE = 4;
    private static final int UPGRADE_SLOT_START = 0;
    private static final int UPGRADE_SLOT_END = 3;
    @GuiSynced
    public String playerName = "";
    public String playerUUID = "";
    private Fluid curXpFluid;
    @GuiSynced
    public int redstoneMode;
    @GuiSynced
    public int feedMode;
    private boolean oldRedstoneStatus;
    private boolean updateNeighbours;
    @GuiSynced
    public boolean isConnectedToPlayer;
    private boolean dispenserUpgradeInserted;
    private Object energyRF;
    private static final int RF_PER_TICK = 1000;

    public TileEntityAerialInterface() {
        super(20.0f, 25.0f, 4000);
        this.setUpgradeSlots(0, 1, 2, 3);
        if (this.isRFAvailable()) {
            this.initRF();
        }
    }

    public void setPlayer(GameProfile gameProfile) {
        this.setPlayer(gameProfile.getName(), gameProfile.getId() != null ? gameProfile.getId().toString() : "");
    }

    public void setPlayer(String username, String uuid) {
        this.playerName = username;
        this.playerUUID = uuid;
        this.updateNeighbours = true;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.updateNeighbours) {
            this.updateNeighbours = false;
            this.updateNeighbours();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.getPressure(ForgeDirection.UNKNOWN) > 10.0f && this.isConnectedToPlayer) {
                EntityPlayer player;
                if (this.energyRF != null) {
                    this.tickRF();
                }
                this.addAir(-1, ForgeDirection.UNKNOWN);
                if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                    boolean bl = this.dispenserUpgradeInserted = this.getUpgrades(1) > 0;
                }
                if (this.field_145850_b.func_82737_E() % 20L == 0L && (player = this.getPlayer()) != null && player.func_70086_ai() <= 280) {
                    player.func_70050_g(player.func_70086_ai() + 20);
                    this.addAir(-4000, (ForgeDirection)null);
                }
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.getPlayerInventory();
            }
        }
        if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
            this.oldRedstoneStatus = this.shouldEmitRedstone();
            this.updateNeighbours = true;
        }
        super.func_145845_h();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 1) {
                this.redstoneMode = 0;
            }
        } else if (buttonID >= 1 && buttonID < 4) {
            this.feedMode = buttonID - 1;
        }
    }

    public boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isConnectedToPlayer;
            }
        }
        return false;
    }

    private InventoryPlayer getPlayerInventory() {
        EntityPlayer player = this.getPlayer();
        return player != null ? player.field_71071_by : null;
    }

    private EntityPlayer getPlayer() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            EntityPlayer player = PneumaticCraftUtils.getPlayerFromId(this.playerUUID);
            this.isConnectedToPlayer = player != null;
            return player;
        }
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        InventoryPlayer inventoryPlayer = this.getPlayerInventory();
        return this.inventory.length + (inventoryPlayer != null ? inventoryPlayer.func_70302_i_() + (this.dispenserUpgradeInserted ? 1 : 0) : 0);
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 4) {
            return this.inventory[slot];
        }
        InventoryPlayer inventoryPlayer = this.getPlayerInventory();
        return inventoryPlayer != null ? (slot == this.inventory.length + inventoryPlayer.func_70302_i_() ? null : inventoryPlayer.func_70301_a(slot - 4)) : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (slot < 4) {
            ItemStack itemStack = this.func_70301_a(slot);
            if (itemStack != null) {
                if (itemStack.field_77994_a <= amount) {
                    this.func_70299_a(slot, null);
                } else {
                    itemStack = itemStack.func_77979_a(amount);
                    if (itemStack.field_77994_a == 0) {
                        this.func_70299_a(slot, null);
                    }
                }
            }
            return itemStack;
        }
        InventoryPlayer inventoryPlayer = this.getPlayerInventory();
        return inventoryPlayer != null ? inventoryPlayer.func_70298_a(slot - 4, amount) : null;
    }

    public ItemStack func_70304_b(int slot) {
        if (slot < 4) {
            ItemStack itemStack = this.func_70301_a(slot);
            if (itemStack != null) {
                this.func_70299_a(slot, null);
            }
            return itemStack;
        }
        InventoryPlayer inventoryPlayer = this.getPlayerInventory();
        return inventoryPlayer != null ? inventoryPlayer.func_70304_b(slot - 4) : null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot < 4) {
            this.inventory[slot] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
        } else {
            EntityPlayer player = this.getPlayer();
            if (this.dispenserUpgradeInserted) {
                if (itemStack != null) {
                    int startValue = itemStack.field_77994_a;
                    while (itemStack.field_77994_a > 0) {
                        ItemStack remainingItem = itemStack.func_77950_b(player.field_70170_p, player);
                        if (!((remainingItem = ForgeEventFactory.onItemUseFinish((EntityPlayer)player, (ItemStack)itemStack, (int)0, (ItemStack)remainingItem)) == null || remainingItem.field_77994_a <= 0 || remainingItem == itemStack && remainingItem.field_77994_a == startValue || player.field_71071_by.func_70441_a(remainingItem) || remainingItem.field_77994_a <= 0)) {
                            player.func_71019_a(remainingItem, false);
                        }
                        if (itemStack.field_77994_a != startValue) continue;
                        break;
                    }
                }
            } else {
                InventoryPlayer inventoryPlayer;
                InventoryPlayer inventoryPlayer2 = inventoryPlayer = player != null ? player.field_71071_by : null;
                if (inventoryPlayer != null) {
                    inventoryPlayer.func_70299_a(slot - 4, itemStack);
                } else if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                    EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, itemStack);
                    this.field_145850_b.func_72838_d((Entity)item);
                }
            }
        }
    }

    public String func_145825_b() {
        return Blockss.aerialInterface.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.feedMode = tag.func_74762_e("feedMode");
        this.setPlayer(tag.func_74779_i("playerName"), tag.func_74779_i("playerUUID"));
        this.isConnectedToPlayer = tag.func_74767_n("connected");
        if (tag.func_74764_b("curXpFluid")) {
            this.curXpFluid = FluidRegistry.getFluid((String)tag.func_74779_i("curXpFluid"));
        }
        if (this.energyRF != null) {
            this.readRF(tag);
        }
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[4];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.dispenserUpgradeInserted = this.getUpgrades(1) > 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("feedMode", this.feedMode);
        tag.func_74778_a("playerName", this.playerName);
        tag.func_74778_a("playerUUID", this.playerUUID);
        if (this.curXpFluid != null) {
            tag.func_74778_a("curXpFluid", this.curXpFluid.getName());
        }
        if (this.energyRF != null) {
            this.saveRF(tag);
        }
        tag.func_74757_a("connected", this.isConnectedToPlayer);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i >= 4 || itemstack != null && itemstack.func_77973_b() == Itemss.machineUpgrade;
    }

    public int[] func_94128_d(int var1) {
        if (ForgeDirection.getOrientation((int)var1) == ForgeDirection.UP) {
            return new int[]{0, 1, 2, 3};
        }
        if (this.getPlayerInventory() == null) {
            return new int[0];
        }
        if (ForgeDirection.getOrientation((int)var1) == ForgeDirection.DOWN) {
            return new int[]{40, 41, 42, 43};
        }
        if (this.dispenserUpgradeInserted) {
            return new int[]{44};
        }
        int[] mainInv = new int[36];
        for (int i = 0; i < 36; ++i) {
            mainInv[i] = i + 4;
        }
        return mainInv;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        if (i < 4) {
            return true;
        }
        EntityPlayer player = this.getPlayer();
        if (player == null) {
            return false;
        }
        if (this.getPressure(ForgeDirection.UNKNOWN) > 10.0f) {
            if (!this.dispenserUpgradeInserted || i >= 40 && i <= 43) {
                return i < 40 || itemstack != null && itemstack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemstack.func_77973_b()).field_77881_a == 43 - i;
            }
            if (i == 4 + player.field_71071_by.func_70302_i_() && this.getFoodValue(itemstack) > 0) {
                int foodValue = this.getFoodValue(itemstack);
                int curFoodLevel = player.func_71024_bL().func_75116_a();
                int feedMode = this.feedMode;
                if (feedMode == 2) {
                    feedMode = player.func_110138_aP() - player.func_110143_aJ() > 0.0f ? 1 : 0;
                }
                switch (feedMode) {
                    case 0: {
                        return 20 - curFoodLevel >= foodValue * itemstack.field_77994_a;
                    }
                    case 1: {
                        return 20 - curFoodLevel >= foodValue * (itemstack.field_77994_a - 1) + 1;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i < 4 || this.getPressure(ForgeDirection.UNKNOWN) > 10.0f;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    private int getFoodValue(ItemStack item) {
        return item != null && item.func_77973_b() instanceof ItemFood ? ((ItemFood)item.func_77973_b()).func_150905_g(item) : 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        EntityPlayer player;
        if (resource != null && this.canFill(from, resource.getFluid()) && (player = this.getPlayer()) != null) {
            int liquidToXP = PneumaticCraftAPIHandler.getInstance().liquidXPs.get(resource.getFluid());
            int xpPoints = resource.amount / liquidToXP;
            if (doFill) {
                player.func_71023_q(xpPoints);
                this.curXpFluid = resource.getFluid();
            }
            return xpPoints * liquidToXP;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        EntityPlayer player;
        if (resource != null && this.canDrain(from, resource.getFluid()) && (player = this.getPlayer()) != null) {
            int liquidToXP = PneumaticCraftAPIHandler.getInstance().liquidXPs.get(resource.getFluid());
            int pointsDrained = Math.min(TileEntityAerialInterface.getPlayerXP(player), resource.amount / liquidToXP);
            if (doDrain) {
                TileEntityAerialInterface.addPlayerXP(player, -pointsDrained);
            }
            return new FluidStack(resource.getFluid(), pointsDrained * liquidToXP);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        this.updateXpFluid();
        if (this.curXpFluid == null) {
            return null;
        }
        return this.drain(from, new FluidStack(this.curXpFluid, maxDrain), doDrain);
    }

    private void updateXpFluid() {
        Iterator<Fluid> fluids;
        if (this.curXpFluid == null && (fluids = PneumaticCraftAPIHandler.getInstance().liquidXPs.keySet().iterator()).hasNext()) {
            this.curXpFluid = fluids.next();
        }
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && PneumaticCraftAPIHandler.getInstance().liquidXPs.containsKey(fluid) && this.getPlayer() != null && this.getPressure(ForgeDirection.UNKNOWN) > 10.0f && this.dispenserUpgradeInserted;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return (fluid == null || PneumaticCraftAPIHandler.getInstance().liquidXPs.containsKey(fluid)) && this.getPlayer() != null && this.getPressure(ForgeDirection.UNKNOWN) > 10.0f && this.dispenserUpgradeInserted;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        EntityPlayer player;
        this.updateXpFluid();
        if (this.curXpFluid != null && (player = this.getPlayer()) != null) {
            return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(this.curXpFluid, TileEntityAerialInterface.getPlayerXP(player) * PneumaticCraftAPIHandler.getInstance().liquidXPs.get(this.curXpFluid)), Integer.MAX_VALUE)};
        }
        return null;
    }

    private static int getPlayerXP(EntityPlayer player) {
        return (int)((float)TileEntityAerialInterface.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    private static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    private static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = TileEntityAerialInterface.getPlayerXP(player) + amount;
        player.field_71068_ca = TileEntityAerialInterface.getLevelForExperience(experience);
        int expForLevel = TileEntityAerialInterface.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    private static int getLevelForExperience(int experience) {
        int i = 0;
        while (TileEntityAerialInterface.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    private boolean isRFAvailable() {
        return Loader.isModLoaded((String)"CoFHCore");
    }

    private void initRF() {
        this.energyRF = new EnergyStorage(100000);
    }

    private void saveRF(NBTTagCompound tag) {
        this.getEnergy().writeToNBT(tag);
    }

    private void readRF(NBTTagCompound tag) {
        this.getEnergy().readFromNBT(tag);
    }

    private void tickRF() {
        InventoryPlayer inv;
        if (this.getEnergyStored(null) > 0 && (inv = this.getPlayerInventory()) != null) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem chargingItem = (IEnergyContainerItem)stack.func_77973_b();
                int energyLeft = this.getEnergyStored(null);
                if (energyLeft <= 0) break;
                this.getEnergy().extractEnergy(chargingItem.receiveEnergy(stack, energyLeft, false), false);
            }
        }
    }

    @Optional.Method(modid="CoFHCore")
    private EnergyStorage getEnergy() {
        return (EnergyStorage)this.energyRF;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int getInfoEnergyPerTick() {
        return 1000;
    }

    public int getInfoMaxEnergyPerTick() {
        return 1000;
    }

    public int getInfoEnergyStored() {
        return this.getEnergy().getEnergyStored();
    }

    public int getInfoMaxEnergyStored() {
        return this.getEnergy().getMaxEnergyStored();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.getEnergy().receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.getEnergy().getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getEnergy().getMaxEnergyStored();
    }
}

