/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.tileentity.TileEntityAdvancedAirCompressor;
import pneumaticCraft.common.tileentity.TileEntityLiquidCompressor;

public class TileEntityAdvancedLiquidCompressor
extends TileEntityLiquidCompressor
implements IHeatExchanger {
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();

    public TileEntityAdvancedLiquidCompressor() {
        super(20.0f, 25.0f, 10000);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(ForgeDirection side) {
        return this.heatExchanger;
    }

    @Override
    protected void onFuelBurn(int burnedFuel) {
        this.heatExchanger.addHeat((double)burnedFuel / 20.0);
    }

    @Override
    public int getBaseProduction() {
        return 50;
    }

    @Override
    public int getEfficiency() {
        return TileEntityAdvancedAirCompressor.getEfficiency(this.heatExchanger.getTemperature());
    }

    @Override
    protected float getSpeedUsageMultiplierFromUpgrades(int[] upgradeSlots) {
        return this.getSpeedMultiplierFromUpgrades(upgradeSlots);
    }

    @Override
    public String func_145825_b() {
        return Blockss.advancedLiquidCompressor.func_149739_a();
    }
}

