/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.waila;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class WailaPneumaticHandler
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        WailaPneumaticHandler.addTipToMachine(currenttip, accessor);
        return currenttip;
    }

    public static void addTipToMachine(List<String> currenttip, IWailaDataAccessor accessor) {
        NBTTagCompound tCompound = accessor.getNBTData();
        TileEntity te = accessor.getTileEntity();
        if (te instanceof IPneumaticMachine) {
            WailaPneumaticHandler.addTipToMachine(currenttip, (IPneumaticMachine)te, tCompound.func_74760_g("pressure"));
        }
    }

    public static void addTipToMachine(List<String> currenttip, IPneumaticMachine machine) {
        WailaPneumaticHandler.addTipToMachine(currenttip, machine, machine.getAirHandler().getPressure(ForgeDirection.UNKNOWN));
    }

    public static void addTipToMachine(List<String> currenttip, IPneumaticMachine machine, float pressure) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("Pressure", PneumaticCraftUtils.roundNumberTo(pressure, 1) + " bar");
        TileEntityPneumaticBase base = (TileEntityPneumaticBase)machine.getAirHandler();
        values.put("Max Pressure", base.DANGER_PRESSURE + " bar");
        for (Map.Entry entry : values.entrySet()) {
            currenttip.add((String)entry.getKey() + ": " + SpecialChars.WHITE + (String)entry.getValue());
        }
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof IPneumaticMachine) {
            tag.func_74776_a("pressure", ((IPneumaticMachine)te).getAirHandler().getPressure(ForgeDirection.UNKNOWN));
        }
        return tag;
    }
}

