/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.thaumcraft;

import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pneumaticCraft.api.client.pneumaticHelmet.IBlockTrackEntry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.nodes.INode;

public class BlockTrackEntryThaumcraft
implements IBlockTrackEntry {
    @Override
    public boolean shouldTrackWithThisEntry(IBlockAccess world, int x, int y, int z, Block block, TileEntity te) {
        return te instanceof IAspectContainer;
    }

    @Override
    public boolean shouldBeUpdatedFromServer(TileEntity te) {
        return false;
    }

    @Override
    public int spamThreshold() {
        return 8;
    }

    @Override
    public void addInformation(World world, int x, int y, int z, TileEntity te, List<String> infoList) {
        if (te instanceof IAspectContainer) {
            IAspectContainer container = (IAspectContainer)te;
            AspectList aspects = container.getAspects();
            if (aspects != null && aspects.size() > 0) {
                infoList.add("blockTracker.info.thaumcraft");
                for (Map.Entry entry : aspects.aspects.entrySet()) {
                    infoList.add("-" + entry.getValue() + "x " + ((Aspect)entry.getKey()).getName());
                }
            } else {
                infoList.add(I18n.func_135052_a((String)"blockTracker.info.thaumcraft", (Object[])new Object[0]) + " -");
            }
            if (container instanceof INode) {
                INode node = (INode)container;
                infoList.add(I18n.func_135052_a((String)"blockTracker.info.thaumcraft.nodetype", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("nodetype." + node.getNodeType() + ".name"), (Object[])new Object[0]));
                if (node.getNodeModifier() != null) {
                    infoList.add(I18n.func_135052_a((String)"blockTracker.info.thaumcraft.nodeModifier", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("nodemod." + node.getNodeModifier() + ".name"), (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    public String getEntryName() {
        return "blockTracker.module.thaumcraft";
    }
}

