/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.client.gui.GuiUtils;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.client.gui.widget.WidgetTank;
import pneumaticCraft.client.gui.widget.WidgetTemperature;

public abstract class PneumaticCraftPlugins
extends TemplateRecipeHandler {
    public int recipiesPerPage() {
        return 1;
    }

    public void drawAnimatedPressureGauge(int x, int y, float minPressure, float minWorkingPressure, float dangerPressure, float maxPressure, float progress) {
        GuiUtils.drawPressureGauge(FMLClientHandler.instance().getClient().field_71466_p, minPressure, maxPressure, dangerPressure, minWorkingPressure, minWorkingPressure * progress, x, y, -90.0f);
    }

    protected void addTransferRect(Rectangle rect) {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(rect, this.getRecipeName(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        super.loadCraftingRecipes(outputId, results);
        if (outputId.equals(this.getRecipeName())) {
            this.loadAllRecipes();
        }
        if (outputId.equals("liquid") && results.length > 0 && results[0] instanceof FluidStack) {
            this.loadCraftingRecipes((FluidStack)results[0]);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        super.loadUsageRecipes(inputId, ingredients);
        if (inputId.equals(this.getRecipeName())) {
            this.loadAllRecipes();
        }
        if (inputId.equals("liquid") && ingredients.length > 0 && ingredients[0] instanceof FluidStack) {
            this.loadUsageRecipes((FluidStack)ingredients[0]);
        }
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        this.loadTankTransferRects(recipe);
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        this.loadTankTransferRects(recipe);
        return super.mouseClicked(gui, button, recipe);
    }

    private void loadTankTransferRects(int recipe) {
        MultipleInputOutputRecipe r = (MultipleInputOutputRecipe)((Object)this.arecipes.get(recipe));
        this.transferRects.clear();
        this.loadTransferRects();
        for (WidgetTank tank : r.inputLiquids) {
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(tank.getBounds(), "liquid", new Object[]{tank.getFluid()}));
        }
        for (WidgetTank tank : r.outputLiquids) {
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(tank.getBounds(), "liquid", new Object[]{tank.getFluid()}));
        }
    }

    public List<String> handleTooltip(GuiRecipe guiRecipe, List<String> currenttip, int recipe) {
        MultipleInputOutputRecipe r = (MultipleInputOutputRecipe)((Object)this.arecipes.get(recipe));
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)guiRecipe)) {
            Point mouse = GuiDraw.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mouse.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x, mouse.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
            for (IGuiWidget widget : r.tooltipWidgets) {
                if (!widget.getBounds().contains(relMouse)) continue;
                widget.addTooltip(mouse.x, mouse.y, currenttip, false);
            }
            if (r.tempWidget != null && r.tempWidget.getBounds().contains(relMouse)) {
                r.heatExchanger.setTemperature(r.tempWidget.getScales()[0]);
                r.tempWidget.addTooltip(mouse.x, mouse.y, currenttip, false);
            }
        }
        return currenttip;
    }

    public void drawExtras(int recipe) {
        MultipleInputOutputRecipe r = (MultipleInputOutputRecipe)((Object)this.arecipes.get(recipe));
        for (IGuiWidget widget : r.tooltipWidgets) {
            widget.render(0, 0, 0.0f);
        }
        if (r.usePressure) {
            this.drawAnimatedPressureGauge(r.gaugeX, r.gaugeY, -1.0f, r.pressure, 5.0f, 7.0f, (float)(this.cycleticks % 48) / 48.0f);
        }
        if (r.tempWidget != null) {
            r.heatExchanger.setTemperature((float)(this.cycleticks % 48) / 48.0f * (float)(r.tempWidget.getScales()[0] - 273) + 273.0f);
            r.tempWidget.render(0, 0, 0.0f);
        }
    }

    protected abstract List<MultipleInputOutputRecipe> getAllRecipes();

    protected void loadCraftingRecipes(FluidStack stack) {
        for (MultipleInputOutputRecipe recipe : this.getAllRecipes()) {
            for (WidgetTank tank : recipe.outputLiquids) {
                if (tank.getFluid() == null || tank.getFluid().getFluid() != stack.getFluid()) continue;
                this.arecipes.add(recipe);
            }
        }
    }

    public void loadCraftingRecipes(ItemStack output) {
        for (MultipleInputOutputRecipe recipe : this.getAllRecipes()) {
            for (PositionedStack stack : recipe.output) {
                for (ItemStack itemStack : stack.items) {
                    if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)itemStack, (ItemStack)output)) continue;
                    this.arecipes.add(recipe);
                }
            }
        }
    }

    protected void loadUsageRecipes(FluidStack stack) {
        for (MultipleInputOutputRecipe recipe : this.getAllRecipes()) {
            for (WidgetTank tank : recipe.inputLiquids) {
                if (tank.getFluid() == null || tank.getFluid().getFluid() != stack.getFluid()) continue;
                this.arecipes.add(recipe);
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (MultipleInputOutputRecipe recipe : this.getAllRecipes()) {
            for (PositionedStack stack : recipe.input) {
                for (ItemStack itemStack : stack.items) {
                    if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)itemStack, (ItemStack)ingredient)) continue;
                    this.arecipes.add(recipe);
                }
            }
        }
    }

    protected void loadAllRecipes() {
        for (MultipleInputOutputRecipe recipe : this.getAllRecipes()) {
            this.arecipes.add(recipe);
        }
    }

    public class MultipleInputOutputRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> input;
        private final List<PositionedStack> output;
        private final List<WidgetTank> inputLiquids;
        private final List<WidgetTank> outputLiquids;
        private final List<IGuiWidget> tooltipWidgets;
        private float pressure;
        private boolean usePressure;
        private int gaugeX;
        private int gaugeY;
        private WidgetTemperature tempWidget;
        private IHeatExchangerLogic heatExchanger;

        public MultipleInputOutputRecipe() {
            super((TemplateRecipeHandler)PneumaticCraftPlugins.this);
            this.input = new ArrayList<PositionedStack>();
            this.output = new ArrayList<PositionedStack>();
            this.inputLiquids = new ArrayList<WidgetTank>();
            this.outputLiquids = new ArrayList<WidgetTank>();
            this.tooltipWidgets = new ArrayList<IGuiWidget>();
        }

        public void addIngredient(PositionedStack stack) {
            this.input.add(stack);
        }

        public void addIngredient(PositionedStack[] stacks) {
            for (PositionedStack stack : stacks) {
                this.input.add(stack);
            }
        }

        public void addOutput(PositionedStack stack) {
            this.output.add(stack);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(PneumaticCraftPlugins.this.cycleticks / 20, this.input);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.output;
        }

        protected void addInputLiquid(FluidStack liquid, int x, int y) {
            WidgetTank tank = new WidgetTank(x, y, liquid);
            this.addInputLiquid(tank);
        }

        protected void addInputLiquid(WidgetTank tank) {
            this.inputLiquids.add(tank);
            this.tooltipWidgets.add(tank);
            this.recalculateTankSizes();
        }

        protected void addOutputLiquid(FluidStack liquid, int x, int y) {
            WidgetTank tank = new WidgetTank(x, y, liquid);
            this.addOutputLiquid(tank);
        }

        protected void addOutputLiquid(WidgetTank tank) {
            this.outputLiquids.add(tank);
            this.tooltipWidgets.add(tank);
            this.recalculateTankSizes();
        }

        private void recalculateTankSizes() {
            int maxFluid = 0;
            for (WidgetTank w : this.inputLiquids) {
                maxFluid = Math.max(maxFluid, w.getTank().getFluidAmount());
            }
            for (WidgetTank w : this.outputLiquids) {
                maxFluid = Math.max(maxFluid, w.getTank().getFluidAmount());
            }
            maxFluid = maxFluid <= 10 ? 10 : (maxFluid <= 100 ? 100 : (maxFluid <= 1000 ? 1000 : 16000));
            for (WidgetTank w : this.inputLiquids) {
                w.getTank().setCapacity(maxFluid);
            }
            for (WidgetTank w : this.outputLiquids) {
                w.getTank().setCapacity(maxFluid);
            }
        }

        protected void addWidget(IGuiWidget widget) {
            this.tooltipWidgets.add(widget);
        }

        protected void setUsedPressure(int x, int y, float pressure) {
            this.usePressure = true;
            this.pressure = pressure;
            this.gaugeX = x;
            this.gaugeY = y;
        }

        protected void setUsedTemperature(int x, int y, double temperature) {
            this.heatExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();
            this.tempWidget = new WidgetTemperature(0, x, y, 273, 673, this.heatExchanger, (int)temperature);
        }
    }
}

