/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.sensor.pollSensors;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import org.lwjgl.util.Rectangle;
import pneumaticCraft.api.universalSensor.IBlockAndCoordinatePollSensor;

public class BlockRedstoneSensor
implements IBlockAndCoordinatePollSensor {
    @Override
    public String getSensorPath() {
        return "blockTracker_gpsTool/Block/Redstone";
    }

    @Override
    public int getPollFrequency() {
        return 2;
    }

    @Override
    public boolean needsTextBox() {
        return false;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.BLACK + "This sensor could be used as a wireless redstone device, as it emits the same redstone signal as being applied at the GPS Tool's saved location. In case of multiple locations, the location with the highest redstone value is emitted.");
        return text;
    }

    @Override
    public int getRedstoneValue(World world, int x, int y, int z, int sensorRange, String textBoxText, Set<ChunkPosition> positions) {
        int redstonePower = 0;
        for (ChunkPosition pos : positions) {
            redstonePower = Math.max(redstonePower, world.func_94572_D(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c));
            for (int i = 0; i < 6 && redstonePower < 15; ++i) {
                redstonePower = Math.max(redstonePower, world.func_72878_l(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, i));
            }
            if (redstonePower != 15) continue;
            return 15;
        }
        return redstonePower;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAdditionalInfo(FontRenderer fontRenderer) {
    }

    @Override
    public Rectangle needsSlot() {
        return null;
    }
}

