/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.sensor.pollSensors;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.util.Rectangle;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.api.universalSensor.IBlockAndCoordinatePollSensor;
import pneumaticCraft.common.tileentity.TileEntityCompressedIronBlock;

public class BlockHeatSensor
implements IBlockAndCoordinatePollSensor {
    @Override
    public String getSensorPath() {
        return "blockTracker_gpsTool/Block/Heat";
    }

    @Override
    public int getPollFrequency() {
        return 20;
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.BLACK + I18n.func_135052_a((String)"gui.universalSensor.desc.heatSensor", (Object[])new Object[0]));
        return text;
    }

    @Override
    public int getRedstoneValue(World world, int x, int y, int z, int sensorRange, String textBoxText, Set<ChunkPosition> positions) {
        double temperature = Double.MIN_VALUE;
        for (ChunkPosition pos : positions) {
            TileEntity te = world.func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            if (!(te instanceof IHeatExchanger)) continue;
            IHeatExchanger exchanger = (IHeatExchanger)te;
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IHeatExchangerLogic logic = exchanger.getHeatExchangerLogic(d);
                if (logic == null) continue;
                temperature = Math.max(temperature, logic.getTemperature());
            }
        }
        return NumberUtils.isNumber((String)textBoxText) ? (temperature - 273.0 > (double)NumberUtils.toInt((String)textBoxText) ? 15 : 0) : TileEntityCompressedIronBlock.getComparatorOutput((int)temperature);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAdditionalInfo(FontRenderer fontRenderer) {
    }

    @Override
    public Rectangle needsSlot() {
        return null;
    }
}

