/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.semiblock;

import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketDescription;
import pneumaticCraft.common.network.PacketSetSemiBlock;
import pneumaticCraft.common.semiblock.ISemiBlock;
import pneumaticCraft.common.semiblock.ISemiBlockItem;
import pneumaticCraft.common.semiblock.ItemSemiBlockBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;

public class SemiBlockManager {
    private final Map<Chunk, Map<ChunkPosition, ISemiBlock>> semiBlocks = new HashMap<Chunk, Map<ChunkPosition, ISemiBlock>>();
    private final List<ISemiBlock> addingBlocks = new ArrayList<ISemiBlock>();
    private final Map<Chunk, Set<EntityPlayerMP>> syncList = new HashMap<Chunk, Set<EntityPlayerMP>>();
    private final Set<Chunk> chunksMarkedForRemoval = new HashSet<Chunk>();
    public static final int SYNC_DISTANCE = 64;
    private static final HashBiMap<String, Class<? extends ISemiBlock>> registeredTypes = HashBiMap.create();
    private static final HashBiMap<Class<? extends ISemiBlock>, Item> semiBlockToItems = HashBiMap.create();
    private static final SemiBlockManager INSTANCE = new SemiBlockManager();
    private static final SemiBlockManager CLIENT_INSTANCE = new SemiBlockManager();

    public static SemiBlockManager getServerInstance() {
        return INSTANCE;
    }

    public static SemiBlockManager getClientOldInstance() {
        return CLIENT_INSTANCE;
    }

    public static SemiBlockManager getInstance(World world) {
        return world.field_72995_K ? CLIENT_INSTANCE : INSTANCE;
    }

    public static Item registerSemiBlock(String key, Class<? extends ISemiBlock> semiBlock, boolean addItem) {
        if (registeredTypes.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicate registration key: " + key);
        }
        registeredTypes.put((Object)key, semiBlock);
        if (addItem) {
            ItemSemiBlockBase item = new ItemSemiBlockBase(key);
            GameRegistry.registerItem((Item)item, (String)key);
            PneumaticCraft.proxy.registerSemiBlockRenderer(item);
            SemiBlockManager.registerSemiBlockToItemMapping(semiBlock, item);
            return item;
        }
        return null;
    }

    public static void registerSemiBlockToItemMapping(Class<? extends ISemiBlock> semiBlock, Item item) {
        semiBlockToItems.put(semiBlock, (Object)item);
    }

    public static Item getItemForSemiBlock(ISemiBlock semiBlock) {
        return SemiBlockManager.getItemForSemiBlock(semiBlock.getClass());
    }

    public static Item getItemForSemiBlock(Class<? extends ISemiBlock> semiBlock) {
        return (Item)semiBlockToItems.get(semiBlock);
    }

    public static Class<? extends ISemiBlock> getSemiBlockForItem(Item item) {
        return (Class)semiBlockToItems.inverse().get((Object)item);
    }

    public static String getKeyForSemiBlock(ISemiBlock semiBlock) {
        return SemiBlockManager.getKeyForSemiBlock(semiBlock.getClass());
    }

    public static String getKeyForSemiBlock(Class<? extends ISemiBlock> semiBlock) {
        return (String)registeredTypes.inverse().get(semiBlock);
    }

    public static ISemiBlock getSemiBlockForKey(String key) {
        try {
            Class clazz = (Class)registeredTypes.get((Object)key);
            if (clazz != null) {
                return (ISemiBlock)clazz.newInstance();
            }
            Log.warning("Semi Block with id \"" + key + "\" isn't registered!");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @SubscribeEvent
    public void onChunkUnLoad(ChunkEvent.Unload event) {
        if (!event.world.field_72995_K) {
            this.chunksMarkedForRemoval.add(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        Map<ChunkPosition, ISemiBlock> map = this.semiBlocks.get(event.getChunk());
        if (map != null && map.size() > 0) {
            NBTTagList tagList = new NBTTagList();
            for (Map.Entry<ChunkPosition, ISemiBlock> entry : map.entrySet()) {
                NBTTagCompound t = new NBTTagCompound();
                entry.getValue().writeToNBT(t);
                t.func_74768_a("x", entry.getKey().field_151329_a);
                t.func_74768_a("y", entry.getKey().field_151327_b);
                t.func_74768_a("z", entry.getKey().field_151328_c);
                t.func_74778_a("type", SemiBlockManager.getKeyForSemiBlock(entry.getValue()));
                tagList.func_74742_a((NBTBase)t);
            }
            event.getData().func_74782_a("SemiBlocks", (NBTBase)tagList);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        try {
            if (!event.world.field_72995_K && event.getData().func_74764_b("SemiBlocks")) {
                Map<ChunkPosition, ISemiBlock> map = this.getOrCreateMap(event.getChunk());
                map.clear();
                NBTTagList tagList = event.getData().func_150295_c("SemiBlocks", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound t = tagList.func_150305_b(i);
                    ISemiBlock semiBlock = SemiBlockManager.getSemiBlockForKey(t.func_74779_i("type"));
                    if (semiBlock == null) continue;
                    semiBlock.readFromNBT(t);
                    this.setSemiBlock(event.world, t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z"), semiBlock, event.getChunk());
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        for (ISemiBlock iSemiBlock : this.addingBlocks) {
            Chunk chunk = iSemiBlock.getWorld().func_72938_d(iSemiBlock.getPos().field_151329_a, iSemiBlock.getPos().field_151328_c);
            this.getOrCreateMap(chunk).put(iSemiBlock.getPos(), iSemiBlock);
            chunk.func_76630_e();
            for (EntityPlayerMP player : this.syncList.get(chunk)) {
                NetworkHandler.sendTo(new PacketSetSemiBlock(iSemiBlock), player);
                PacketDescription descPacket = iSemiBlock.getDescriptionPacket();
                if (descPacket == null) continue;
                NetworkHandler.sendTo(descPacket, player);
            }
        }
        this.addingBlocks.clear();
        for (Chunk chunk : this.chunksMarkedForRemoval) {
            if (chunk.field_76636_d) continue;
            this.semiBlocks.remove(chunk);
            this.syncList.remove(chunk);
        }
        this.chunksMarkedForRemoval.clear();
        for (Map map : this.semiBlocks.values()) {
            for (ISemiBlock semiBlock : map.values()) {
                if (semiBlock.isInvalid()) continue;
                semiBlock.update();
            }
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                if (!((ISemiBlock)iterator.next()).isInvalid()) continue;
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this == SemiBlockManager.getServerInstance()) {
            SemiBlockManager.getClientOldInstance().onClientTick(event);
        } else {
            EntityPlayer player = PneumaticCraft.proxy.getPlayer();
            if (player != null) {
                for (ISemiBlock semiBlock : this.addingBlocks) {
                    Chunk chunk = semiBlock.getWorld().func_72938_d(semiBlock.getPos().field_151329_a, semiBlock.getPos().field_151328_c);
                    this.getOrCreateMap(chunk).put(semiBlock.getPos(), semiBlock);
                }
                this.addingBlocks.clear();
                Iterator<Map.Entry<Chunk, Map<ChunkPosition, ISemiBlock>>> iterator = this.semiBlocks.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Chunk, Map<ChunkPosition, ISemiBlock>> entry = iterator.next();
                    if (PneumaticCraftUtils.distBetween(player.field_70165_t, 0.0, player.field_70161_v, entry.getKey().field_76635_g * 16 - 8, 0.0, entry.getKey().field_76647_h * 16 - 8) > 74.0) {
                        iterator.remove();
                        continue;
                    }
                    for (ISemiBlock semiBlock : entry.getValue().values()) {
                        if (semiBlock.isInvalid()) continue;
                        semiBlock.update();
                    }
                    Iterator<ISemiBlock> it = entry.getValue().values().iterator();
                    while (it.hasNext()) {
                        if (!it.next().isInvalid()) continue;
                        it.remove();
                    }
                }
            } else {
                this.semiBlocks.clear();
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K) {
            this.syncWithPlayers(event.world);
        }
    }

    private void syncWithPlayers(World world) {
        List players = world.field_73010_i;
        for (Map.Entry<Chunk, Set<EntityPlayerMP>> entry : this.syncList.entrySet()) {
            Chunk chunk = entry.getKey();
            Set<EntityPlayerMP> syncedPlayers = entry.getValue();
            int chunkX = chunk.field_76635_g * 16 - 8;
            int chunkZ = chunk.field_76647_h * 16 - 8;
            for (EntityPlayerMP player : players) {
                if (chunk.field_76637_e == world) {
                    double dist = PneumaticCraftUtils.distBetween(player.field_70165_t, 0.0, player.field_70161_v, chunkX, 0.0, chunkZ);
                    if (dist < 64.0) {
                        if (!syncedPlayers.add(player)) continue;
                        for (ISemiBlock semiBlock : this.semiBlocks.get(chunk).values()) {
                            if (semiBlock.isInvalid()) continue;
                            NetworkHandler.sendTo(new PacketSetSemiBlock(semiBlock), player);
                            PacketDescription descPacket = semiBlock.getDescriptionPacket();
                            if (descPacket == null) continue;
                            NetworkHandler.sendTo(descPacket, player);
                        }
                        continue;
                    }
                    if (!(dist > 69.0)) continue;
                    syncedPlayers.remove(player);
                    continue;
                }
                syncedPlayers.remove(player);
            }
        }
    }

    @SubscribeEvent
    public void onInteraction(PlayerInteractEvent event) {
        ItemStack curItem;
        if (!event.world.field_72995_K && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (curItem = event.entityPlayer.func_71045_bC()) != null && curItem.func_77973_b() instanceof ISemiBlockItem) {
            if (this.getSemiBlock(event.world, event.x, event.y, event.z) != null) {
                if (event.entityPlayer.field_71075_bZ.field_75098_d) {
                    this.setSemiBlock(event.world, event.x, event.y, event.z, null);
                } else {
                    this.breakSemiBlock(event.world, event.x, event.y, event.z, event.entityPlayer);
                }
                event.setCanceled(true);
            } else {
                ISemiBlock newBlock = ((ISemiBlockItem)curItem.func_77973_b()).getSemiBlock(event.world, event.x, event.y, event.z, curItem);
                newBlock.initialize(event.world, new ChunkPosition(event.x, event.y, event.z));
                if (newBlock.canPlace()) {
                    this.setSemiBlock(event.world, event.x, event.y, event.z, newBlock);
                    newBlock.onPlaced(event.entityPlayer, curItem);
                    event.world.func_72908_a((double)event.x + 0.5, (double)event.y + 0.5, (double)event.z + 0.5, Block.field_149778_k.func_150496_b(), (Block.field_149778_k.func_150497_c() + 1.0f) / 2.0f, Block.field_149778_k.func_150494_d() * 0.8f);
                    if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                        --curItem.field_77994_a;
                        if (curItem.field_77994_a <= 0) {
                            event.entityPlayer.func_70062_b(0, null);
                        }
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    private Map<ChunkPosition, ISemiBlock> getOrCreateMap(Chunk chunk) {
        Map<ChunkPosition, ISemiBlock> map = this.semiBlocks.get(chunk);
        if (map == null) {
            map = new HashMap<ChunkPosition, ISemiBlock>();
            this.semiBlocks.put(chunk, map);
            this.syncList.put(chunk, new HashSet());
        }
        return map;
    }

    public void breakSemiBlock(World world, int x, int y, int z) {
        this.breakSemiBlock(world, x, y, z, null);
    }

    public void breakSemiBlock(World world, int x, int y, int z, EntityPlayer player) {
        ISemiBlock semiBlock = this.getSemiBlock(world, x, y, z);
        if (semiBlock != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            semiBlock.addDrops(drops);
            for (ItemStack stack : drops) {
                EntityItem item = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
                world.func_72838_d((Entity)item);
                if (player == null) continue;
                item.func_70100_b_(player);
            }
            this.setSemiBlock(world, x, y, z, null);
        }
    }

    public void setSemiBlock(World world, int x, int y, int z, ISemiBlock semiBlock) {
        this.setSemiBlock(world, x, y, z, semiBlock, world.func_72938_d(x, z));
    }

    private void setSemiBlock(World world, int x, int y, int z, ISemiBlock semiBlock, Chunk chunk) {
        if (semiBlock != null && !registeredTypes.containsValue(semiBlock.getClass())) {
            throw new IllegalStateException("ISemiBlock \"" + semiBlock + "\" was not registered!");
        }
        ChunkPosition pos = new ChunkPosition(x, y, z);
        if (semiBlock != null) {
            semiBlock.initialize(world, pos);
            this.addingBlocks.add(semiBlock);
        } else {
            ISemiBlock removedBlock = this.getOrCreateMap(chunk).get(pos);
            if (removedBlock != null) {
                removedBlock.invalidate();
                for (EntityPlayerMP player : this.syncList.get(chunk)) {
                    NetworkHandler.sendTo(new PacketSetSemiBlock(pos, null), player);
                }
            }
        }
        chunk.func_76630_e();
    }

    public ISemiBlock getSemiBlock(World world, int x, int y, int z) {
        for (ISemiBlock semiBlock : this.addingBlocks) {
            if (semiBlock.getWorld() != world || !semiBlock.getPos().equals((Object)new ChunkPosition(x, y, z))) continue;
            return semiBlock;
        }
        Chunk chunk = world.func_72938_d(x, z);
        Map<ChunkPosition, ISemiBlock> map = this.semiBlocks.get(chunk);
        if (map != null) {
            return map.get(new ChunkPosition(x, y, z));
        }
        return null;
    }

    public Map<Chunk, Map<ChunkPosition, ISemiBlock>> getSemiBlocks() {
        return this.semiBlocks;
    }
}

