/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.semiblock;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.common.item.ItemLogisticsFrame;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketSetSemiBlock;
import pneumaticCraft.common.semiblock.SemiBlockBasic;
import pneumaticCraft.common.tileentity.TileEntityBase;
import pneumaticCraft.proxy.CommonProxy;

public abstract class SemiBlockLogistics
extends SemiBlockBasic {
    protected final Map<ItemStack, Integer> incomingStacks = new HashMap<ItemStack, Integer>();
    protected final Map<FluidStackWrapper, Integer> incomingFluid = new HashMap<FluidStackWrapper, Integer>();
    private final IInventory filters = new InventoryBasic("filters", true, 27);
    @GuiSynced
    private final FluidTank[] fluidFilters = new FluidTank[9];
    @DescSynced
    @GuiSynced
    private boolean invisible;
    private int alpha = 255;

    public SemiBlockLogistics() {
        for (int i = 0; i < this.fluidFilters.length; ++i) {
            this.fluidFilters[i] = new FluidTank(this.canFilterStack() ? 64000 : 1000);
        }
    }

    @Override
    public boolean canPlace() {
        return this.getTileEntity() instanceof IInventory || this.getTileEntity() instanceof IFluidHandler;
    }

    public abstract int getColor();

    public abstract int getPriority();

    public boolean shouldProvideTo(int level) {
        return true;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void update() {
        super.update();
        if (!this.world.field_72995_K) {
            Iterator<Map.Entry<ItemStack, Integer>> iterator = this.incomingStacks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemStack, Integer> entry = iterator.next();
                int counter = entry.getValue();
                if (counter > 10) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(counter + 1);
            }
            Iterator<Map.Entry<FluidStackWrapper, Integer>> it = this.incomingFluid.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<FluidStackWrapper, Integer> entry = it.next();
                int counter = entry.getValue();
                if (counter > 10) {
                    it.remove();
                    continue;
                }
                entry.setValue(counter + 1);
            }
        } else {
            this.alpha = this.invisible && !this.playerIsHoldingLogisticItems() ? Math.max(0, this.alpha - 3) : Math.min(255, this.alpha + 3);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean playerIsHoldingLogisticItems() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_71045_bC();
        return stack != null && (stack.func_77973_b() == Itemss.logisticsConfigurator || stack.func_77973_b() instanceof ItemLogisticsFrame);
    }

    public void informIncomingStack(ItemStack stack) {
        this.incomingStacks.put(stack, 0);
    }

    public void clearIncomingStack(ItemStack stack) {
        this.incomingStacks.remove(stack);
    }

    public void informIncomingStack(FluidStackWrapper stack) {
        this.incomingFluid.put(stack, 0);
    }

    public void clearIncomingStack(FluidStackWrapper stack) {
        this.incomingFluid.remove(stack);
    }

    public int getIncomingFluid(Fluid fluid) {
        int count = 0;
        for (FluidStackWrapper wrapper : this.incomingFluid.keySet()) {
            if (wrapper.stack.getFluid() != fluid) continue;
            count += wrapper.stack.amount;
        }
        return count;
    }

    public int getIncomingItems(ItemStack stack) {
        int count = 0;
        for (ItemStack s : this.incomingStacks.keySet()) {
            if (!this.isItemEqual(s, stack)) continue;
            count += s.field_77994_a;
        }
        return count;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        TileEntityBase.writeInventoryToNBT(tag, this.filters, "filters");
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.fluidFilters.length; ++i) {
            FluidTank filter = this.fluidFilters[i];
            if (filter.getFluid() == null) continue;
            NBTTagCompound t = new NBTTagCompound();
            t.func_74768_a("index", i);
            filter.writeToNBT(t);
            tagList.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("fluidFilters", (NBTBase)tagList);
        tag.func_74757_a("invisible", this.invisible);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        TileEntityBase.readInventoryFromNBT(tag, this.filters, "filters");
        NBTTagList tagList = tag.func_150295_c("fluidFilters", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.fluidFilters[tagList.func_150305_b(i).func_74762_e("index")].readFromNBT(tagList.func_150305_b(i));
        }
        this.invisible = tag.func_74767_n("invisible");
    }

    public void setFilter(int filterIndex, FluidStack stack) {
        this.fluidFilters[filterIndex].setFluid(stack);
    }

    public IFluidTank getTankFilter(int filterIndex) {
        return this.fluidFilters[filterIndex];
    }

    public IInventory getFilters() {
        return this.filters;
    }

    @Override
    public void addDrops(List<ItemStack> drops) {
        super.addDrops(drops);
        boolean shouldAddTag = false;
        for (int i = 0; i < this.filters.func_70302_i_(); ++i) {
            if (this.filters.func_70301_a(i) == null) continue;
            shouldAddTag = true;
            break;
        }
        for (FluidTank fluidFilter : this.fluidFilters) {
            if (fluidFilter.getFluidAmount() <= 0) continue;
            shouldAddTag = true;
            break;
        }
        if (this.invisible) {
            shouldAddTag = true;
        }
        if (shouldAddTag) {
            ItemStack drop = drops.get(0);
            NBTTagCompound tag = new NBTTagCompound();
            this.writeToNBT(tag);
            drop.func_77982_d(tag);
        }
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            this.readFromNBT(tag);
        }
    }

    @Override
    public boolean onRightClickWithConfigurator(EntityPlayer player) {
        if (this.getGuiID() != null) {
            NetworkHandler.sendTo(new PacketSetSemiBlock(this.pos, this), (EntityPlayerMP)player);
            player.openGui((Object)PneumaticCraft.instance, this.getGuiID().ordinal(), this.world, this.pos.field_151329_a, this.pos.field_151327_b, this.pos.field_151328_c);
        }
        return true;
    }

    public CommonProxy.EnumGuiId getGuiID() {
        return null;
    }

    public boolean canFilterStack() {
        return false;
    }

    protected boolean isItemEqual(ItemStack s1, ItemStack s2) {
        return s1.func_77969_a(s2);
    }

    protected boolean passesFilter(ItemStack stack) {
        boolean hasStack = false;
        for (int i = 0; i < this.filters.func_70302_i_(); ++i) {
            ItemStack s = this.filters.func_70301_a(i);
            if (s == null) continue;
            if (this.isItemEqual(s, stack)) {
                return true;
            }
            hasStack = true;
        }
        return !hasStack;
    }

    protected boolean passesFilter(Fluid fluid) {
        boolean hasFilter = false;
        for (FluidTank filter : this.fluidFilters) {
            if (filter.getFluidAmount() <= 0) continue;
            if (filter.getFluid().getFluid() == fluid) {
                return true;
            }
            hasFilter = true;
        }
        return !hasFilter;
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        if (guiID == 9) {
            this.invisible = !this.invisible;
        }
    }

    @Override
    public void addWailaTooltip(List<String> curInfo, NBTTagCompound tag) {
        super.addWailaTooltip(curInfo, tag);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.addDrops(drops);
        ((ItemStack)drops.get(0)).func_77982_d(tag);
        ItemLogisticsFrame.addTooltip((ItemStack)drops.get(0), PneumaticCraft.proxy.getPlayer(), curInfo, true);
    }

    @Override
    public void addWailaInfoToTag(NBTTagCompound tag) {
        this.writeToNBT(tag);
    }

    public static class FluidStackWrapper {
        public final FluidStack stack;

        public FluidStackWrapper(FluidStack stack) {
            this.stack = stack;
        }
    }
}

