/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.remote;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class GlobalVariableManager
extends WorldSavedData {
    public static final String DATA_KEY = "PneumaticCraftGlobalVariables";
    private static GlobalVariableManager CLIENT_INSTANCE = new GlobalVariableManager("PneumaticCraftGlobalVariables");
    private final Map<String, ChunkPosition> globalVars = new HashMap<String, ChunkPosition>();
    private final Map<String, ItemStack> globalItemVars = new HashMap<String, ItemStack>();
    public static World overworld;

    public static GlobalVariableManager getInstance() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return CLIENT_INSTANCE;
        }
        if (overworld != null) {
            GlobalVariableManager manager = (GlobalVariableManager)overworld.func_72943_a(GlobalVariableManager.class, DATA_KEY);
            if (manager == null) {
                manager = new GlobalVariableManager(DATA_KEY);
                overworld.func_72823_a(DATA_KEY, (WorldSavedData)manager);
            }
            return manager;
        }
        throw new IllegalStateException("Overworld not initialized");
    }

    public void set(String varName, boolean value) {
        this.set(varName, value ? 1 : 0);
    }

    public void set(String varName, int value) {
        this.set(varName, value, 0, 0);
    }

    public void set(String varName, int x, int y, int z) {
        this.set(varName, new ChunkPosition(x, y, z));
    }

    public void set(String varName, ChunkPosition pos) {
        this.globalVars.put(varName, pos);
        this.save();
    }

    public void set(String varName, ItemStack item) {
        this.globalItemVars.put(varName, item);
        this.save();
    }

    private void save() {
        this.func_76185_a();
    }

    public boolean getBoolean(String varName) {
        return this.getInteger(varName) != 0;
    }

    public int getInteger(String varName) {
        return this.getPos((String)varName).field_151329_a;
    }

    public ChunkPosition getPos(String varName) {
        ChunkPosition pos = this.globalVars.get(varName);
        return pos != null ? pos : new ChunkPosition(0, 0, 0);
    }

    public ItemStack getItem(String varName) {
        return this.globalItemVars.get(varName);
    }

    public GlobalVariableManager(String dataKey) {
        super(dataKey);
    }

    public void func_76184_a(NBTTagCompound tag) {
        this.globalVars.clear();
        NBTTagList list = tag.func_150295_c("globalVars", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            this.globalVars.put(t.func_74779_i("varName"), new ChunkPosition(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z")));
        }
        GlobalVariableManager.readItemVars(tag, this.globalItemVars);
    }

    public static void readItemVars(NBTTagCompound tag, Map<String, ItemStack> map) {
        map.clear();
        NBTTagList list = tag.func_150295_c("globalItemVars", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            map.put(t.func_74779_i("varName"), ItemStack.func_77949_a((NBTTagCompound)t.func_74775_l("item")));
        }
    }

    public void func_76187_b(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, ChunkPosition> entry : this.globalVars.entrySet()) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74778_a("varName", entry.getKey());
            ChunkPosition pos = entry.getValue();
            t.func_74768_a("x", pos.field_151329_a);
            t.func_74768_a("y", pos.field_151327_b);
            t.func_74768_a("z", pos.field_151328_c);
            list.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("globalVars", (NBTBase)list);
        this.writeItemVars(tag, this.globalItemVars);
    }

    public void writeItemVars(NBTTagCompound tag, Map<String, ItemStack> map) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, ItemStack> entry : this.globalItemVars.entrySet()) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74778_a("varName", entry.getKey());
            NBTTagCompound itemTag = new NBTTagCompound();
            entry.getValue().func_77955_b(itemTag);
            t.func_74782_a("item", (NBTBase)itemTag);
            list.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("globalItemVars", (NBTBase)list);
    }

    public String[] getAllActiveVariableNames() {
        HashSet<String> varNames = new HashSet<String>();
        varNames.addAll(this.globalVars.keySet());
        varNames.addAll(this.globalItemVars.keySet());
        return varNames.toArray(new String[varNames.size()]);
    }
}

