/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.recipes.programs;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import pneumaticCraft.api.recipe.AssemblyRecipe;
import pneumaticCraft.common.tileentity.TileEntityAssemblyController;
import pneumaticCraft.common.tileentity.TileEntityAssemblyDrill;
import pneumaticCraft.common.tileentity.TileEntityAssemblyIOUnit;
import pneumaticCraft.common.tileentity.TileEntityAssemblyLaser;
import pneumaticCraft.common.tileentity.TileEntityAssemblyPlatform;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public abstract class AssemblyProgram {
    public EnumTubeProblem curProblem = EnumTubeProblem.NO_PROBLEM;

    public abstract EnumMachine[] getRequiredMachines();

    public abstract boolean executeStep(TileEntityAssemblyController var1, TileEntityAssemblyPlatform var2, TileEntityAssemblyIOUnit var3, TileEntityAssemblyIOUnit var4, TileEntityAssemblyDrill var5, TileEntityAssemblyLaser var6);

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract List<AssemblyRecipe> getRecipeList();

    public void addProgramProblem(List<String> problemList) {
        switch (this.curProblem) {
            case NO_INPUT: {
                problemList.addAll(PneumaticCraftUtils.convertStringIntoList(EnumChatFormatting.GRAY + "The input IO Unit can't find an inventory with a Block of Compressed Iron.", 26));
                problemList.addAll(PneumaticCraftUtils.convertStringIntoList(EnumChatFormatting.BLACK + "Place an inventory with a Block of Compressed Iron surrounding the IO Unit.", 26));
                break;
            }
            case NO_OUTPUT: {
                problemList.addAll(PneumaticCraftUtils.convertStringIntoList(EnumChatFormatting.GRAY + "The output IO Unit can't find an inventory to place the output in.", 26));
                problemList.addAll(PneumaticCraftUtils.convertStringIntoList(EnumChatFormatting.BLACK + "Place an inventory / make space in a connected inventory.", 26));
            }
        }
    }

    public static boolean isValidInput(AssemblyRecipe recipe, ItemStack input) {
        return input != null && (input.func_77969_a(recipe.getInput()) || PneumaticCraftUtils.isSameOreDictStack(input, recipe.getInput())) && input.field_77994_a == recipe.getInput().field_77994_a;
    }

    public static enum EnumMachine {
        PLATFORM,
        DRILL,
        LASER,
        IO_UNIT_EXPORT,
        IO_UNIT_IMPORT;

    }

    public static enum EnumTubeProblem {
        NO_PROBLEM,
        NO_INPUT,
        NO_OUTPUT;

    }
}

