/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.recipes;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeFluid
implements IRecipe {
    private final ShapedOreRecipe recipe;
    private final int fluidIndex;
    private final FluidStack fluidStack;
    private final ItemStack originalStack;

    public RecipeFluid(ShapedOreRecipe recipe, int fluidIndex) {
        this.recipe = recipe;
        this.originalStack = (ItemStack)recipe.getInput()[fluidIndex];
        this.fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.originalStack);
        if (this.fluidStack == null) {
            throw new IllegalArgumentException("Recipe doesn't have fluid item at index " + fluidIndex + ". Item: " + this.originalStack);
        }
        this.fluidIndex = fluidIndex;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (this.fluidIndex >= inv.func_70302_i_()) {
            return false;
        }
        ItemStack stack = inv.func_70301_a(this.fluidIndex);
        FluidStack otherFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (otherFluid != null && otherFluid.isFluidEqual(this.fluidStack) && otherFluid.amount == this.fluidStack.amount) {
            this.recipe.getInput()[this.fluidIndex] = stack.func_77946_l();
            boolean matches = this.recipe.func_77569_a(inv, world);
            this.recipe.getInput()[this.fluidIndex] = this.originalStack;
            return matches;
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.recipe.func_77572_b(inv);
    }

    public int func_77570_a() {
        return this.recipe.func_77570_a();
    }

    public ItemStack func_77571_b() {
        return this.recipe.func_77571_b();
    }
}

