/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.recipes;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.api.recipe.IThermopneumaticProcessingPlantRecipe;
import pneumaticCraft.common.fluid.Fluids;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class BasicThermopneumaticProcessingPlantRecipe
implements IThermopneumaticProcessingPlantRecipe {
    private final FluidStack inputLiquid;
    private final FluidStack outputLiquid;
    private final ItemStack inputItem;
    private final float requiredPressure;
    private final double requiredTemperature;

    public BasicThermopneumaticProcessingPlantRecipe(FluidStack inputLiquid, ItemStack inputItem, FluidStack outputLiquid, double requiredTemperature, float requiredPressure) {
        this.inputItem = inputItem;
        this.inputLiquid = inputLiquid;
        this.outputLiquid = outputLiquid;
        this.requiredTemperature = requiredTemperature;
        this.requiredPressure = requiredPressure;
    }

    @Override
    public boolean isValidRecipe(FluidStack inputTank, ItemStack inputItem) {
        if (this.inputLiquid != null) {
            if (inputTank == null) {
                return false;
            }
            if (!Fluids.areFluidsEqual(inputTank.getFluid(), this.inputLiquid.getFluid())) {
                return false;
            }
            if (inputTank.amount < this.inputLiquid.amount) {
                return false;
            }
        }
        if (this.inputItem != null) {
            if (inputItem == null) {
                return false;
            }
            if (!inputItem.func_77969_a(this.inputItem) && !PneumaticCraftUtils.isSameOreDictStack(inputItem, this.inputItem)) {
                return false;
            }
            if (inputItem.field_77994_a < this.inputItem.field_77994_a) {
                return false;
            }
        }
        return true;
    }

    @Override
    public FluidStack getRecipeOutput(FluidStack inputTank, ItemStack inputItem) {
        return this.outputLiquid;
    }

    @Override
    public void useRecipeItems(FluidStack inputTank, ItemStack inputItem) {
        if (this.inputLiquid != null) {
            inputTank.amount -= this.inputLiquid.amount;
        }
        if (this.inputItem != null) {
            inputItem.field_77994_a -= this.inputItem.field_77994_a;
        }
    }

    @Override
    public double getRequiredTemperature(FluidStack inputTank, ItemStack inputItem) {
        return this.requiredTemperature;
    }

    @Override
    public float getRequiredPressure(FluidStack inputTank, ItemStack inputItem) {
        return this.requiredPressure;
    }

    @Override
    public double heatUsed(FluidStack inputTank, ItemStack inputItem) {
        return (this.requiredTemperature - 295.0) / 10.0;
    }

    @Override
    public int airUsed(FluidStack inputTank, ItemStack inputItem) {
        return (int)(this.requiredPressure * 50.0f);
    }

    public FluidStack getInputLiquid() {
        return this.inputLiquid;
    }

    public FluidStack getOutputLiquid() {
        return this.outputLiquid;
    }

    public ItemStack getInputItem() {
        return this.inputItem;
    }
}

