/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.recipes;

import com.google.gson.JsonObject;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.common.config.AmadronOfferSettings;
import pneumaticCraft.common.inventory.ContainerAmadron;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketAmadronTradeNotifyDeal;
import pneumaticCraft.common.network.PacketSyncAmadronOffers;
import pneumaticCraft.common.recipes.AmadronOffer;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class AmadronOfferCustom
extends AmadronOffer {
    private final String offeringPlayerName;
    private String offeringPlayerId;
    private int providingDimensionId;
    private int returningDimensionId;
    private ChunkPosition providingPosition;
    private ChunkPosition returningPosition;
    private int inStock;
    private int maxTrades = -1;
    private int pendingPayments;
    private TileEntity cachedInput;
    private TileEntity cachedOutput;

    public AmadronOfferCustom(Object input, Object output, EntityPlayer offeringPlayer) {
        this(input, output, offeringPlayer.func_146103_bH().getName(), offeringPlayer.func_146103_bH().getId().toString());
    }

    public AmadronOfferCustom(Object input, Object output, String playerName, String playerId) {
        super(input, output);
        this.offeringPlayerName = playerName;
        this.offeringPlayerId = playerId;
    }

    public AmadronOfferCustom setProvidingPosition(ChunkPosition pos, int dimensionId) {
        this.providingPosition = pos;
        this.providingDimensionId = dimensionId;
        this.cachedInput = null;
        return this;
    }

    public AmadronOfferCustom setReturningPosition(ChunkPosition pos, int dimensionId) {
        this.returningPosition = pos;
        this.returningDimensionId = dimensionId;
        this.cachedOutput = null;
        return this;
    }

    public AmadronOfferCustom invert() {
        Object temp = this.input;
        this.input = this.output;
        this.output = temp;
        return this;
    }

    public AmadronOfferCustom copy() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return AmadronOfferCustom.loadFromNBT(tag);
    }

    public void updatePlayerId() {
        EntityPlayer player = PneumaticCraftUtils.getPlayerFromName(this.offeringPlayerName);
        if (player != null) {
            this.offeringPlayerId = player.func_146103_bH().getId().toString();
        }
    }

    public void addStock(int stock) {
        this.inStock += stock;
    }

    @Override
    public int getStock() {
        return this.inStock;
    }

    public void addPayment(int payment) {
        this.pendingPayments += payment;
    }

    public void setMaxTrades(int maxTrades) {
        this.maxTrades = maxTrades;
    }

    @Override
    public String getVendor() {
        return this.offeringPlayerName;
    }

    public String getPlayerId() {
        return this.offeringPlayerId;
    }

    @Override
    public void onTrade(int tradingAmount, String buyingPlayer) {
        EntityPlayer player = PneumaticCraftUtils.getPlayerFromId(this.offeringPlayerId);
        if (player != null && AmadronOfferSettings.notifyOfDealMade) {
            NetworkHandler.sendTo(new PacketAmadronTradeNotifyDeal(this, tradingAmount, buyingPlayer), (EntityPlayerMP)player);
        }
    }

    public void payout() {
        TileEntity returning = this.getReturningTileEntity();
        TileEntity provider = this.getProvidingTileEntity();
        if (this.pendingPayments > 0) {
            int paying = Math.min(this.pendingPayments, 50);
            if ((paying = ContainerAmadron.capShoppingAmount(this, paying, provider instanceof IInventory ? (IInventory)provider : null, returning instanceof IInventory ? (IInventory)returning : null, provider instanceof IFluidHandler ? (IFluidHandler)provider : null, returning instanceof IFluidHandler ? (IFluidHandler)returning : null, null)) > 0) {
                this.pendingPayments -= paying;
                if (this.getInput() instanceof ItemStack) {
                    ItemStack stack;
                    ItemStack deliveringItems = (ItemStack)this.getInput();
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int amount = deliveringItems.field_77994_a * paying; amount > 0; amount -= stack.field_77994_a) {
                        stack = deliveringItems.func_77946_l();
                        stack.field_77994_a = Math.min(amount, stack.func_77976_d());
                        stacks.add(stack);
                    }
                    PneumaticRegistry.getInstance().deliverItemsAmazonStyle(returning.func_145831_w(), returning.field_145851_c, returning.field_145848_d, returning.field_145849_e, stacks.toArray(new ItemStack[stacks.size()]));
                } else {
                    FluidStack deliveringFluid = ((FluidStack)this.getInput()).copy();
                    deliveringFluid.amount *= paying;
                    PneumaticRegistry.getInstance().deliverFluidAmazonStyle(returning.func_145831_w(), returning.field_145851_c, returning.field_145848_d, returning.field_145849_e, deliveringFluid);
                }
            }
        }
    }

    public void returnStock() {
        TileEntity provider = this.getProvidingTileEntity();
        TileEntity returning = this.getReturningTileEntity();
        this.invert();
        while (this.inStock > 0) {
            int stock = Math.min(this.inStock, 50);
            if ((stock = ContainerAmadron.capShoppingAmount(this, stock, returning instanceof IInventory ? (IInventory)returning : null, provider instanceof IInventory ? (IInventory)provider : null, returning instanceof IFluidHandler ? (IFluidHandler)returning : null, provider instanceof IFluidHandler ? (IFluidHandler)provider : null, null)) <= 0) break;
            this.inStock -= stock;
            if (this.getInput() instanceof ItemStack) {
                ItemStack stack;
                ItemStack deliveringItems = (ItemStack)this.getInput();
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int amount = deliveringItems.field_77994_a * stock; amount > 0; amount -= stack.field_77994_a) {
                    stack = deliveringItems.func_77946_l();
                    stack.field_77994_a = Math.min(amount, stack.func_77976_d());
                    stacks.add(stack);
                }
                PneumaticRegistry.getInstance().deliverItemsAmazonStyle(provider.func_145831_w(), provider.field_145851_c, provider.field_145848_d, provider.field_145849_e, stacks.toArray(new ItemStack[stacks.size()]));
                continue;
            }
            FluidStack deliveringFluid = ((FluidStack)this.getInput()).copy();
            deliveringFluid.amount *= stock;
            PneumaticRegistry.getInstance().deliverFluidAmazonStyle(provider.func_145831_w(), provider.field_145851_c, provider.field_145848_d, provider.field_145849_e, deliveringFluid);
        }
    }

    public TileEntity getProvidingTileEntity() {
        if ((this.cachedInput == null || this.cachedInput.func_145837_r()) && this.providingPosition != null) {
            this.cachedInput = PneumaticCraftUtils.getTileEntity(this.providingPosition, this.providingDimensionId);
        }
        return this.cachedInput;
    }

    public TileEntity getReturningTileEntity() {
        if ((this.cachedOutput == null || this.cachedOutput.func_145837_r()) && this.returningPosition != null) {
            this.cachedOutput = PneumaticCraftUtils.getTileEntity(this.returningPosition, this.returningDimensionId);
        }
        return this.cachedOutput;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74778_a("offeringPlayerId", this.offeringPlayerId);
        tag.func_74778_a("offeringPlayerName", this.offeringPlayerName);
        tag.func_74768_a("inStock", this.inStock);
        tag.func_74768_a("maxTrades", this.maxTrades);
        tag.func_74768_a("pendingPayments", this.pendingPayments);
        if (this.providingPosition != null) {
            tag.func_74768_a("providingDimensionId", this.providingDimensionId);
            tag.func_74768_a("providingX", this.providingPosition.field_151329_a);
            tag.func_74768_a("providingY", this.providingPosition.field_151327_b);
            tag.func_74768_a("providingZ", this.providingPosition.field_151328_c);
        }
        if (this.returningPosition != null) {
            tag.func_74768_a("returningDimensionId", this.returningDimensionId);
            tag.func_74768_a("returningX", this.returningPosition.field_151329_a);
            tag.func_74768_a("returningY", this.returningPosition.field_151327_b);
            tag.func_74768_a("returningZ", this.returningPosition.field_151328_c);
        }
    }

    public static AmadronOfferCustom loadFromNBT(NBTTagCompound tag) {
        AmadronOffer offer = AmadronOffer.loadFromNBT(tag);
        AmadronOfferCustom custom = new AmadronOfferCustom(offer.getInput(), offer.getOutput(), tag.func_74779_i("offeringPlayerName"), tag.func_74779_i("offeringPlayerId"));
        custom.inStock = tag.func_74762_e("inStock");
        custom.maxTrades = tag.func_74762_e("maxTrades");
        custom.pendingPayments = tag.func_74762_e("pendingPayments");
        if (tag.func_74764_b("providingDimensionId")) {
            custom.setProvidingPosition(new ChunkPosition(tag.func_74762_e("providingX"), tag.func_74762_e("providingY"), tag.func_74762_e("providingZ")), tag.func_74762_e("providingDimensionId"));
        }
        if (tag.func_74764_b("returningDimensionId")) {
            custom.setReturningPosition(new ChunkPosition(tag.func_74762_e("returningX"), tag.func_74762_e("returningY"), tag.func_74762_e("returningZ")), tag.func_74762_e("returningDimensionId"));
        }
        return custom;
    }

    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.offeringPlayerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.offeringPlayerId);
        if (this.providingPosition != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.providingPosition.field_151329_a);
            buf.writeInt(this.providingPosition.field_151327_b);
            buf.writeInt(this.providingPosition.field_151328_c);
            buf.writeInt(this.providingDimensionId);
        } else {
            buf.writeBoolean(false);
        }
        if (this.returningPosition != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.returningPosition.field_151329_a);
            buf.writeInt(this.returningPosition.field_151327_b);
            buf.writeInt(this.returningPosition.field_151328_c);
            buf.writeInt(this.returningDimensionId);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.inStock);
        buf.writeInt(this.maxTrades);
        buf.writeInt(this.pendingPayments);
    }

    public static AmadronOfferCustom loadFromBuf(ByteBuf buf) {
        AmadronOfferCustom offer = new AmadronOfferCustom(PacketSyncAmadronOffers.getFluidOrItemStack(buf), PacketSyncAmadronOffers.getFluidOrItemStack(buf), ByteBufUtils.readUTF8String((ByteBuf)buf), ByteBufUtils.readUTF8String((ByteBuf)buf));
        if (buf.readBoolean()) {
            offer.setProvidingPosition(new ChunkPosition(buf.readInt(), buf.readInt(), buf.readInt()), buf.readInt());
        }
        if (buf.readBoolean()) {
            offer.setReturningPosition(new ChunkPosition(buf.readInt(), buf.readInt(), buf.readInt()), buf.readInt());
        }
        offer.inStock = buf.readInt();
        offer.maxTrades = buf.readInt();
        offer.pendingPayments = buf.readInt();
        return offer;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("offeringPlayerName", this.offeringPlayerName);
        json.addProperty("offeringPlayerId", this.offeringPlayerId);
        json.addProperty("inStock", (Number)this.inStock);
        json.addProperty("maxTrades", (Number)this.maxTrades);
        json.addProperty("pendingPayments", (Number)this.pendingPayments);
        if (this.providingPosition != null) {
            json.addProperty("providingDimensionId", (Number)this.providingDimensionId);
            json.addProperty("providingX", (Number)this.providingPosition.field_151329_a);
            json.addProperty("providingY", (Number)this.providingPosition.field_151327_b);
            json.addProperty("providingZ", (Number)this.providingPosition.field_151328_c);
        }
        if (this.returningPosition != null) {
            json.addProperty("returningDimensionId", (Number)this.returningDimensionId);
            json.addProperty("returningX", (Number)this.returningPosition.field_151329_a);
            json.addProperty("returningY", (Number)this.returningPosition.field_151327_b);
            json.addProperty("returningZ", (Number)this.returningPosition.field_151328_c);
        }
        return json;
    }

    public static AmadronOfferCustom fromJson(JsonObject json) {
        AmadronOffer offer = AmadronOffer.fromJson(json);
        if (offer != null) {
            AmadronOfferCustom custom = new AmadronOfferCustom(offer.input, offer.output, json.get("offeringPlayerName").getAsString(), json.get("offeringPlayerId").getAsString());
            custom.inStock = json.get("inStock").getAsInt();
            custom.maxTrades = json.get("maxTrades").getAsInt();
            custom.pendingPayments = json.get("pendingPayments").getAsInt();
            if (json.has("providingDimensionId")) {
                custom.providingDimensionId = json.get("providingDimensionId").getAsInt();
                custom.providingPosition = new ChunkPosition(json.get("providingX").getAsInt(), json.get("providingY").getAsInt(), json.get("providingZ").getAsInt());
            }
            if (json.has("returningDimensionId")) {
                custom.returningDimensionId = json.get("returningDimensionId").getAsInt();
                custom.returningPosition = new ChunkPosition(json.get("returningX").getAsInt(), json.get("returningY").getAsInt(), json.get("returningZ").getAsInt());
            }
            return custom;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AmadronOfferCustom) {
            AmadronOfferCustom offer = (AmadronOfferCustom)o;
            return super.equals(o) && offer.offeringPlayerId.equals(this.offeringPlayerId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.offeringPlayerId.hashCode();
    }
}

