/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetPlace;
import pneumaticCraft.common.ai.DroneAIPlace;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.IBlockOrdered;
import pneumaticCraft.common.progwidgets.IMaxActions;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.progwidgets.ProgWidgetDigAndPlace;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;
import pneumaticCraft.lib.Textures;

public class ProgWidgetPlace
extends ProgWidgetDigAndPlace
implements ISidedWidget {
    public ForgeDirection placeDir = ForgeDirection.DOWN;

    public ProgWidgetPlace() {
        super(IBlockOrdered.EnumOrder.LOW_TO_HIGH);
    }

    @Override
    public void setSides(boolean[] sides) {
        this.placeDir = ProgWidgetPlace.getDirForSides(sides);
    }

    @Override
    public boolean[] getSides() {
        return ProgWidgetPlace.getSidesFromDir(this.placeDir);
    }

    public static ForgeDirection getDirForSides(boolean[] sides) {
        for (int i = 0; i < sides.length; ++i) {
            if (!sides[i]) continue;
            return ForgeDirection.getOrientation((int)i);
        }
        Log.error("[ProgWidgetPlace] Sides boolean array empty!");
        return ForgeDirection.DOWN;
    }

    public static boolean[] getSidesFromDir(ForgeDirection dir) {
        boolean[] dirs = new boolean[6];
        dirs[dir.ordinal()] = true;
        return dirs;
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add("Placing direction: " + PneumaticCraftUtils.getOrientationName(this.placeDir));
    }

    @Override
    public String getWidgetString() {
        return "place";
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_PLACE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetPlace<ProgWidgetPlace>(this, guiProgrammer);
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIPlace(drone, (ProgWidgetAreaItemBase)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("dir", this.placeDir.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.placeDir = ForgeDirection.getOrientation((int)tag.func_74762_e("dir"));
    }

    @Override
    public int getCraftingColorIndex() {
        return 11;
    }
}

