/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetLiquidFilter;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidget;
import pneumaticCraft.lib.Textures;

public class ProgWidgetLiquidFilter
extends ProgWidget {
    private Fluid fluid;

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.fluid == null) {
            curInfo.add("gui.progWidget.liquidFilter.error.noLiquid");
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return ProgWidgetLiquidFilter.class;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetLiquidFilter.class};
    }

    @Override
    public String getWidgetString() {
        return "liquidFilter";
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_LIQUID_FILTER;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.fluid = FluidRegistry.getFluid((String)tag.func_74779_i("fluid"));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.fluid != null) {
            tag.func_74778_a("fluid", this.fluid.getName());
        }
    }

    public boolean isLiquidValid(Fluid fluid) {
        return this.fluid == null || fluid == this.fluid;
    }

    public static boolean isLiquidValid(Fluid fluid, IProgWidget mainWidget, int filterIndex) {
        ProgWidgetLiquidFilter widget = (ProgWidgetLiquidFilter)mainWidget.getConnectedParameters()[mainWidget.getParameters().length + filterIndex];
        while (widget != null) {
            if (!widget.isLiquidValid(fluid)) {
                return false;
            }
            widget = (ProgWidgetLiquidFilter)widget.getConnectedParameters()[0];
        }
        widget = (ProgWidgetLiquidFilter)mainWidget.getConnectedParameters()[filterIndex];
        if (widget == null) {
            return true;
        }
        while (widget != null) {
            if (widget.isLiquidValid(fluid)) {
                return true;
            }
            widget = (ProgWidgetLiquidFilter)widget.getConnectedParameters()[0];
        }
        return false;
    }

    public static boolean isLiquidValid(Fluid fluid, List<ProgWidgetLiquidFilter> whitelist, List<ProgWidgetLiquidFilter> blacklist) {
        for (ProgWidgetLiquidFilter filter : blacklist) {
            if (filter.isLiquidValid(fluid)) continue;
            return false;
        }
        if (whitelist.size() == 0) {
            return true;
        }
        for (ProgWidgetLiquidFilter filter : whitelist) {
            if (!filter.isLiquidValid(fluid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public String getExtraStringInfo() {
        return this.fluid != null ? this.fluid.getLocalizedName(new FluidStack(this.fluid, 1)) : I18n.func_135052_a((String)"gui.progWidget.liquidFilter.noFluid", (Object[])new Object[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetLiquidFilter(this, guiProgrammer);
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public int getCraftingColorIndex() {
        return 1;
    }
}

