/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetItemFilter;
import pneumaticCraft.common.ai.DroneAIManager;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.IVariableWidget;
import pneumaticCraft.common.progwidgets.ProgWidget;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Textures;

public class ProgWidgetItemFilter
extends ProgWidget
implements IVariableWidget {
    private ItemStack filter;
    public boolean useMetadata = true;
    public boolean useNBT;
    public boolean useOreDict;
    public boolean useModSimilarity;
    public int specificMeta;
    private DroneAIManager aiManager;
    private String variable = "";
    @SideOnly(value=Side.CLIENT)
    private static RenderItem itemRender;

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.equals("") && this.filter == null) {
            curInfo.add("gui.progWidget.itemFilter.error.noFilter");
        }
    }

    @Override
    public void renderExtraInfo() {
        if (this.variable.equals("")) {
            if (this.filter != null) {
                ProgWidgetItemFilter.drawItemStack(this.filter, 10, 2, "");
            }
        } else {
            super.renderExtraInfo();
        }
    }

    @Override
    public String getExtraStringInfo() {
        return "\"" + this.variable + "\"";
    }

    public ItemStack getFilter() {
        return this.variable.equals("") ? this.filter : (this.aiManager != null ? this.aiManager.getStack(this.variable) : null);
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
    }

    public static void drawItemStack(ItemStack p_146982_1_, int p_146982_2_, int p_146982_3_, String p_146982_4_) {
        RenderHelper.func_74518_a();
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        if (itemRender == null) {
            itemRender = new RenderItem();
        }
        ProgWidgetItemFilter.itemRender.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (p_146982_1_ != null) {
            font = p_146982_1_.func_77973_b().getFontRenderer(p_146982_1_);
        }
        if (font == null) {
            font = mc.field_71466_p;
        }
        itemRender.func_82406_b(font, mc.func_110434_K(), p_146982_1_, p_146982_2_, p_146982_3_);
        itemRender.func_94148_a(font, mc.func_110434_K(), p_146982_1_, p_146982_2_, p_146982_3_, p_146982_4_);
        GL11.glPopMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.filter != null) {
            curTooltip.add("Current filter:");
            curTooltip.add(this.filter.func_82833_r());
            if (this.useOreDict) {
                curTooltip.add("Using Ore Dictionary");
            } else if (this.useModSimilarity) {
                curTooltip.add("Using Mod similarity");
            } else {
                curTooltip.add((this.useMetadata ? "Using" : "Ignoring") + " metadata / damage values");
                curTooltip.add((this.useNBT ? "Using" : "Ignoring") + " NBT tags");
            }
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return ProgWidgetItemFilter.class;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetItemFilter.class};
    }

    @Override
    public String getWidgetString() {
        return "itemFilter";
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ITEM_FILTER;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.filter != null) {
            ProgWidgetItemFilter.saveItemStackByName(this.filter, tag);
        }
        tag.func_74757_a("useMetadata", this.useMetadata);
        tag.func_74757_a("useNBT", this.useNBT);
        tag.func_74757_a("useOreDict", this.useOreDict);
        tag.func_74757_a("useModSimilarity", this.useModSimilarity);
        tag.func_74768_a("specificMeta", this.specificMeta);
        tag.func_74778_a("variable", this.variable);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.filter = tag.func_74781_a("id") instanceof NBTBase.NBTPrimitive ? ItemStack.func_77949_a((NBTTagCompound)tag) : ProgWidgetItemFilter.loadItemStackByName(tag);
        this.useMetadata = tag.func_74767_n("useMetadata");
        this.useNBT = tag.func_74767_n("useNBT");
        this.useOreDict = tag.func_74767_n("useOreDict");
        this.useModSimilarity = tag.func_74767_n("useModSimilarity");
        this.specificMeta = tag.func_74762_e("specificMeta");
        this.variable = tag.func_74779_i("variable");
    }

    private static void saveItemStackByName(ItemStack stack, NBTTagCompound tag) {
        tag.func_74778_a("id", GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b()));
        tag.func_74774_a("Count", (byte)stack.field_77994_a);
        tag.func_74777_a("Damage", (short)stack.func_77960_j());
        if (stack.func_77942_o()) {
            tag.func_74782_a("tag", (NBTBase)stack.func_77978_p());
        }
    }

    private static ItemStack loadItemStackByName(NBTTagCompound tag) {
        Item item = (Item)GameData.getItemRegistry().func_82594_a(tag.func_74779_i("id"));
        if (item == null) {
            return null;
        }
        ItemStack stack = new ItemStack(item, (int)tag.func_74771_c("Count"), (int)tag.func_74765_d("Damage"));
        if (stack.func_77960_j() < 0) {
            stack.func_77964_b(0);
        }
        if (tag.func_150297_b("tag", 10)) {
            stack.func_77982_d(tag.func_74775_l("tag"));
        }
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetItemFilter(this, guiProgrammer);
    }

    public static boolean isItemValidForFilters(ItemStack item, List<ProgWidgetItemFilter> whitelist, List<ProgWidgetItemFilter> blacklist, int blockMeta) {
        if (blacklist != null) {
            for (ProgWidgetItemFilter black : blacklist) {
                if (!PneumaticCraftUtils.areStacksEqual(black.getFilter(), item, black.useMetadata && blockMeta == -1, black.useNBT, black.useOreDict, black.useModSimilarity) || blockMeta != -1 && black.useMetadata && black.specificMeta != blockMeta) continue;
                return false;
            }
        }
        if (whitelist == null || whitelist.size() == 0) {
            return true;
        }
        for (ProgWidgetItemFilter white : whitelist) {
            if (!PneumaticCraftUtils.areStacksEqual(white.getFilter(), item, white.useMetadata && blockMeta == -1, white.useNBT, white.useOreDict, white.useModSimilarity) || blockMeta != -1 && white.useMetadata && white.specificMeta != blockMeta) continue;
            return true;
        }
        return false;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public int getCraftingColorIndex() {
        return 8;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }
}

