/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetImportExport;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICountWidget;
import pneumaticCraft.common.progwidgets.ICraftingWidget;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetItemFilter;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Textures;

public class ProgWidgetCrafting
extends ProgWidget
implements ICraftingWidget,
ICountWidget {
    private boolean useCount;
    private int count;

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean usingVariables = false;
        for (int y = 0; y < 3; ++y) {
            ProgWidgetItemFilter itemFilter = (ProgWidgetItemFilter)this.getConnectedParameters()[y];
            for (int x = 0; x < 3 && itemFilter != null; ++x) {
                if (!itemFilter.getVariable().equals("")) {
                    usingVariables = true;
                }
                itemFilter = (ProgWidgetItemFilter)itemFilter.getConnectedParameters()[0];
            }
        }
        if (!usingVariables && this.getRecipeResult(PneumaticCraft.proxy.getClientWorld()) == null) {
            curInfo.add("gui.progWidget.crafting.error.noCraftingRecipe");
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return null;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetItemFilter.class, ProgWidgetItemFilter.class, ProgWidgetItemFilter.class};
    }

    @Override
    public String getWidgetString() {
        return "crafting";
    }

    @Override
    public int getCraftingColorIndex() {
        return 5;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CRAFTING;
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public InventoryCrafting getCraftingGrid() {
        InventoryCrafting invCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer p_75145_1_) {
                return false;
            }
        }, 3, 3);
        for (int y = 0; y < 3; ++y) {
            ProgWidgetItemFilter itemFilter = (ProgWidgetItemFilter)this.getConnectedParameters()[y];
            for (int x = 0; x < 3 && itemFilter != null; ++x) {
                invCrafting.func_70299_a(y * 3 + x, itemFilter.getFilter());
                itemFilter = (ProgWidgetItemFilter)itemFilter.getConnectedParameters()[0];
            }
        }
        return invCrafting;
    }

    private ItemStack getRecipeResult(World world) {
        return CraftingManager.func_77594_a().func_82787_a(this.getCraftingGrid(), world);
    }

    public static IRecipe getRecipe(World world, ICraftingWidget widget) {
        InventoryCrafting craftingGrid = widget.getCraftingGrid();
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!recipe.func_77569_a(craftingGrid, world)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void renderExtraInfo() {
        ItemStack recipe = this.getRecipeResult(PneumaticCraft.proxy.getClientWorld());
        if (recipe != null) {
            ProgWidgetItemFilter.drawItemStack(recipe, 8, this.getHeight() / 2 - 8, recipe.field_77994_a + "");
        }
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAICrafting(drone, (ICraftingWidget)((Object)widget));
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("useCount", this.useCount);
        tag.func_74768_a("count", this.count);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.useCount = tag.func_74767_n("useCount");
        this.count = tag.func_74762_e("count");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetImportExport(this, guiProgrammer){

            @Override
            protected boolean showSides() {
                return false;
            }
        };
    }

    public static class DroneAICrafting
    extends EntityAIBase {
        private final ICraftingWidget widget;
        private final IDroneBase drone;

        public DroneAICrafting(IDroneBase drone, ICraftingWidget widget) {
            this.drone = drone;
            this.widget = widget;
        }

        public boolean func_75250_a() {
            IRecipe recipe = ProgWidgetCrafting.getRecipe(this.drone.getWorld(), this.widget);
            if (recipe == null) {
                return false;
            }
            InventoryCrafting craftingGrid = this.widget.getCraftingGrid();
            for (int crafted = 0; !((ICountWidget)((Object)this.widget)).useCount() || crafted < ((ICountWidget)((Object)this.widget)).getCount(); ++crafted) {
                List[] equivalentsList = new List[9];
                for (int i = 0; i < equivalentsList.length; ++i) {
                    ItemStack originalStack = craftingGrid.func_70301_a(i);
                    if (originalStack == null) continue;
                    ArrayList<ItemStack> equivalents = new ArrayList<ItemStack>();
                    for (int j = 0; j < this.drone.getInventory().func_70302_i_(); ++j) {
                        ItemStack droneStack = this.drone.getInventory().func_70301_a(j);
                        if (droneStack == null || droneStack.func_77973_b() != originalStack.func_77973_b() && !PneumaticCraftUtils.isSameOreDictStack(droneStack, originalStack)) continue;
                        equivalents.add(droneStack);
                    }
                    if (equivalents.isEmpty()) {
                        return false;
                    }
                    equivalentsList[i] = equivalents;
                }
                int[] curIndexes = new int[9];
                boolean first = true;
                boolean hasCrafted = false;
                while (first || this.count(curIndexes, equivalentsList)) {
                    first = false;
                    InventoryCrafting craftMatrix = new InventoryCrafting(new Container(){

                        public boolean func_75145_c(EntityPlayer p_75145_1_) {
                            return false;
                        }
                    }, 3, 3);
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack = equivalentsList[i] == null ? null : (ItemStack)equivalentsList[i].get(curIndexes[i]);
                        craftMatrix.func_70299_a(i, stack);
                    }
                    if (!recipe.func_77569_a(craftMatrix, this.drone.getWorld()) || !this.craft(recipe.func_77572_b(craftMatrix), craftMatrix)) continue;
                    hasCrafted = true;
                    break;
                }
                if (hasCrafted) continue;
                return false;
            }
            return false;
        }

        private boolean count(int[] curIndexes, List<ItemStack>[] equivalentsList) {
            for (int i = 0; i < equivalentsList.length; ++i) {
                List<ItemStack> list = equivalentsList[i];
                int n = i;
                curIndexes[n] = curIndexes[n] + 1;
                if (list != null && curIndexes[i] < list.size()) {
                    return true;
                }
                curIndexes[i] = 0;
            }
            return false;
        }

        public boolean craft(ItemStack craftedStack, InventoryCrafting craftMatrix) {
            int i;
            for (i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                int requiredCount = 0;
                ItemStack stack = craftMatrix.func_70301_a(i);
                if (stack == null) continue;
                for (int j = 0; j < craftMatrix.func_70302_i_(); ++j) {
                    if (stack != craftMatrix.func_70301_a(j)) continue;
                    ++requiredCount;
                }
                if (requiredCount <= stack.field_77994_a) continue;
                return false;
            }
            FMLCommonHandler.instance().firePlayerCraftingEvent((EntityPlayer)this.drone.getFakePlayer(), craftedStack, (IInventory)craftMatrix);
            for (i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                ItemStack itemstack1 = craftMatrix.func_70301_a(i);
                if (itemstack1 == null) continue;
                if (itemstack1.func_77973_b().hasContainerItem(itemstack1)) {
                    ItemStack itemstack2 = itemstack1.func_77973_b().getContainerItem(itemstack1);
                    if (itemstack2 != null && itemstack2.func_77984_f() && itemstack2.func_77960_j() > itemstack2.func_77958_k()) {
                        MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent((EntityPlayer)this.drone.getFakePlayer(), itemstack2));
                        continue;
                    }
                    ItemStack remainder = IOHelper.insert(this.drone.getInventory(), itemstack2.func_77946_l(), 0, false);
                    if (remainder != null) {
                        Vec3 pos = this.drone.getPosition();
                        EntityItem item = new EntityItem(this.drone.getWorld(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, remainder);
                        this.drone.getWorld().func_72838_d((Entity)item);
                    }
                }
                --itemstack1.field_77994_a;
            }
            for (i = 0; i < this.drone.getInventory().func_70302_i_(); ++i) {
                ItemStack stack = this.drone.getInventory().func_70301_a(i);
                if (stack == null || stack.field_77994_a > 0) continue;
                this.drone.getInventory().func_70299_a(i, null);
            }
            ItemStack remainder = IOHelper.insert(this.drone.getInventory(), craftedStack, 0, false);
            if (remainder != null) {
                Vec3 pos = this.drone.getPosition();
                EntityItem item = new EntityItem(this.drone.getWorld(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, remainder);
                this.drone.getWorld().func_72838_d((Entity)item);
            }
            return true;
        }
    }
}

