/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkPosition;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetCoordinateOperator;
import pneumaticCraft.common.ai.DroneAIManager;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.IVariableSetWidget;
import pneumaticCraft.common.progwidgets.ProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetCoordinate;

public class ProgWidgetCoordinateOperator
extends ProgWidget
implements IVariableSetWidget {
    private EnumOperator operator = EnumOperator.PLUS_MINUS;
    private String variable = "";
    private DroneAIManager aiManager;

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return null;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetCoordinate.class};
    }

    @Override
    public String getWidgetString() {
        return "coordinateOperator";
    }

    @Override
    public int getCraftingColorIndex() {
        return 8;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.equals("")) {
            curInfo.add("gui.progWidget.general.error.emptyVariable");
        }
        if (this.operator == EnumOperator.MAX_MIN && this.getConnectedParameters()[0] == null && this.getConnectedParameters()[this.getParameters().length] == null) {
            curInfo.add("gui.progWidget.coordinateOperator.noParameter");
        }
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        if (!this.variable.equals("")) {
            ChunkPosition curPos = ProgWidgetCoordinateOperator.calculateCoordinate(this, 0, this.operator);
            this.aiManager.setCoordinate(this.variable, curPos);
        }
        return super.getOutputWidget(drone, allWidgets);
    }

    public static ChunkPosition calculateCoordinate(IProgWidget widget, int argIndex, EnumOperator operator) {
        ChunkPosition curPos = null;
        switch (operator) {
            case MULIPLY_DIVIDE: {
                ChunkPosition pos;
                curPos = new ChunkPosition(1, 1, 1);
                ProgWidgetCoordinate coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new ChunkPosition(curPos.field_151329_a * pos.field_151329_a, curPos.field_151327_b * pos.field_151327_b, curPos.field_151328_c * pos.field_151328_c);
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[widget.getParameters().length + argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    if (pos.field_151329_a != 0 && pos.field_151327_b != 0 && pos.field_151328_c != 0) {
                        curPos = new ChunkPosition(curPos.field_151329_a / pos.field_151329_a, curPos.field_151327_b / pos.field_151327_b, curPos.field_151328_c / pos.field_151328_c);
                    }
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                break;
            }
            case PLUS_MINUS: {
                ChunkPosition pos;
                curPos = new ChunkPosition(0, 0, 0);
                ProgWidgetCoordinate coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new ChunkPosition(curPos.field_151329_a + pos.field_151329_a, curPos.field_151327_b + pos.field_151327_b, curPos.field_151328_c + pos.field_151328_c);
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[widget.getParameters().length + argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new ChunkPosition(curPos.field_151329_a - pos.field_151329_a, curPos.field_151327_b - pos.field_151327_b, curPos.field_151328_c - pos.field_151328_c);
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                break;
            }
            case MAX_MIN: {
                ChunkPosition pos;
                curPos = new ChunkPosition(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                ProgWidgetCoordinate coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new ChunkPosition(Math.max(curPos.field_151329_a, pos.field_151329_a), Math.max(curPos.field_151327_b, pos.field_151327_b), Math.max(curPos.field_151328_c, pos.field_151328_c));
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                if (curPos.equals((Object)new ChunkPosition(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE))) {
                    curPos = new ChunkPosition(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
                }
                coordinateWidget = (ProgWidgetCoordinate)widget.getConnectedParameters()[widget.getParameters().length + argIndex];
                while (coordinateWidget != null) {
                    pos = coordinateWidget.getCoordinate();
                    curPos = new ChunkPosition(Math.min(curPos.field_151329_a, pos.field_151329_a), Math.min(curPos.field_151327_b, pos.field_151327_b), Math.min(curPos.field_151328_c, pos.field_151328_c));
                    coordinateWidget = (ProgWidgetCoordinate)coordinateWidget.getConnectedParameters()[0];
                }
                break;
            }
        }
        return curPos;
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.operator.texture;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74778_a("variable", this.variable);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.variable = tag.func_74779_i("variable");
        byte operatorValue = tag.func_74764_b("multiplyDivide") ? tag.func_74771_c("multiplyDivide") : tag.func_74771_c("operator");
        this.operator = EnumOperator.values()[operatorValue];
    }

    public EnumOperator getOperator() {
        return this.operator;
    }

    public void setOperator(EnumOperator operator) {
        this.operator = operator;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public void setVariable(String variable) {
        this.variable = variable;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetCoordinateOperator(this, guiProgrammer);
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add("Setting variable: \"" + this.variable + "\"");
    }

    @Override
    public String getExtraStringInfo() {
        return "\"" + this.variable + "\"";
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    public static enum EnumOperator {
        PLUS_MINUS("plusMinus"),
        MULIPLY_DIVIDE("multiplyDivide"),
        MAX_MIN("maxMin");

        public ResourceLocation texture;
        private final String name;

        private EnumOperator(String name) {
            this.name = name;
            this.texture = new ResourceLocation("pneumaticcraft:textures/items/progwidgets/coordinateOperation" + name.substring(0, 1).toUpperCase() + name.substring(1) + ".png");
        }

        public String getUnlocalizedName() {
            return "gui.progWidget.coordinateOperator." + this.name;
        }
    }
}

