/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.common.inventory.ContainerPneumaticBase;
import pneumaticCraft.common.inventory.SyncedField;
import pneumaticCraft.common.network.AbstractPacket;

public class PacketUpdateGui
extends AbstractPacket<PacketUpdateGui> {
    private int syncId;
    private Object value;
    private byte type;

    public PacketUpdateGui() {
    }

    public PacketUpdateGui(int syncId, SyncedField syncField) {
        this.syncId = syncId;
        this.value = syncField.getValue();
        this.type = PacketUpdateGui.getType(syncField);
    }

    public static byte getType(SyncedField syncedField) {
        if (syncedField instanceof SyncedField.SyncedInt) {
            return 0;
        }
        if (syncedField instanceof SyncedField.SyncedFloat) {
            return 1;
        }
        if (syncedField instanceof SyncedField.SyncedDouble) {
            return 2;
        }
        if (syncedField instanceof SyncedField.SyncedBoolean) {
            return 3;
        }
        if (syncedField instanceof SyncedField.SyncedString) {
            return 4;
        }
        if (syncedField instanceof SyncedField.SyncedEnum) {
            return 5;
        }
        if (syncedField instanceof SyncedField.SyncedItemStack) {
            return 6;
        }
        if (syncedField instanceof SyncedField.SyncedFluidTank) {
            return 7;
        }
        throw new IllegalArgumentException("Invalid sync type! " + syncedField);
    }

    public static Object readField(ByteBuf buf, int type) {
        switch (type) {
            case 0: {
                return buf.readInt();
            }
            case 1: {
                return Float.valueOf(buf.readFloat());
            }
            case 2: {
                return buf.readDouble();
            }
            case 3: {
                return buf.readBoolean();
            }
            case 4: {
                return ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
            case 5: {
                return buf.readByte();
            }
            case 6: {
                return ByteBufUtils.readItemStack((ByteBuf)buf);
            }
            case 7: {
                if (!buf.readBoolean()) {
                    return null;
                }
                return new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt(), ByteBufUtils.readTag((ByteBuf)buf));
            }
        }
        throw new IllegalArgumentException("Invalid sync type! " + type);
    }

    public static void writeField(ByteBuf buf, Object value, int type) {
        switch (type) {
            case 0: {
                buf.writeInt(((Integer)value).intValue());
                break;
            }
            case 1: {
                buf.writeFloat(((Float)value).floatValue());
                break;
            }
            case 2: {
                buf.writeDouble(((Double)value).doubleValue());
                break;
            }
            case 3: {
                buf.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 4: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)value));
                break;
            }
            case 5: {
                buf.writeByte((int)((Byte)value).byteValue());
                break;
            }
            case 6: {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)value));
                break;
            }
            case 7: {
                buf.writeBoolean(value != null);
                if (value == null) break;
                FluidStack stack = (FluidStack)value;
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)stack.getFluid().getName());
                buf.writeInt(stack.amount);
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.tag);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.syncId = buf.readInt();
        this.type = buf.readByte();
        this.value = PacketUpdateGui.readField(buf, this.type);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.syncId);
        buf.writeByte((int)this.type);
        PacketUpdateGui.writeField(buf, this.value, this.type);
    }

    @Override
    public void handleClientSide(PacketUpdateGui message, EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof ContainerPneumaticBase) {
            ((ContainerPneumaticBase)container).updateField(message.syncId, message.value);
        }
    }

    @Override
    public void handleServerSide(PacketUpdateGui message, EntityPlayer player) {
    }
}

