/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkPosition;
import pneumaticCraft.client.AreaShowManager;
import pneumaticCraft.common.network.LocationIntPacket;

public class PacketShowArea
extends LocationIntPacket<PacketShowArea> {
    private ChunkPosition[] area;

    public PacketShowArea() {
    }

    public PacketShowArea(int x, int y, int z, ChunkPosition ... area) {
        super(x, y, z);
        this.area = area;
    }

    public PacketShowArea(int x, int y, int z, Set<ChunkPosition> area) {
        this(x, y, z, area.toArray(new ChunkPosition[area.size()]));
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.area.length);
        for (ChunkPosition pos : this.area) {
            buffer.writeInt(pos.field_151329_a);
            buffer.writeInt(pos.field_151327_b);
            buffer.writeInt(pos.field_151328_c);
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.area = new ChunkPosition[buffer.readInt()];
        for (int i = 0; i < this.area.length; ++i) {
            this.area[i] = new ChunkPosition(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
    }

    @Override
    public void handleClientSide(PacketShowArea message, EntityPlayer player) {
        AreaShowManager.getInstance().showArea(message.area, 65535, message.getTileEntity(player.field_70170_p));
    }

    @Override
    public void handleServerSide(PacketShowArea message, EntityPlayer player) {
    }
}

