/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.common.inventory.ContainerLogistics;
import pneumaticCraft.common.network.LocationIntPacket;
import pneumaticCraft.common.semiblock.ISemiBlock;
import pneumaticCraft.common.semiblock.SemiBlockLogistics;
import pneumaticCraft.common.semiblock.SemiBlockManager;

public class PacketSetLogisticsFluidFilterStack
extends LocationIntPacket<PacketSetLogisticsFluidFilterStack> {
    private FluidStack settingStack;
    private int settingIndex;

    public PacketSetLogisticsFluidFilterStack() {
    }

    public PacketSetLogisticsFluidFilterStack(SemiBlockLogistics logistics, FluidStack stack, int index) {
        super(logistics.getPos().field_151329_a, logistics.getPos().field_151327_b, logistics.getPos().field_151328_c);
        this.settingStack = stack;
        this.settingIndex = index;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.settingStack != null);
        if (this.settingStack != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.settingStack.getFluid().getName());
            buf.writeInt(this.settingStack.amount);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.settingStack.tag);
        }
        buf.writeInt(this.settingIndex);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.settingStack = new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt(), ByteBufUtils.readTag((ByteBuf)buf));
        }
        this.settingIndex = buf.readInt();
    }

    @Override
    public void handleClientSide(PacketSetLogisticsFluidFilterStack message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketSetLogisticsFluidFilterStack message, EntityPlayer player) {
        if (message.x == 0 && message.y == 0 && message.z == 0) {
            if (player.field_71070_bA instanceof ContainerLogistics) {
                ((ContainerLogistics)player.field_71070_bA).logistics.setFilter(message.settingIndex, message.settingStack);
            }
        } else {
            ISemiBlock semiBlock = SemiBlockManager.getInstance(player.field_70170_p).getSemiBlock(player.field_70170_p, message.x, message.y, message.z);
            if (semiBlock instanceof SemiBlockLogistics) {
                ((SemiBlockLogistics)semiBlock).setFilter(message.settingIndex, message.settingStack);
            }
        }
    }
}

